/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "Debug.hpp"
#include "Round.hpp"

Round::Round() {}
Round::~Round() {}

Card Round::getCard(Common::PlayerPosition pos) const {
  return itsCards[pos];
}

void Round::setCard(Common::PlayerPosition pos, Card card) {
  itsCards[pos] = card;
}

void Round::reset() {
  for (int i = 0; i < Common::CARDS_PER_ROUND; i++) {
    itsCards[i].setNumber(Card::NoNumber);
    itsCards[i].setSuit(Card::NoSuit);
  }
}

Card::Suit Round::getSuit(Common::PlayerPosition pos) const {
  return itsCards[pos].getAdjSuit();
}

Common::PlayerPosition Round::getWinner(Common::PlayerPosition start,
					Card::Suit trump) const {
  int high_index = Common::NOPOS;
  int high_score = -1;

  Card::Suit suitLed = itsCards[start].getSuit();

  for (int i = 0; i < Common::CARDS_PER_ROUND; i++) {
    /* ignore bogus cards */
    if (itsCards[i].getSuit() == Card::NoSuit) {
      continue;
    }

    int this_score = itsCards[i].getValue(trump);

    /* don't mess with trump */
    if (this_score < Card::TrumpAdj) {
      if (itsCards[i].getSuit() != suitLed) {
	this_score = -1;
      }
    }

    if (this_score > high_score) {
      high_score = this_score;
      high_index = i;
    }
  }

  return (Common::PlayerPosition) high_index;
}

void Round::printRound() {
  for (int i = 0; i < Common::CARDS_PER_ROUND; i++) {
    printf("%c ", Common::getPlayerPositionChar((Common::PlayerPosition) i));
  }
  printf("\n");

  for (int i = 0; i < Common::CARDS_PER_ROUND; i++) {
    printf("%s ", itsCards[i].getName());
  }
  printf("\n");
}
