/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef OPTIONS_HPP
#define OPTIONS_HPP

#include "Common.hpp"

using namespace std;

class Options {
public:
  Options();
  ~Options();

  enum DelayMode {
    NODELAY = 0,
    SDELAY,
    MDELAY,
    LDELAY,
    PAUSE,
    DEFAULTDELAY = PAUSE
  };

  enum PointsForGame {
    MINPOINTS = 0,
    MAXPOINTS = 25,
    DEFAULTPOINTS = 10
  };
  
  enum Cheat {
    NOCHEAT = 0,
    POINTS  = 1,
    CARDS   = 2,
    DEFAULTCHEAT = NOCHEAT
  };

  enum AILevel {
    NOAILEVEL = -1,
    EASY = 0,
    MEDIUM = 1,
    HARD = 2,
    DEFAULTLEVEL = EASY
  };

  enum AIAgg {
    NOAIAGG = -1,
    MINAGG = 0,
    MIDAGG = 1,
    MAXAGG = 2,
    DEFAULTAGG = MINAGG
  };

  static  Options*  get();
  static  void      set(Options* opt);

  virtual void      init();
  virtual int       save();
  virtual int       load();

  DelayMode getDelayMode() { return (DelayMode) itsDelayMode; }
  Cheat     getCheat()     { return (Cheat) itsCheat; }

  int       getTricksForOnePoint() { return itsTricksOnePoint; }
  int       getPointsForGame() { return itsPointsForGame; }

  AILevel   getAILevel(Common::PlayerPosition pos);
  AIAgg     getAIAgg(Common::PlayerPosition pos);

  int       getAutoPlay() { return itsAutoPlay; }
  int       getDelayBetweenPlays() { return itsDelayBetweenPlays; }
  int       getAutoDealEnd() { return itsAutoDealEnd; }

  int       getPartnerLoner() { return itsPartnerLoner; }

  int       getStickTheDealer() { return itsStickTheDealer; }

  int       getDebug() { return itsDebug; }

protected:
  enum Version {
    INVALID_VERSION = 0xFFFFFFFF,
    FIRST_VERSION   = 0xFF000001,
    SECOND_VERSION  = 0xFF000002,
    THIRD_VERSION   = 0xFF000003,
    CURRENT_VERSION = THIRD_VERSION
  };
  
  virtual int writeOutOptions(FILE *fp);
  virtual int readInOptions(FILE *fp);
  virtual int normalizeOptions();

  int itsVersion;
  int itsDelayMode;
  int itsTricksOnePoint;
  int itsPointsForGame;
  int itsLevel[Common::PLAYERS_PER_GAME];
  int itsAgg[Common::PLAYERS_PER_GAME];
  int itsCheat;
  int itsAutoPlay;
  int itsDelayBetweenPlays;
  int itsAutoDealEnd;
  int itsPartnerLoner;
  int itsStickTheDealer;
  int itsDebug;

  static Options* itsOptions;
};

#endif
