/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef DECK_HPP
#define DECK_HPP

#include "Card.hpp"

class Deck {
public:
  enum {
    NUM_CARDS = 24
  };

  Deck();
  ~Deck();

  /* init to full deck */
  void init();

  /* remove a random card */
  Card removeCard();

  /* remove a specific card */
  void removeCard(const Card& card);

  /* add a card to the end of the deck */
  void addCard(const Card& card);

  /* return the cards in the deck as a string */
  const char* getCards();

protected:
  /* remove an index */
  Card removeCard(int index);

  Card itsCards[NUM_CARDS];
  int  itsCardsInDeck;
  string s;
};

#endif /* DECK_HPP */

