/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef COMMON_HPP
#define COMMON_HPP

#include "Card.hpp"

class Common {
public:
  enum Constants {
    CARDS_PER_HAND = 5,
    CARDS_PER_ROUND = 4,
    CARDS_PER_SUIT = 6,
    PLAYERS_PER_GAME = 4,
    ROUNDS_PER_GAME = CARDS_PER_HAND
  };

  enum PlayerPosition {
    NOPOS = -1,
    NORTH = 0,
    EAST,
    SOUTH,
    WEST
  };

  enum Bid {
    NOBID    = 0,
    PASS     = 1,
    PICKITUP = 2,
    LONER    = 3
  };

  static PlayerPosition getPartner(PlayerPosition pp);
  static char  getPlayerPositionChar(PlayerPosition pp);
  static char* getPlayerPositionStr(PlayerPosition pp);

  static char* getBidStr(Bid bid);

  static void setTrump(const Card::Suit aTrump);
  static Card::Suit getTrump();
};

#endif /* COMMON_HPP */
