/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <gtk/gtk.h>

#include <Options.hpp>
#include <pixmaps.hpp>

extern "C" {
#include "interface.h"
}

#include "support.hpp"
#include "globals.hpp"

/* local functions */
static void create_pixmaps();
static void create_cards(GtkWidget*);
static void create_bid_pixmaps(GtkWidget*);
static void create_markers(GtkWidget*);

int
main (int argc, char *argv[])
{

#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif

  gtk_init(&argc, &argv);

  /* create the top level windows */
  mainwin    = create_mainwin();
  prefdiag   = create_Preferences();
  prevdiag   = create_prevtrick();

  create_pixmaps();
  create_cards(mainwin);
  create_bid_pixmaps(mainwin);
  create_markers(mainwin);
  
  theGame = new GuiGame();

  GuiOptions::set(new GuiOptions());
  GuiOptions::get()->init();

  theGame->setOptions();

  gtk_widget_show(mainwin);
  gtk_main ();
  return 0;
}

static void create_pixmaps() {
  GdkColormap* gdk_c;
  GtkWidget*   gtk_w;
  
  char widget_name[256];
  for (int i = 0; i < NUM_CARD_BACKS; i++) {
    sprintf(widget_name, "cardback%d_pixmap", i);
    gtk_w = lookup_widget(prefdiag, widget_name);

    gdk_c = gtk_widget_get_colormap(gtk_w);

    cardbackSelectPixmaps[i] =
      gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_c,
					    &(cardbackSelectBitmaps[i]),
					    NULL, card_back_pixmap[i]);
    gtk_pixmap_set(GTK_PIXMAP(gtk_w), cardbackSelectPixmaps[i],
		   cardbackSelectBitmaps[i]);
    gdk_pixmap_unref(cardbackSelectPixmaps[i]);
    gdk_bitmap_unref(cardbackSelectBitmaps[i]);
  }
}

static void create_cards(GtkWidget* win) {
  int n, s;
  char pixmap_name[100];

  for (n = 0; n < (Card::Ace+1); n++) {
    for (s = 0; s < (Card::Spades+1); s++) {
      sprintf(pixmap_name, "card_%d_%d.xpm", n, s);
      cardPixmaps[n][s] = create_pixmap_d(win, card_pixmap_array[n][s]);

      gtk_widget_ref(cardPixmaps[n][s]);
      gtk_object_set_data_full(GTK_OBJECT (win), 
			       pixmap_name, cardPixmaps[n][s],
			       (GtkDestroyNotify) gtk_widget_unref);
      gtk_widget_show(cardPixmaps[n][s]);
    }
  }
}

static void create_bid_pixmaps(GtkWidget* win) {
  int  s;
  char pixmap_name[100];

  /* create each little suit pixmap */
  for (s = 0; s < (Card::Spades+1); s++) {
    sprintf(pixmap_name, "bid_%d.xpm", s);
    bidSuitPixmaps[s] = create_pixmap_d(win, suit_pixmap[s]);

    gtk_widget_ref(bidSuitPixmaps[s]);
    gtk_object_set_data_full(GTK_OBJECT(win), 
			     pixmap_name, bidSuitPixmaps[s],
			     (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show(bidSuitPixmaps[s]);
  }

  /* create the loner and team bid pixmaps */
  for (s = 0; s < 2; s++) {
    bidCallPixmaps[s] = create_pixmap_d(win, bid_pixmap[s]);

    gtk_widget_ref(bidCallPixmaps[s]);
    gtk_widget_show(bidCallPixmaps[s]);
  }
  
  /* create empty pixmaps to use as pads */
  for (s = 0; s < Common::PLAYERS_PER_GAME; s++) {
    bidEmptyPixmaps[s] = create_pixmap_d(win, bid_empty_pixmap);

    gtk_widget_ref(bidEmptyPixmaps[s]);
    gtk_widget_show(bidEmptyPixmaps[s]);

    bidSuitEmptyPixmaps[s] = create_pixmap_d(win, bid_empty_pixmap);

    gtk_widget_ref(bidSuitEmptyPixmaps[s]);
    gtk_widget_show(bidSuitEmptyPixmaps[s]);
  }

  /* create pixmaps to put onto the bid buttons */
  GdkColormap* gdk_c;
  GdkPixmap*   gdk_p;
  GdkBitmap*   gdk_m;
  GtkWidget*   gtk_w;
  char widget_name[256];
  
  for (s = 0; s < (Card::Spades+1); s++) {
    sprintf(widget_name, "bid_pixmap_%d", s);
    gtk_w = lookup_widget(win, widget_name);

    gdk_c = gtk_widget_get_colormap(gtk_w);
    gdk_p = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_c, &gdk_m,
						  NULL, suit_pixmap[s]);
    
    gtk_pixmap_set(GTK_PIXMAP(gtk_w), gdk_p, gdk_m);
    gdk_pixmap_unref(gdk_p);
    gdk_bitmap_unref(gdk_m);
  }
}

void create_markers(GtkWidget* win) {
  for (int p = 0; p < Common::PLAYERS_PER_GAME; p++) {
    passMarkers[p] = create_pixmap_d(win, pass_marker_pixmap);
    
    gtk_widget_ref(passMarkers[p]);
    gtk_object_set_data_full(GTK_OBJECT(win), 
			     "pass_marker", passMarkers[p],
			     (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show(passMarkers[p]);

    emptyMarkers[p] = create_pixmap_d(win, empty_marker_pixmap);

    gtk_widget_ref(emptyMarkers[p]);
    gtk_object_set_data_full(GTK_OBJECT(win), 
			     "empty_marker", emptyMarkers[p],
			     (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show(emptyMarkers[p]);

  }

  GtkWidget* ttt = lookup_widget(win, "marker_table");

  gtk_table_attach(GTK_TABLE(ttt), emptyMarkers[0],
		   1, 2, 0, 1,
		   (GtkAttachOptions) (GTK_FILL),
		   (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_table_attach(GTK_TABLE(ttt), emptyMarkers[1],
		   2, 3, 1, 2, 
		   (GtkAttachOptions) (GTK_FILL),
		   (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_table_attach(GTK_TABLE(ttt), emptyMarkers[2],
		   1, 2, 2, 3,
		   (GtkAttachOptions) (GTK_FILL),
		   (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_table_attach(GTK_TABLE(ttt), emptyMarkers[3],
		   0, 1, 1, 2,
		   (GtkAttachOptions) (GTK_FILL),
		   (GtkAttachOptions) (GTK_FILL), 0, 0);
}
