/*

    Euchre - a free as in freedom and as in beer version of the 
             euchre card game
  
    Copyright 2002 C Nathan Buckles (nbuckles@bigfoot.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <gtk/gtk.h>

#include <Debug.hpp>

#include "globals.hpp"
#include "support.hpp"
#include "ComputerGuiPlayer.hpp"

ComputerGuiPlayer::ComputerGuiPlayer(Common::PlayerPosition myPos,
				     Player* theAI) :
  Player(myPos), GuiPlayer(myPos), itsAI(theAI) {}

ComputerGuiPlayer::~ComputerGuiPlayer() {
  if (itsAI != NULL) {
    delete itsAI;
  }
}

void ComputerGuiPlayer::setHand(const Hand& theHand) {
  Player::setHand(theHand);
  itsAI->setHand(theHand);
}

void ComputerGuiPlayer::setTopCard(const Card& upCard) {
  setCardPixmap(cardPixmaps[upCard.getNumber()][upCard.getSuit()]);
}

void ComputerGuiPlayer::unsetTopCard() {
  setCardPixmap(itsOldPixmap);
}


Common::Bid ComputerGuiPlayer::auction1(const Card& upCard,
					Common::PlayerPosition dealer) {
  LOG("%d enter cgp::auction1\n", itsPos);
  
  Common::Bid ret = itsAI->auction1(upCard, dealer);

  if (ret != Common::PASS) {
    setBidSuitPixmap(bidSuitPixmaps[upCard.getSuit()]);

    if (ret == Common::PICKITUP) {
      setBidCallPixmap(bidCallPixmaps[0]);
    } else {
      setBidCallPixmap(bidCallPixmaps[1]);
    }
    
    LOG("going for it with %s value %d\n", itsHand.getName(), itsHand.getValue(upCard.getSuit()));
  } else {
    setMarker(passMarkers[itsPos]);
  }

  LOG("%d exit cgp::auction1 with %d\n", itsPos, ret);
  return ret;
}

void ComputerGuiPlayer::auction1End(const Card& upCard) {
  setCardPixmap(itsOldPixmap);
  itsAI->auction1End(upCard);
  setMarker(NULL);
}

Common::Bid ComputerGuiPlayer::auction2(Card& yourTrump,
					const Card& upCard,
					bool stuck) {
  LOG("%d enter cgp::auction2\n", itsPos);

  Common::Bid ret = itsAI->auction2(yourTrump, upCard, stuck);
		 
  if (ret != Common::PASS) {
    setBidSuitPixmap(bidSuitPixmaps[yourTrump.getSuit()]);

    if (ret == Common::PICKITUP) {
      setBidCallPixmap(bidCallPixmaps[0]);
    } else {
      setBidCallPixmap(bidCallPixmaps[1]);
    }

    LOG("going for it with %s value %d trump %c\n",
	itsHand.getName(), itsHand.getValue(yourTrump.getSuit()),
	yourTrump.getSuitChar());
  } else {
    setMarker(passMarkers[itsPos]);
  }

  LOG("%d exit cgp::auction2 with %d\n", itsPos, ret);
  return ret;
}

void ComputerGuiPlayer::setBid(Common::PlayerPosition who,
			       Common::Bid bid) {
  itsAI->setBid(who, bid);
  setMarker(NULL);
}

void ComputerGuiPlayer::setTrump(Card::Suit trump) {
  LOG("%d enter cgp::setTrump\n", itsPos);

  setCardPixmap(itsOldPixmap);
  itsAI->setTrump(trump);

  LOG("%d exit cgp::setTrump\n", itsPos);
}

Card ComputerGuiPlayer::getCard(const Round& theRound, 
				Common::PlayerPosition whoStarted) {
  LOG("%d enter cgp::getCard\n", itsPos);

  LOG(" %d  hand is %s\n", itsPos, itsAI->getHand().getName());
  Card ret = itsAI->getCard(theRound, whoStarted);
  LOG(" %d cgp::getCard with %s\n", itsPos, ret.getName());
  setCardPixmap(cardPixmaps[ret.getNumber()][ret.getSuit()]);
  LOG(" %d hand is %s", itsPos, itsAI->getHand().getName());

  LOG("%d exit cgp::getCard with %s\n", itsPos, ret.getName());
  return ret;
}

void ComputerGuiPlayer::finishRound(const Round& theRound,
				    Common::PlayerPosition whoStarted) {
  LOG("%d enter cgp finishRound\n");

  setCardPixmap(itsOldPixmap);
  itsAI->finishRound(theRound, whoStarted);

  LOG("%d exit cgp finishRound\n", itsPos);
}

void ComputerGuiPlayer::allPass() {
  setCardPixmap(itsOldPixmap);
  setMarker(NULL);
  itsAI->allPass();
}

Card ComputerGuiPlayer::discard(Card& newCard) {
  return itsAI->discard(newCard);
}

void ComputerGuiPlayer::finishDeal(int NSPoints, int EWPoints) {
  itsAI->finishDeal(NSPoints, EWPoints);
  setBidSuitPixmap(NULL);
  setBidCallPixmap(NULL);
}
