: @SYSCONFDIR@/@EBN@.login - " Modify to taste. "
:
: "  The author of this file, J.A. Neitzel <jan (at) etsh (dot) io>,  "
: "  hereby grants it to the public domain.                           "
:
: "  From:  https://etsh.io/rc_files  "
:

trap : 1 2 3 13 14 15 ; : " Ignore HUP, INT, QUIT, PIPE, ALRM, and TERM. "
trap : 18 21 22 ;       : " Ignore job-control signals: TSTP, TTIN, TTOU "

: fd2 -e echo "debug: Executing `@SYSCONFDIR@/@EBN@.login' now..."

unset X
set   X "@PREFIX@" ; : " This is the PREFIX where shell is installed; it "
		   ; : " may be /etroot, /usr/local, or something else.  "

:
: " Set a default umask and PATH for all (root & !root) users. "
:
umask 0022
if "$k" -ne 0 -a "$u" != root goto NotRoot
	: " The desire here is to use the default OpenBSD root PATH. "
	setenv	PATH	/sbin:/usr/sbin:/bin:/usr/bin:/usr/X11R6/bin
	setenv	PATH	$p:/usr/local/sbin:/usr/local/bin
	goto Continue

: NotRoot
	: " The desire here is that etsh & tsh are in the 1st PATH directory "
	: " (or as close to the beginning of the user's PATH as possible)... "
	if "$X" != "/etroot" goto nr-/usr/local
		setenv	PATH	/bin:/usr/bin:/sbin:/usr/sbin:/usr/X11R6/bin
		setenv	PATH	$p:/usr/local/bin:/usr/local/sbin:/usr/games
		goto nr-jump1
	: nr-/usr/local
	if "$X" != "/usr/local" goto nr-something-else
		setenv	PATH	$X/bin:/bin:/usr/bin:/sbin:/usr/sbin:/usr/X11R6/bin
		setenv	PATH	$p:$X/sbin:/usr/games
		goto nr-jump1
	: nr-something-else
		: " This is the default again; sysadmin can modify as desired. "
		setenv	PATH	/bin:/usr/bin:/sbin:/usr/sbin:/usr/X11R6/bin
		setenv	PATH	$p:/usr/local/bin:/usr/local/sbin:/usr/games
		: fallthrough
	: nr-jump1
		: setenv	PATH	$p:. ; : " . in PATH? not recommended! "
		: fallthrough

: Continue
	: fd2 -e echo "debug: $k $u: \$p == $p"

: " ==== PATH gets some additions in @SYSCONFDIR@/@EBN@.@EBN@rc ==== "

	setenv MAIL /var/mail/$u
	stty status '^T' <-
	: fallthrough

set D /tmp/@EBN@-$$
if ! { mkdir -m 0700 $D } goto Finish

	:
	: " Set $T and/or setenv CTTY as needed. "
	:
	set S 0
	printenv CTTY | wc -l | tr -d ' ' | grep '^1$' >/dev/null
	if $? -ne 0 goto NoCtty
		( \
		   echo -n 'set T "' ; printenv CTTY | tr -d '\n' ; echo '"' \
		) >$D/TisCTTY
		source $D/TisCTTY
		set S 1
		rm $D/TisCTTY
		: fallthrough
	: NoCtty
		if $S -eq 1 goto TisCTTY
			setenv CTTY $t
			set    T    $t
		: TisCTTY
			: fallthrough
	unset S

	:
	: " Use the output from `uname -n' to `setenv HOST value'. "
	:
	uname -n | sed 's,\([^.]*\).*,setenv HOST \1,' >$D/HOST
	source $D/HOST ; rm -r $D
	: fallthrough

: Finish

unset D
trap - 1 2 3 13 14 15 ; : " Reset the ignored, non-job-control signals. "
