#include "etpan-abook-driver.h"
#include <stdlib.h>
#include "etpan-errors.h"

int etpan_abook_lookup(struct etpan_abook * abook,
      const char * key, carray ** result)
{
  if (abook->driver->lookup == NULL)
    return ERROR_NOT_IMPLEMENTED;
  
  return abook->driver->lookup(abook, key, result);
}

int etpan_abook_connect(struct etpan_abook * abook)
{
  int r;

  if (abook->connected)
    return NO_ERROR;
  
  if (abook->driver->connect == NULL)
    return ERROR_NOT_IMPLEMENTED;
  
  r = abook->driver->connect(abook);
  if (r == NO_ERROR)
    abook->connected = 1;
  
  return r;
}

void etpan_abook_free(struct etpan_abook * abook)
{
  if (abook->driver->uninitialize != NULL)
    abook->driver->uninitialize(abook);
  
  free(abook);
}

struct etpan_abook_entry * etpan_abook_entry_new(char * name,
    char * addr, char * nick)
{
  struct etpan_abook_entry * entry;
  
  entry = malloc(sizeof(* entry));
  if (entry == NULL)
    return NULL;
  
  entry->name = name;
  entry->addr = addr;
  entry->nick = nick;
  
  return entry;
}

void etpan_abook_entry_free(struct etpan_abook_entry * entry)
{
  free(entry->nick);
  free(entry->name);
  free(entry->addr);
  free(entry);
}
