vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO KhronosGroup/OpenCL-Headers
    REF a51354a85f41d203e755124ad51ae3425933df45
    SHA512 007f852c10f486c67696a278766790102369306aea2aa0f9b238ef167868c76771e4f6a11abb01bb3614defea501f295a97684a48531865a68299e69704bedca
    HEAD_REF master
)

file(INSTALL "${SOURCE_PATH}/CL" DESTINATION ${CURRENT_PACKAGES_DIR}/include)

# OpenCL C++ headers
vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO KhronosGroup/OpenCL-CLHPP
    REF 4a1157466afe72a87e8abc59537ef577534ccadf
    SHA512 8b2f6dfecba649f3eca1c6b7ef825602215bf911fb08cc0745d0d3bb627d6edd9e95cf2355ba55718686d3604421ec632c2c3381040f73861bd0218fcfc60c57
    HEAD_REF master
)

file(INSTALL "${SOURCE_PATH}/include/CL" DESTINATION ${CURRENT_PACKAGES_DIR}/include)

# OpenCL ICD loader
vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO KhronosGroup/OpenCL-ICD-Loader
    REF 4aa683775c4ee55594196c79def7a75103d75e4c
    SHA512 319e33de9fd10da333e5928856d3c3f5a5d5b1b33cf57e395217cb70098588f7959c68f81fd52cd9d5717d334d2e187d29a6591cac249b7bfd65731f0f120f90
    HEAD_REF master
)

string(COMPARE EQUAL ${VCPKG_CRT_LINKAGE} dynamic USE_DYNAMIC_VCXX_RUNTIME)

vcpkg_cmake_configure(
    SOURCE_PATH ${SOURCE_PATH}
    OPTIONS
        -DOPENCL_ICD_LOADER_HEADERS_DIR=${CURRENT_PACKAGES_DIR}/include
)

vcpkg_cmake_build(TARGET OpenCL)

if (VCPKG_LIBRARY_LINKAGE STREQUAL static)
  if (NOT DEFINED VCPKG_BUILD_TYPE OR VCPKG_BUILD_TYPE STREQUAL "release")
    file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-rel/${VCPKG_TARGET_STATIC_LIBRARY_PREFIX}OpenCL${VCPKG_TARGET_STATIC_LIBRARY_SUFFIX}" DESTINATION ${CURRENT_PACKAGES_DIR}/lib)
  endif()
  if (NOT DEFINED VCPKG_BUILD_TYPE OR VCPKG_BUILD_TYPE STREQUAL "debug")
    file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-dbg/${VCPKG_TARGET_STATIC_LIBRARY_PREFIX}OpenCL${VCPKG_TARGET_STATIC_LIBRARY_SUFFIX}" DESTINATION ${CURRENT_PACKAGES_DIR}/debug/lib)
  endif()
else()
  if(VCPKG_TARGET_IS_WINDOWS)
    if (NOT DEFINED VCPKG_BUILD_TYPE OR VCPKG_BUILD_TYPE STREQUAL "release")
      file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-rel/${VCPKG_TARGET_SHARED_LIBRARY_PREFIX}OpenCL${VCPKG_TARGET_IMPORT_LIBRARY_SUFFIX}" DESTINATION ${CURRENT_PACKAGES_DIR}/lib)
      file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-rel/${VCPKG_TARGET_SHARED_LIBRARY_PREFIX}OpenCL${VCPKG_TARGET_SHARED_LIBRARY_SUFFIX}" DESTINATION ${CURRENT_PACKAGES_DIR}/bin)
    endif()
    if (NOT DEFINED VCPKG_BUILD_TYPE OR VCPKG_BUILD_TYPE STREQUAL "debug")
      file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-dbg/${VCPKG_TARGET_SHARED_LIBRARY_PREFIX}OpenCL${VCPKG_TARGET_IMPORT_LIBRARY_SUFFIX}" DESTINATION ${CURRENT_PACKAGES_DIR}/debug/lib)
      file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-dbg/${VCPKG_TARGET_SHARED_LIBRARY_PREFIX}OpenCL${VCPKG_TARGET_SHARED_LIBRARY_SUFFIX}" DESTINATION ${CURRENT_PACKAGES_DIR}/debug/bin)
    endif()
  elseif(VCPKG_TARGET_IS_LINUX)
    if (NOT DEFINED VCPKG_BUILD_TYPE OR VCPKG_BUILD_TYPE STREQUAL "release")
      file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-rel/${VCPKG_TARGET_SHARED_LIBRARY_PREFIX}OpenCL${VCPKG_TARGET_SHARED_LIBRARY_SUFFIX}" DESTINATION ${CURRENT_PACKAGES_DIR}/lib)
      file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-rel/${VCPKG_TARGET_SHARED_LIBRARY_PREFIX}OpenCL${VCPKG_TARGET_SHARED_LIBRARY_SUFFIX}.1" DESTINATION ${CURRENT_PACKAGES_DIR}/lib)
      file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-rel/${VCPKG_TARGET_SHARED_LIBRARY_PREFIX}OpenCL${VCPKG_TARGET_SHARED_LIBRARY_SUFFIX}.1.2" DESTINATION ${CURRENT_PACKAGES_DIR}/lib)
    endif()
    if (NOT DEFINED VCPKG_BUILD_TYPE OR VCPKG_BUILD_TYPE STREQUAL "debug")
      file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-dbg/${VCPKG_TARGET_SHARED_LIBRARY_PREFIX}OpenCL${VCPKG_TARGET_SHARED_LIBRARY_SUFFIX}" DESTINATION ${CURRENT_PACKAGES_DIR}/debug/lib)
      file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-dbg/${VCPKG_TARGET_SHARED_LIBRARY_PREFIX}OpenCL${VCPKG_TARGET_SHARED_LIBRARY_SUFFIX}.1" DESTINATION ${CURRENT_PACKAGES_DIR}/debug/lib)
      file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-dbg/${VCPKG_TARGET_SHARED_LIBRARY_PREFIX}OpenCL${VCPKG_TARGET_SHARED_LIBRARY_SUFFIX}.1.2" DESTINATION ${CURRENT_PACKAGES_DIR}/debug/lib)
    endif()
  elseif(VCPKG_TARGET_IS_OSX)
    if (NOT DEFINED VCPKG_BUILD_TYPE OR VCPKG_BUILD_TYPE STREQUAL "release")
      file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-rel/lib/${VCPKG_TARGET_SHARED_LIBRARY_PREFIX}OpenCL${VCPKG_TARGET_SHARED_LIBRARY_SUFFIX}" DESTINATION ${CURRENT_PACKAGES_DIR}/lib)
    endif()
    if (NOT DEFINED VCPKG_BUILD_TYPE OR VCPKG_BUILD_TYPE STREQUAL "debug")
      file(INSTALL "${CURRENT_BUILDTREES_DIR}/${TARGET_TRIPLET}-dbg/lib/${VCPKG_TARGET_SHARED_LIBRARY_PREFIX}OpenCL${VCPKG_TARGET_SHARED_LIBRARY_SUFFIX}" DESTINATION ${CURRENT_PACKAGES_DIR}/debug/lib)
    endif()
  endif()
endif()

vcpkg_copy_pdbs()

file(COPY ${CMAKE_CURRENT_LIST_DIR}/usage DESTINATION ${CURRENT_PACKAGES_DIR}/share/${PORT})
file(INSTALL "${SOURCE_PATH}/LICENSE" DESTINATION ${CURRENT_PACKAGES_DIR}/share/${PORT} RENAME copyright)
file(COPY ${CMAKE_CURRENT_LIST_DIR}/vcpkg-cmake-wrapper.cmake DESTINATION ${CURRENT_PACKAGES_DIR}/share/${PORT})
