# Every update requires an update of these hashes and the version within the control file of each of the 32 ports.
# So it is probably better to have a central location for these hashes and let the ports update via a script
set(QT_MAJOR_MINOR_VER 5.15)
set(QT_PATCH_VER 6)
set(QT_UPDATE_VERSION 0) # Switch to update qt and not build qt. Creates a file cmake/qt_new_hashes.cmake in qt5-base with the new hashes.

set(QT_PORT_LIST base 3d activeqt charts connectivity datavis3d declarative gamepad graphicaleffects imageformats location macextras mqtt multimedia networkauth
                 purchasing quickcontrols quickcontrols2 remoteobjects script scxml sensors serialport speech svg tools virtualkeyboard webchannel websockets
                 webview winextras xmlpatterns doc x11extras androidextras translations serialbus webengine webglplugin wayland)

set(QT_HASH_qt5-3d               33fe30bd08d352b1e80fa62b344bfb3d69b1d3220a65ffbdb0b92fd4aa134ad7f923bc827753bb8f6c42f51ea1ef723acb8655b19b0b42f9bb450dda42937527)
set(QT_HASH_qt5-activeqt         95f701bed16f7d5c6152a95dd725e7143538ec6e08af54715aba4f45d364dfbfa2f2b2599132fa5d979a509dc4378404867ca0bb068a6a23d90c4041ced427f6)
set(QT_HASH_qt5-androidextras    b818c5894134812eed976a6b8b5b5aa94bdd8baaeda90820dacf85af9d2093ce9619c8990436afb5ce261e7b6f45c4ccbbd38b2473bf2bde851338cd299f5d05)
set(QT_HASH_qt5-base             4fc6973b9250cd78c4797ed9bb58bec949243cc5e8c3a546b5fbe8c6e6480d5e0745d273fac812f9f5f1fcd675cd8b867d47f57563bf6d23118b58032550103f)
set(QT_HASH_qt5-charts           b3f3594a1fd648a6afd459c8165d74690902240ef826a8bd87245ea49464aabcf5c0d4094ce1035de1d40e7e49d95dc381db37f8f4c4735265cb60241666715e)
set(QT_HASH_qt5-connectivity     8d6b634b46aca9a54a391cad9be056d5bac70401dc4d94426fb7a6038c12608ba2cb94cdafe3e8786d2f0a00aa7e60dc92fcca7ef09d136e1bd9763e2868d20a)
set(QT_HASH_qt5-datavis3d        921f2d050b6b61824e308f9d8dd095da002914b28568403214ed727055eb9fdd43d8b71190bf0b1dc82df4333d6d65b2d5ac61f3646f711c693dec2a46967a96)
set(QT_HASH_qt5-declarative      a4824b6ec2de5e78819b726850767db6d4280208d6cc985219f4c33b6b0dcd6194557f32b577df97b0596d157190aa9c00e99bf6879554936a356fa7afe8a7d5)
set(QT_HASH_qt5-doc              9f510d2bfa4174b66547b5ab3bfd08c2b04a2267f926066a006058b97de6722d5c15b147ffda9f726f4c634639df7e29452b2a91820e08d235c7a58cbb39102e)
set(QT_HASH_qt5-gamepad          6faa59ea92d8046e6b377fd18f7049dbe4b230ab591f0513c2de974df723a77b0845339cf7d7507bb4415f005d21754dd8dc35a1082c7b86f63a0a5fdbdb8126)
set(QT_HASH_qt5-graphicaleffects 2de1f6a0a980949d02baaaa7576e628faf34bea10fa7e11e9ad7da5ae0511449f8edf98558f77ecf7727d26f0d2f13c5389f73d128cceef71cdef6788050d689)
set(QT_HASH_qt5-imageformats     a1b86db145d73933295b355156b401177e2c61e39beb6114ce9e7cfef693697e019c1a1299e18153542d7c229fa95e1b122812d2058ad66da28b78e521da9d30)
set(QT_HASH_qt5-location         25ea53bfc5dd8569931eaa5bba7e0021377f747d0304d1320cbfa5a87d052fbee86330d23dc0516be618cd6380216212a0b2e981a2ce4e1b6cb571995d3b0684)
set(QT_HASH_qt5-macextras        679f752dfa53a4fbfd9e950407da7d1f2ce505e4bf58083a99812d339cc1163c5be5b0ace4a81fee7a58a8a9322fbf8d04ac5835dcfcf1570396dc01ffb25cdc)
set(QT_HASH_qt5-mqtt             ef4891cff6388f515e70a3d1eea05b5ac0251e0fa2e258b91b3d03e9a565438153068b0949870348acbb0e781dd85b2ef649a6833af2a68bdcf2d4c472ffb172)
set(QT_HASH_qt5-multimedia       abf07c26e4aba1442c506e06d91cb584c4a3d04c8e572b7d3aaa5a2341cd5609af2604e352557bda9f6bbe015793d24c43b1d580f60568cd1051515f541e342d)
set(QT_HASH_qt5-networkauth      04d5f07f5076dbd8e5bd435e7e91605819574dcab16217e9b49e60b3932db09d9c0f8088cd705fba5da7eddf98df1a61f2fcf7640f942ba6ee87576994268445)
set(QT_HASH_qt5-purchasing       39325482c97fd5ec0cfcf6bde14e0bedfd7b61902493d15916644010802220b5188b130a6cd011b906c8da9f4993a62be579f94df659f9eddde3fd97e9897afe)
set(QT_HASH_qt5-quickcontrols    43aa77ee50f95c8546abea2cd307cdcc3810cc20c8a373e7941675d62702bf8294078cf5cec89d8d26dd9eec5c025b712db1bdc1b1acb264f38368f0662e9829)
set(QT_HASH_qt5-quickcontrols2   5de1ae719c394a315dc019bdaa876b6b735ca5eed4455b6c4da5e2150c0bc85a6c691ad9124b76e26704aaf799b6067d47fe48d98926ea000407d163441d4114)
set(QT_HASH_qt5-remoteobjects    7cad6d7b03267a566044ae97ef23bcf66fa6ae7da7b4e6fc3c8e5082518ae1ec9ab00ceb935ced857696fafc5d3346df3f2b083793f2f520bb146fdbf6c54242)
set(QT_HASH_qt5-script           1ea055d5ee8a80ac1919fe1e0e59e011654ccf5e1392f49933b104c8ff390755b3677c34981c168a8e492600d0243fd2d8f3c0f87bf44a61a55c763149a1ccc8)
set(QT_HASH_qt5-scxml            6ba6edcb69dc43be58a150cfa21537251c6944051a9d01ec68272f91ce64399ad5a9c37dd0cccc8903dd76de0e04369d79e38bbe96ec55bdc9f970ede137b3e3)
set(QT_HASH_qt5-sensors          1937e7fc466bf0ad679fa1ec9f876015791d42a9a89f17449a2585451c5b3fc13c523930416da535c88babc016f52d35537d837a62cdb4e1de1c7d81a5d0e511)
set(QT_HASH_qt5-serialbus        b972d312be8bc822282fff48c20d2330edf14aa5e7ebd6b5b9a03b61b21fc637ad4d969d55e35b145a7bddc967a9e9dda17e2df14df3ab0151d08898468c1230)
set(QT_HASH_qt5-serialport       8161b4aba2c7410b878482035b5bc141083953dcaf466361ff3d30b6e397ab78e84f698dcbc14f4218e2c175efcb8c9ee494f75d6099a1215b5be6a378c8a322)
set(QT_HASH_qt5-speech           e20e3d59804bc6ee8ce65cd10e61aabc3771ebd7d20c853b8c6358b08bfbe0796905b50efcdc755857388bcb8528d18ec2bd8e5840bd2500f5f5ee5e043ea47d)
set(QT_HASH_qt5-svg              8e6e35a098baaae03043c1c177c2e93bc6c8bec1094b3becd797cddc1b62d24f51956b84a4e6bbe0565069f862243a791285232f78d4a0c2281344308071ef17)
set(QT_HASH_qt5-tools            8539930c3facb4a2b43ce7f76f461181489952d79c4d9e11c8acf6b342c3466f5868adcef1a1bfdfa9c142217c0e43853c3297fc0701030c63d0b349e0767297)
set(QT_HASH_qt5-translations     36baebb9a5b34d9965d087b5f0a509a8a83086db61eed54a9cad63f4a548d32c4809007b2f6dad7c983fa0cbaf5fe7ab016ec244546feb824cdd2c78347aee16)
set(QT_HASH_qt5-virtualkeyboard  e0aed691a381067c9a5d7f76bdafc15c6df4b5f04f86b09f0dc6d4fced4181dcc676792efd2718bc530d3c50759b0d2666261a9cf6bc522ff75907e2bb717de6)
set(QT_HASH_qt5-wayland          824cb4dfd2bd9d858f38430332a359cf6cd2b256c91b0bafcbe49c8847cb41a7ced79ef8abd5469170837525639df26fcbcdfb49ffefc4fc4cde0830d9afe98c)
set(QT_HASH_qt5-webchannel       8c82f040f9aa5cb5c8a927fc770123bbc5dfffd4d6ab243da86a53eb2aee1ab9b7f14d8f7e9b2dbd42728f203158d1ad46b488c6221e589777fed150b2e467d7)
set(QT_HASH_qt5-webengine        775d44612a81314c914bf03e8d368d6426516cdd9ce15e50513b346a85f94da603a5c65343d3ed6aecd442ac38a2273f38deae161916cd0c008e473b2606962b)
set(QT_HASH_qt5-webglplugin      665dcd971f1995567f4a8f2ca8ed4201f2aa0829e091c30e5e5420a99c76ef5882429197fb852f2d4a3fbb62cae0e072ab82233804b7f98aa342a179de5c1124)
set(QT_HASH_qt5-websockets       b2ab319bfd9b0839ee2aa23d508b96a4e86e02a3cab1fec7a1282cfc018e5baf7aa5340d3749f237562f8f74e562e49cd31432e5bed8db781f158aaba914068b)
set(QT_HASH_qt5-webview          bb6e70a95899cb129dc11d565587cfd9f5d0ca09b40357ab404d1f74e77d7cb3c420362c5cbb4b74fa864449c1d8cd3cef2b4b50caad242f1941378e877cee7a)
set(QT_HASH_qt5-winextras        d2ff6b4b0831d78e44a7434ac43fd9174f08a904fdb3c076ef829379b06ea499c8962daaa450fa2c320224aad00c0aa567ab4d6f789de7a7ded952d159b3adc8)
set(QT_HASH_qt5-x11extras        6c651cdfd5c3420877e8d9e5a90119401f516beb42d814255520c8223b34dbaca40da23f8d8e218ce933a76fd415e62a2aa0334359594053ce6becaf08150cd6)
set(QT_HASH_qt5-xmlpatterns      b4070f33d4b590af6dcb40decd4fdcc44f53897eacc7af65ac0e718b9e4c8f8ebbf6e5700ca4b293a6c0a41fc49c4f540b918749e8f3493f0a290e567dc2a95b)

if(QT_UPDATE_VERSION)
    message(STATUS "Running Qt in automatic version port update mode!")
    set(_VCPKG_INTERNAL_NO_HASH_CHECK 1)
    if("${PORT}" MATCHES "qt5-base")
        function(update_qt_version_in_manifest _port_name)
            set(_current_control "${VCPKG_ROOT_DIR}/ports/${_port_name}/vcpkg.json")
            file(READ ${_current_control} _control_contents)
            #message(STATUS "Before: \n${_control_contents}")
            string(REGEX REPLACE "\"version.*\": \"[0-9]+\.[0-9]+\.[0-9]+\",\n" "\"version\": \"${QT_MAJOR_MINOR_VER}.${QT_PATCH_VER}\",\n" _control_contents "${_control_contents}")
            string(REGEX REPLACE "\n  \"port-version\": [0-9]+," "" _control_contents "${_control_contents}")
            #message(STATUS "After: \n${_control_contents}")
            file(WRITE ${_current_control} "${_control_contents}")
            configure_file("${_current_control}" "${_current_control}" @ONLY NEWLINE_STYLE LF)
        endfunction()

        update_qt_version_in_manifest("qt5")
        foreach(_current_qt_port_basename ${QT_PORT_LIST})
            update_qt_version_in_manifest("qt5-${_current_qt_port_basename}")
        endforeach()
    endif()
endif()
