
vcpkg_from_github(OUT_SOURCE_PATH SOURCE_PATH
    REPO DragonJoker/ShaderWriter
    REF v1.0.0
    SHA512 60e63dd1f519869a5e3b8d4ee699339b2d26dea2a7502d16de578b6164131ea4954b7731a89763cd6a3a4750a1eb15afc2592261cc7c8209e8a3667edecdb94b
)

vcpkg_from_github(OUT_SOURCE_PATH CMAKE_SOURCE_PATH
    REPO DragonJoker/CMakeUtils
    REF 811d4acb15de70cb81e2a5788333ba4b50d89e81
    HEAD_REF master
    SHA512 b546cabc0f1a7c0e73abe22a742629c7e6d9bef7ed2d1de8a528369931e1871a9902d38efc8f77a3aec9923d62ca328b0c3c8c6c51f2ff527682a3197550dae7
)

get_filename_component(SRC_PATH ${CMAKE_SOURCE_PATH} DIRECTORY)
if (EXISTS ${SRC_PATH}/CMake)
    file(REMOVE_RECURSE ${SRC_PATH}/CMake)
endif()
file(RENAME ${CMAKE_SOURCE_PATH} ${SRC_PATH}/CMake)
set(CMAKE_SOURCE_PATH ${SRC_PATH}/CMake)
file(COPY ${CMAKE_SOURCE_PATH} DESTINATION ${SOURCE_PATH})

string(COMPARE EQUAL "${VCPKG_LIBRARY_LINKAGE}" "static" BUILD_STATIC)

vcpkg_configure_cmake(
    SOURCE_PATH ${SOURCE_PATH}
    PREFER_NINJA
    OPTIONS
        -DPROJECTS_USE_PRECOMPILED_HEADERS=OFF
        -DSDW_GENERATE_SOURCE=OFF
        -DSDW_BUILD_VULKAN_LAYER=OFF
        -DSDW_BUILD_TESTS=OFF
        -DSDW_BUILD_STATIC_SDW=${BUILD_STATIC}
        -DSDW_BUILD_EXPORTER_GLSL_STATIC=${BUILD_STATIC}
        -DSDW_BUILD_EXPORTER_HLSL_STATIC=${BUILD_STATIC}
        -DSDW_BUILD_EXPORTER_SPIRV_STATIC=${BUILD_STATIC}
)

vcpkg_install_cmake()
vcpkg_fixup_cmake_targets(CONFIG_PATH lib/cmake/shaderwriter)

file(INSTALL ${SOURCE_PATH}/LICENSE DESTINATION ${CURRENT_PACKAGES_DIR}/share/${PORT} RENAME copyright)