if (VCPKG_TARGET_IS_WINDOWS)
    vcpkg_check_linkage(ONLY_DYNAMIC_LIBRARY)
endif()

vcpkg_download_distfile(ARCHIVE
    URLS "https://ftp.gnome.org/pub/GNOME/sources/atkmm/2.24/atkmm-2.24.2.tar.xz"
    FILENAME "atkmm-2.24.2.tar.xz"
    SHA512 427714cdf3b10e3f9bc36df09c4b05608d295f5895fb1e079b9bd84afdf7bf1cfdec6794ced7f1e35bd430b76f87792df4ee63c515071a2ea6e3e51e672cdbe2
)

vcpkg_extract_source_archive_ex(
    OUT_SOURCE_PATH SOURCE_PATH
    ARCHIVE ${ARCHIVE}
    PATCHES
        fix_properties.patch
        fix_charset.patch
)

if (VCPKG_TARGET_IS_WINDOWS)
    file(COPY ${CMAKE_CURRENT_LIST_DIR}/msvc_recommended_pragmas.h DESTINATION ${SOURCE_PATH}/MSVC_Net2013)

    set(VS_PLATFORM ${VCPKG_TARGET_ARCHITECTURE})
    if(${VCPKG_TARGET_ARCHITECTURE} STREQUAL x86)
        set(VS_PLATFORM "Win32")
    endif(${VCPKG_TARGET_ARCHITECTURE} STREQUAL x86)
    vcpkg_build_msbuild(
        PROJECT_PATH ${SOURCE_PATH}/MSVC_Net2013/atkmm.sln
        TARGET atkmm
        PLATFORM ${VS_PLATFORM}
        USE_VCPKG_INTEGRATION
    )

    # Handle headers
    file(COPY ${SOURCE_PATH}/MSVC_Net2013/atkmm/atkmmconfig.h DESTINATION ${CURRENT_PACKAGES_DIR}/include)
    file(COPY ${SOURCE_PATH}/atk/atkmm.h DESTINATION ${CURRENT_PACKAGES_DIR}/include)
    file(COPY ${SOURCE_PATH}/atk/atkmm
        DESTINATION ${CURRENT_PACKAGES_DIR}/include
        FILES_MATCHING PATTERN *.h)

    # Handle libraries
    file(COPY ${SOURCE_PATH}/MSVC_Net2013/Release/${VS_PLATFORM}/bin/atkmm.dll
        DESTINATION ${CURRENT_PACKAGES_DIR}/bin)
    file(COPY ${SOURCE_PATH}/MSVC_Net2013/Release/${VS_PLATFORM}/bin/atkmm.lib
        DESTINATION ${CURRENT_PACKAGES_DIR}/lib)
    file(COPY ${SOURCE_PATH}/MSVC_Net2013/Debug/${VS_PLATFORM}/bin/atkmm.dll
        DESTINATION ${CURRENT_PACKAGES_DIR}/debug/bin)
    file(COPY ${SOURCE_PATH}/MSVC_Net2013/Debug/${VS_PLATFORM}/bin/atkmm.lib
        DESTINATION ${CURRENT_PACKAGES_DIR}/debug/lib)

    vcpkg_copy_pdbs()
else()
    set(ENV{CONFIG_SHELL} bash)
    vcpkg_configure_make(SOURCE_PATH ${SOURCE_PATH} OPTIONS ${ATKMM_OPTIONS})

    vcpkg_install_make()
endif()

file(INSTALL ${SOURCE_PATH}/COPYING DESTINATION ${CURRENT_PACKAGES_DIR}/share/${PORT} RENAME copyright)
file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/share")
