### Quick Start

Vcpkg helps you manage C and C++ libraries on Windows, Linux and MacOS. This tool and ecosystem are constantly evolving; your involvement are vital to its success!

### Examples

- [Installing and Using Packages Example: sqlite](examples/installing-and-using-packages.md)
- [Packaging Zipfiles Example: zlib](examples/packaging-zipfiles.md)
- [Packaging GitHub Repositories Example: libogg](examples/packaging-github-repos.md)
- [Patching Example: Patching libpng to work for x86-uwp](examples/patching.md)

### User Help

- [Integration with build systems](users/integration.md)
- [Triplet files](users/triplets.md)
- [Configuration and Environment](users/config-environment.md)
- [Usage with Android](users/android.md)
- [Using a manifest file to declare your dependencies](users/manifests.md)

### Maintainer help

- [Control files](maintainers/control-files.md) - in general, one should use manifest files instead
- [Manifest files](maintainers/manifest-files.md)
- [Portfile functions](maintainers/portfile-functions.md)
- [Maintainer Guidelines](maintainers/maintainer-guide.md)

### Tool Maintainer Help

- [Testing](tool-maintainers/testing.md)
- [Benchmarking](tool-maintainers/benchmarking.md)
- [Layout of the vcpkg source tree](tool-maintainers/layout.md)
- [Maintainer Guidelines](maintainers/maintainer-guide.md)

### Specifications

- [Export](specifications/export-command.md)
- [Feature Packages](specifications/feature-packages.md)

### Blog posts
- [Announcing a single C++ library manager for Linux, macOS and Windows: Vcpkg](https://blogs.msdn.microsoft.com/vcblog/2018/04/24/announcing-a-single-c-library-manager-for-linux-macos-and-windows-vcpkg/)
- [Vcpkg: Using multiple enlistments to handle multiple versions of a library](https://blogs.msdn.microsoft.com/vcblog/2017/10/23/vcpkg-using-multiple-enlistments/)
- [Vcpkg: introducing the export command](https://blogs.msdn.microsoft.com/vcblog/2017/05/03/vcpkg-introducing-export-command/)
- [Binary Compatibility and Pain-free Upgrade Why Moving to Visual Studio 2017 is almost "too easy"](https://blogs.msdn.microsoft.com/vcblog/2017/03/07/binary-compatibility-and-pain-free-upgrade-why-moving-to-visual-studio-2017-is-almost-too-easy/)
- [Vcpkg recent enhancements](https://blogs.msdn.microsoft.com/vcblog/2017/02/14/vcpkg-recent-enhancements/)
- [Vcpkg 3 Months Anniversary, Survey](https://blogs.msdn.microsoft.com/vcblog/2017/01/11/vcpkg-3-months-anniversary-survey/)
- [Vcpkg updates: Static linking is now available](https://blogs.msdn.microsoft.com/vcblog/2016/11/01/vcpkg-updates-static-linking-is-now-available/)
- [Vcpkg: a tool to acquire and build C++ open source libraries on Windows](https://blogs.msdn.microsoft.com/vcblog/2016/09/19/vcpkg-a-tool-to-acquire-and-build-c-open-source-libraries-on-windows/)

### Other

- [FAQ](about/faq.md)
- [Privacy](about/privacy.md)
