vcpkg_fail_port_install(ON_TARGET "OSX" "UWP")
vcpkg_check_linkage(ONLY_STATIC_LIBRARY)
vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO Ryan-rsm-McKenzie/mmio
    REF 1.1.0
    SHA512 54c63c345d9e0a284d13078d525fcbe73d793462968121fee89a19c810cdac736aca9c81f4c8b4f5ea51db1c47ad0c55e7cea38772049e4939b0d6e280f9a332
    HEAD_REF main
)

vcpkg_cmake_configure(
    SOURCE_PATH "${SOURCE_PATH}"
    OPTIONS
        -DBUILD_TESTING=OFF
)
vcpkg_cmake_install()
vcpkg_cmake_config_fixup(
    PACKAGE_NAME "mmio"
    CONFIG_PATH "lib/cmake/mmio"
)

file(REMOVE_RECURSE
    "${CURRENT_PACKAGES_DIR}/debug/include"
    "${CURRENT_PACKAGES_DIR}/debug/share"
)

file(INSTALL "${SOURCE_PATH}/LICENSE" DESTINATION "${CURRENT_PACKAGES_DIR}/share/${PORT}" RENAME copyright)
