/*******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: pafchkVerify.c 250921 2014-01-26 22:50:54Z pbaksai $"
*
* who       when        what
* --------  ----------  --------------------------------------------------------
* pbaksai   2013/12/30  CCB-000579: FIMS support for 64 bits.
*                       - Made more compatible outside VLT
* mpruemm   2009/06/23  Fix rcsId for VLT2009.
* rschmutz  2004/07/11  Some cleanup, man page added.
* lsanzana  2004/06/06  Created
*
********************************************************************************
*   NAME
*	pafchkVerify - verify PAF file checksum
* 
*   SYNOPSIS
*	pafchkVerify <filename>
* 
*   DESCRIPTION
*	Utility pafchkVerify verifies the integrity of a PAF file,
*	by checking the PAF checksum stored in PAF.CHCK.CHECKSUM.
*
*	<filename>: PAF file to be checked.
*
*   RETURN VALUES
*	0 - SUCCESS: Checksum is correct.
*	1 - FAILURE: Error encountered while accessing <filename>.
*	2 - FAILURE: Checksum is incorrect.
*	3 - FAILURE: No checksum found.
*
*   CAUTIONS 
*
*   EXAMPLES
*	pafchkVerify B67.ins
*
*   SEE ALSO
*	pafchkCreate(1)
*
*   BUGS   
* 
*-------------------------------------------------------------------------------
*/

#include "vltAttrib.h"
#define LINUX
#ifndef __cplusplus
#define _GNU_SOURCE
#endif

#include <stddef.h>
#include <sys/types.h>
#include <sys/time.h>
#include "vltPortGeneral.h"

ATTRIBUTE_UNUSED static const char *rcsId="@(#) $Id: pafchkVerify.c 250921 2014-01-26 22:50:54Z pbaksai $"; 

/* 
 * System Headers 
 */
#include <stdio.h>
#include <errno.h>

/*
 * Local Headers 
 */
#include "pafchk.h"

/* 
 * Main
 */
int main (int argc, char *argv[])
{
    char* filename;
    int   status;

    /*= 1. get filename argument */
    if (argc != 2)
	{
	printf("Usage: %s <filePath>.\n ", argv[0]);
	return 1;
	}
    filename = argv[1];

    /*= 2. verify checksum */
    status = pafchkChecksumVerify(filename);

    /*= 3. report status */
    switch (status)
	{
	case PAFCHK_RESULT_OK:
	    printf("OK: Checksum is correct.\n\n");
	    break;
 	case PAFCHK_RESULT_ERROR:
	    printf("ERROR encountered, see above.\n\n");
	    break;
	case PAFCHK_RESULT_BAD_CHECKSUM:
	    printf("ERROR: Checksum is not correct.\n\n");
	    break;	
	case PAFCHK_RESULT_NO_CHECKSUM:
            printf("ERROR: No checksum found.\n\n");
	    break;
	}

    return status;
}

    
/*___oOo___*/



