/*+            
                        t d F  c o n v e r t . h

 *  Module name:
      tdFconvert.h

 *  Function:
      Include file for the various input file conversion routines in the
      modules tdFparse.c and tdFconvertSds.c.  It defines the data structures
      they use and provides prototypes for the routines defined in these
      modules. These routines are responsible for reading the ascii target
      files provided by the user and converting them into the SDS structures
      used internally by configure (FPOSS).

 *  Description:

 *  Language:
      C

 *  Authors: James Wilcox, AAO (JW)
             Keith Shortridge, AAO (KS).

 *-

 *  History:
      04-Nov-1993  JW  Original version
      09-Nov-1996  KS  Increased LINE_LENGTH. 
      11-Jul-2000  KS  Added Instrument argument to tdFparseFieldData and to
                       tdFparseObjectData. Removed definition of HEADER_LINES 
                       since this is now instrument dependent.
      18-Jul-2000  KS  Routines now use Fpil calls. Interfaces modified
                       accordingly.
      29-Nov-2000  KS  Added maglimits argument to tdFparseObjectData().
      21-May-2001  KS  Added fracDayFlag to tdFparseFieldData().
      10-Jun-2001  KS  Added tdFparseObjectCount().
      13-Aug-2001  KS  Added posangle, posangleSpec and scale to fieldType.
                       Added lineCount to tdFparseFieldData() and 
                       tdFparseObjectData() to improve diagnostics.
      29-Aug-2001  KS  Removed declarations of static routines only used
                       by tdFparse.c. Removed tdFparseFileName(), which is
                       no longer used at all. Comments extended.
      30-Aug-2002  KS  pId structure should have been an array of shorts
                       not of ints. Now fixed.

 *  Sccs Id: tdFconvert.h, Release 1.6, 09/10/02 (mm/dd/yy)
 */
 
#include "fpil.h"

#define  LINE_LENGTH    1022
#define  NAME_LENGTH      80
#define  COMMENT_LENGTH   80
#define  MODE_LENGTH      10
#define  ID_LENGTH        80

/*  Standard logical values */

#define  NO                0
#define  YES               1

/*  Flags used for the 'options' argument of tdFparseObjectData() and
 *  tdFconvertToSds().
 */
 
#define  PRIORITY     (1<<1)
#define  MAGNITUDE    (1<<2)
#define  PROG_ID      (1<<3)
#define  COMMENT      (1<<4)

/*  A structure of type objectType contains all the information relating to
 *  one target object.  Note that the spectrograph and type fields are both
 *  deduced from the target type as specified in the input ascii file. The
 *  comment field is used for some instruments to include optional information
 *  such as V-I values in the form "(V-I)=value"
 */
 
typedef struct objectType {
    double             ra;           /* Mean Ra, in radians */
    double             dec;          /* Mean Ra, in radians */
    double             magnitude;    /* Magnitude */
    int                x;            /* Plate X coordinate, in microns */
    int                y;            /* Plate Y coordinate, in microns */
    short              pId;          /* Program Id */
    short              priority;     /* Target priority 0-9, 9 being highest */
    char               name          /* Object name */
                          [NAME_LENGTH];
    char               comment       /* Comments - may have embedded values */
                          [COMMENT_LENGTH];
    char               type;         /* Object type - values vary depending */
                                     /* on the instrument */
    char               spectrograph; /* Spectrograph to be used, where this */
                                     /* is relevant. */
    double             dhdx;         /* For guide stars, */
    double             dddx;         /* these give the change in ha and dec */
    double             dhdy;         /* for each change in x and y, */
    double             dddy;         /* which depends on the plate position */
    struct objectType  *next;        /* Pointer to next object in the list */
    }  objectType;

/*  A structure of type fieldType contains all the information relating to
 *  the overall field.
 */
 
typedef struct fieldType {
    double   cenRa;                /* Mean centre Ra, in radians */
    double   cenDec;               /* Mean centre Dec, in radians */
    double   appRa;                /* Apparent centre Ra, in radians */
    double   appDec;               /* Apparent centre Dec, in radians */
    double   appEpoch;             /* Epoch */
    double   configMjd;            /* Mjd for the configuration */
    short    unallocObj;           /* Number of unallocated program objects */
    short    unallocGui;           /* Number of unallocated guide objects */
    short    unallocSky;           /* Number of unallocated sky objects */
    char     label[COMMENT_LENGTH];/* Field label */
    char     progId[ID_LENGTH];    /* Program id string - always blank */
    char     mode[MODE_LENGTH];    /* Mode of operation - always "NORMAL" */ 
    double   posangle;             /* ARGUS angle, if specified */
    short    argusSpec;            /* True if ARGUS information included */
    char     scale[16];            /* ARGUS scale factor, if specified */
    }  fieldType;

/*  A structure of type tdFfieldType is filled up by tdFparseObjectData().
 *  It contains the start points for two linked lists of objects, one
 *  giving the guide objects the other giving all the rest. It also contains
 *  a structure giving the field information.
 */
 
typedef struct tdFfieldType {
    fieldType   fieldData;        /* Field details */
    objectType  *unallocGuide;    /* First in list of guide objects */
    objectType  *unallocObject;   /* First in list of other objects */
    }  tdFfieldType;

/*  Routine prototypes */

void tdFparseFieldData (
    const FpilType *instrument,
    FILE           *asciiFile,
    fieldType      *fieldData,
    double          uttime,
    short          *fracDayFlag,
    int            *lineCount,
    StatusType     *status);

void tdFparseObjectData (
    const FpilType *instrument,
    FILE           *asciiFile,
    tdFfieldType   *field,
    short          *options,
    float          maglimits[],
    int            *lineCount,
    StatusType     *status);

int tdFparseObjectCount (
    const FpilType *instrument,
    FILE           *asciiFile,
    float          maglimits[],
    StatusType     *status);


void tdFconvertToSds (
    char          *fieldName,
    tdFfieldType  *field,
    short         options,
    SdsIdType     *fileId,
    StatusType    *status);









