
/*
 *+			E r s S P r i n t f

 *  Function name:
      ErsSPrintf

 *  Function:
	A safe version of the C RTL sprintf function.


 *  Description:
	The standard C RTL version of sprintf is unsafe as nothing
	limits the length of the output string.  It is easy to overwrite
	the stack.  By providing a length argument string argument, this 
	routine implements a safe version of sprintf.

	See ErsVSPrintf() for more details.	

 *  Language:
      C

 *  Call:
	(int) = ErsSPrintf(length, string, format, args...)

 *  Parameters:   (">" input, "!" modified, "W" workspace, "<" output)
	(>) length  (int) The length of string.
	(<) string  (char *) The pointer to the output string	
	(>) format  (char *) A format specification
	(>) arg...  (anything) argument list 


 *  Function value:
	EOF indicates the format string exceeds 
	the length available, otherwise, the number of characters output.

 *  Include files: Ers.h, stdio.h


 *  External functions used:
	    ErsVSPrintf  (Ers) A save version of vsprintf.

 *  External values used: 
	    none

 *  Prior requirements:
	    none 

 *  Support: Tony Farrell, AAO

 *-

 *  Copyright (c) Anglo-Australian Telescope Board, 1995.
    Not to be used for commercial purposes without AATB permission.
  
 *  History:
      23-Nov-1992 - TJF - Original version,
      29-Sep-1993 - TJF - Add Sccs id
      {@change entry@}
 
 
 *  Sccs Id:  erssprintf.c, Release 1.7, 06/30/95
 
 */
#define ERS_MAIN			/* Indication to Ers.h		*/
#ifndef DNOCONST
#    define DNOCONST 1
#endif 
#include "Ers.h"
#ifdef DSTDARG_OK	    
    DPUBLIC int ErsSPrintf (
			DCONSTV int maxLength,
			char *string, 
			DCONSTV char * DCONSTR fmt, ... )
#else
    DPUBLIC int ErsSPrintf (va_alist)
    va_dcl
#endif
{
    va_list args;

#   ifdef DSTDARG_OK
	va_start(args,fmt);
	/*
	return(snprintf(string, maxLength, fmt, args));
	*/
#   else
	int maxLength;
	char *string;
	char *fmt;
        va_start(args);
        maxLength = va_arg(args, int);
        string = va_arg(args, char *);
	fmt = va_arg(args, char *);
#   endif
    
    return(ErsVSPrintf(maxLength,string,fmt,args));

}


#ifdef DSTDARG_OK	    
    DPUBLIC int jErsSPrintf (
			char *string, 
			DCONSTV char * DCONSTR fmt,
			DCONSTV int maxLength, ... )
#else
    DPUBLIC int jErsSPrintf (va_alist)
    va_dcl
#endif
{
    va_list args;

#   ifdef DSTDARG_OK
	va_start(args,maxLength);
#   else
	int maxLength;
	char *string;
	char *fmt;
        va_start(args);
        maxLength = va_arg(args, int);
        string = va_arg(args, char *);
	fmt = va_arg(args, char *);
#   endif
    
    return(ErsVSPrintf(maxLength,string,fmt,args));

}
