#ifndef UTILS_H
#define UTILS_H

/*
utility routines; written for Erni but not bound to that tool
*/

#include<stdio.h>


/**
\brief
utility function to remove whitespace from
either side of a given string.

trimSpace() does not alter its argument
[hence why it's labeled a const pointer] but
instead duplicates it using strdup().

The concept of a "whitespace" character is 
determined by the standard library's isspace()
function.

*/
char* trimSpace( const char *inString ) ;


/**
\brief print all members of a NULL-terminated array of char pointers 
\param vector a char** variable, suitable for use with execvp()
*/

const char* printVector( char** vector ) ;


/**
\brief
Convert a string of whitespace-delimited values 
into an array.

In other words, convert a "char*" to "char**."
This is used to process the command string
[as specified by "command" in the config file, or
"-e" on the commandline] such that it may be
passed as a proper argument vector to one of the
exec[n]() functions.

This function is not used if the command
to be executed is passed on the commandline using
"-E" [note the capital "E"]; in that case, the
command to be executed is already a char**.

The concept of a "whitespace" character is 
determined by the standard library's isspace()
function.
*/
char** string2array( const char *inString ) ;

/**
\brief convenience method for use with dumpConfig() -- 
print either the value given, or the provided default

\param value value to print, if it is not null
\param def what to print if "value" is null
*/

const char* printNull( const char* value , const char* def ) ;


/**
\brief convenience function -- don't bother to call strerror() if an erroneous condition did not set errno
\param code this should ALWAYS be errno
*/

const char* printError( int code ) ;


typedef struct ConfigItem_t {
	char* key ;
	char* val ;
	int line ;
	struct ConfigItem_t* next ;
} ConfigItem ;

ConfigItem* ConfigItem_create() ;

void ConfigItem_free( ConfigItem* current ) ;

ConfigItem* parseConfig( FILE* file_handle ) ;

/*
	create function "ConfigItem_iterate"
	that takes ptr-to-function and ConfigItem, 
	passing each item through the function?
*/


#endif /* #ifndef UTILS_H */
