%% Generated by the Erlang ASN.1 BER compiler. Version: 5.0.5
%% Purpose: Encoding and decoding of the types in ELDAPv3.

-module('ELDAPv3').
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-include("ELDAPv3.hrl").
-asn1_info([{vsn,'5.0.5'},
            {module,'ELDAPv3'},
            {options,[warnings,ber,errors,
 {cwd,"/net/isildur/ldisk/daily_build/20_prebuild_opu_o.2018-03-13_21/otp_src_20/lib/eldap/src"},
 {outdir,"/net/isildur/ldisk/daily_build/20_prebuild_opu_o.2018-03-13_21/otp_src_20/lib/eldap/src/../ebin"},
 {i,"/net/isildur/ldisk/daily_build/20_prebuild_opu_o.2018-03-13_21/otp_src_20/lib/eldap/src/../include"},
 {i,"/net/isildur/ldisk/daily_build/20_prebuild_opu_o.2018-03-13_21/otp_src_20/lib/eldap/src/../ebin"},
 warnings_as_errors,debug_info,legacy_erlang_types,
 {i,"."},
 {i,"/net/isildur/ldisk/daily_build/20_prebuild_opu_o.2018-03-13_21/otp_src_20/lib/eldap/src/../asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_LDAPMessage/2,
enc_MessageID/2,
enc_LDAPString/2,
enc_LDAPOID/2,
enc_LDAPDN/2,
enc_RelativeLDAPDN/2,
enc_AttributeDescription/2,
enc_AttributeValue/2,
enc_AttributeValueAssertion/2,
enc_AssertionValue/2,
enc_PartialAttribute/2,
enc_Attribute/2,
enc_MatchingRuleId/2,
enc_LDAPResult/2,
enc_Referral/2,
enc_URI/2,
enc_Controls/2,
enc_Control/2,
enc_BindRequest/2,
enc_AuthenticationChoice/2,
enc_SaslCredentials/2,
enc_BindResponse/2,
enc_UnbindRequest/2,
enc_SearchRequest/2,
enc_AttributeSelection/2,
enc_Filter/2,
enc_SubstringFilter/2,
enc_MatchingRuleAssertion/2,
enc_SearchResultEntry/2,
enc_PartialAttributeList/2,
enc_SearchResultReference/2,
enc_SearchResultDone/2,
enc_ModifyRequest/2,
enc_ModifyResponse/2,
enc_AddRequest/2,
enc_AttributeList/2,
enc_AddResponse/2,
enc_DelRequest/2,
enc_DelResponse/2,
enc_ModifyDNRequest/2,
enc_ModifyDNResponse/2,
enc_CompareRequest/2,
enc_CompareResponse/2,
enc_AbandonRequest/2,
enc_ExtendedRequest/2,
enc_ExtendedResponse/2,
enc_IntermediateResponse/2,
enc_PasswdModifyRequestValue/2,
enc_PasswdModifyResponseValue/2
]).

-export([
dec_LDAPMessage/2,
dec_MessageID/2,
dec_LDAPString/2,
dec_LDAPOID/2,
dec_LDAPDN/2,
dec_RelativeLDAPDN/2,
dec_AttributeDescription/2,
dec_AttributeValue/2,
dec_AttributeValueAssertion/2,
dec_AssertionValue/2,
dec_PartialAttribute/2,
dec_Attribute/2,
dec_MatchingRuleId/2,
dec_LDAPResult/2,
dec_Referral/2,
dec_URI/2,
dec_Controls/2,
dec_Control/2,
dec_BindRequest/2,
dec_AuthenticationChoice/2,
dec_SaslCredentials/2,
dec_BindResponse/2,
dec_UnbindRequest/2,
dec_SearchRequest/2,
dec_AttributeSelection/2,
dec_Filter/2,
dec_SubstringFilter/2,
dec_MatchingRuleAssertion/2,
dec_SearchResultEntry/2,
dec_PartialAttributeList/2,
dec_SearchResultReference/2,
dec_SearchResultDone/2,
dec_ModifyRequest/2,
dec_ModifyResponse/2,
dec_AddRequest/2,
dec_AttributeList/2,
dec_AddResponse/2,
dec_DelRequest/2,
dec_DelResponse/2,
dec_ModifyDNRequest/2,
dec_ModifyDNResponse/2,
dec_CompareRequest/2,
dec_CompareResponse/2,
dec_AbandonRequest/2,
dec_ExtendedRequest/2,
dec_ExtendedResponse/2,
dec_IntermediateResponse/2,
dec_PasswdModifyRequestValue/2,
dec_PasswdModifyResponseValue/2
]).

-export([
maxInt/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> true.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception when Class =:= error; Class =:= exit ->
      Stk = erlang:get_stacktrace(),
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception when Class =:= error; Class =:= exit ->
      Stk = erlang:get_stacktrace(),
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('LDAPMessage', Data) -> enc_LDAPMessage(Data);
encode_disp('MessageID', Data) -> enc_MessageID(Data);
encode_disp('LDAPString', Data) -> enc_LDAPString(Data);
encode_disp('LDAPOID', Data) -> enc_LDAPOID(Data);
encode_disp('LDAPDN', Data) -> enc_LDAPDN(Data);
encode_disp('RelativeLDAPDN', Data) -> enc_RelativeLDAPDN(Data);
encode_disp('AttributeDescription', Data) -> enc_AttributeDescription(Data);
encode_disp('AttributeValue', Data) -> enc_AttributeValue(Data);
encode_disp('AttributeValueAssertion', Data) -> enc_AttributeValueAssertion(Data);
encode_disp('AssertionValue', Data) -> enc_AssertionValue(Data);
encode_disp('PartialAttribute', Data) -> enc_PartialAttribute(Data);
encode_disp('Attribute', Data) -> enc_Attribute(Data);
encode_disp('MatchingRuleId', Data) -> enc_MatchingRuleId(Data);
encode_disp('LDAPResult', Data) -> enc_LDAPResult(Data);
encode_disp('Referral', Data) -> enc_Referral(Data);
encode_disp('URI', Data) -> enc_URI(Data);
encode_disp('Controls', Data) -> enc_Controls(Data);
encode_disp('Control', Data) -> enc_Control(Data);
encode_disp('BindRequest', Data) -> enc_BindRequest(Data);
encode_disp('AuthenticationChoice', Data) -> enc_AuthenticationChoice(Data);
encode_disp('SaslCredentials', Data) -> enc_SaslCredentials(Data);
encode_disp('BindResponse', Data) -> enc_BindResponse(Data);
encode_disp('UnbindRequest', Data) -> enc_UnbindRequest(Data);
encode_disp('SearchRequest', Data) -> enc_SearchRequest(Data);
encode_disp('AttributeSelection', Data) -> enc_AttributeSelection(Data);
encode_disp('Filter', Data) -> enc_Filter(Data);
encode_disp('SubstringFilter', Data) -> enc_SubstringFilter(Data);
encode_disp('MatchingRuleAssertion', Data) -> enc_MatchingRuleAssertion(Data);
encode_disp('SearchResultEntry', Data) -> enc_SearchResultEntry(Data);
encode_disp('PartialAttributeList', Data) -> enc_PartialAttributeList(Data);
encode_disp('SearchResultReference', Data) -> enc_SearchResultReference(Data);
encode_disp('SearchResultDone', Data) -> enc_SearchResultDone(Data);
encode_disp('ModifyRequest', Data) -> enc_ModifyRequest(Data);
encode_disp('ModifyResponse', Data) -> enc_ModifyResponse(Data);
encode_disp('AddRequest', Data) -> enc_AddRequest(Data);
encode_disp('AttributeList', Data) -> enc_AttributeList(Data);
encode_disp('AddResponse', Data) -> enc_AddResponse(Data);
encode_disp('DelRequest', Data) -> enc_DelRequest(Data);
encode_disp('DelResponse', Data) -> enc_DelResponse(Data);
encode_disp('ModifyDNRequest', Data) -> enc_ModifyDNRequest(Data);
encode_disp('ModifyDNResponse', Data) -> enc_ModifyDNResponse(Data);
encode_disp('CompareRequest', Data) -> enc_CompareRequest(Data);
encode_disp('CompareResponse', Data) -> enc_CompareResponse(Data);
encode_disp('AbandonRequest', Data) -> enc_AbandonRequest(Data);
encode_disp('ExtendedRequest', Data) -> enc_ExtendedRequest(Data);
encode_disp('ExtendedResponse', Data) -> enc_ExtendedResponse(Data);
encode_disp('IntermediateResponse', Data) -> enc_IntermediateResponse(Data);
encode_disp('PasswdModifyRequestValue', Data) -> enc_PasswdModifyRequestValue(Data);
encode_disp('PasswdModifyResponseValue', Data) -> enc_PasswdModifyResponseValue(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('LDAPMessage', Data) -> dec_LDAPMessage(Data);
decode_disp('MessageID', Data) -> dec_MessageID(Data);
decode_disp('LDAPString', Data) -> dec_LDAPString(Data);
decode_disp('LDAPOID', Data) -> dec_LDAPOID(Data);
decode_disp('LDAPDN', Data) -> dec_LDAPDN(Data);
decode_disp('RelativeLDAPDN', Data) -> dec_RelativeLDAPDN(Data);
decode_disp('AttributeDescription', Data) -> dec_AttributeDescription(Data);
decode_disp('AttributeValue', Data) -> dec_AttributeValue(Data);
decode_disp('AttributeValueAssertion', Data) -> dec_AttributeValueAssertion(Data);
decode_disp('AssertionValue', Data) -> dec_AssertionValue(Data);
decode_disp('PartialAttribute', Data) -> dec_PartialAttribute(Data);
decode_disp('Attribute', Data) -> dec_Attribute(Data);
decode_disp('MatchingRuleId', Data) -> dec_MatchingRuleId(Data);
decode_disp('LDAPResult', Data) -> dec_LDAPResult(Data);
decode_disp('Referral', Data) -> dec_Referral(Data);
decode_disp('URI', Data) -> dec_URI(Data);
decode_disp('Controls', Data) -> dec_Controls(Data);
decode_disp('Control', Data) -> dec_Control(Data);
decode_disp('BindRequest', Data) -> dec_BindRequest(Data);
decode_disp('AuthenticationChoice', Data) -> dec_AuthenticationChoice(Data);
decode_disp('SaslCredentials', Data) -> dec_SaslCredentials(Data);
decode_disp('BindResponse', Data) -> dec_BindResponse(Data);
decode_disp('UnbindRequest', Data) -> dec_UnbindRequest(Data);
decode_disp('SearchRequest', Data) -> dec_SearchRequest(Data);
decode_disp('AttributeSelection', Data) -> dec_AttributeSelection(Data);
decode_disp('Filter', Data) -> dec_Filter(Data);
decode_disp('SubstringFilter', Data) -> dec_SubstringFilter(Data);
decode_disp('MatchingRuleAssertion', Data) -> dec_MatchingRuleAssertion(Data);
decode_disp('SearchResultEntry', Data) -> dec_SearchResultEntry(Data);
decode_disp('PartialAttributeList', Data) -> dec_PartialAttributeList(Data);
decode_disp('SearchResultReference', Data) -> dec_SearchResultReference(Data);
decode_disp('SearchResultDone', Data) -> dec_SearchResultDone(Data);
decode_disp('ModifyRequest', Data) -> dec_ModifyRequest(Data);
decode_disp('ModifyResponse', Data) -> dec_ModifyResponse(Data);
decode_disp('AddRequest', Data) -> dec_AddRequest(Data);
decode_disp('AttributeList', Data) -> dec_AttributeList(Data);
decode_disp('AddResponse', Data) -> dec_AddResponse(Data);
decode_disp('DelRequest', Data) -> dec_DelRequest(Data);
decode_disp('DelResponse', Data) -> dec_DelResponse(Data);
decode_disp('ModifyDNRequest', Data) -> dec_ModifyDNRequest(Data);
decode_disp('ModifyDNResponse', Data) -> dec_ModifyDNResponse(Data);
decode_disp('CompareRequest', Data) -> dec_CompareRequest(Data);
decode_disp('CompareResponse', Data) -> dec_CompareResponse(Data);
decode_disp('AbandonRequest', Data) -> dec_AbandonRequest(Data);
decode_disp('ExtendedRequest', Data) -> dec_ExtendedRequest(Data);
decode_disp('ExtendedResponse', Data) -> dec_ExtendedResponse(Data);
decode_disp('IntermediateResponse', Data) -> dec_IntermediateResponse(Data);
decode_disp('PasswdModifyRequestValue', Data) -> dec_PasswdModifyRequestValue(Data);
decode_disp('PasswdModifyResponseValue', Data) -> dec_PasswdModifyResponseValue(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  LDAPMessage
%%================================
enc_LDAPMessage(Val) ->
    enc_LDAPMessage(Val, [<<48>>]).

enc_LDAPMessage(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute messageID(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute protocolOp(2) with type CHOICE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_LDAPMessage_protocolOp'(Cindex2, []),

%%-------------------------------------------------
%% attribute controls(3)   External ELDAPv3:Controls OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Controls'(Cindex3, [<<160>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  LDAPMessage_protocolOp
%%================================
enc_LDAPMessage_protocolOp(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      bindRequest ->
         'enc_BindRequest'(element(2,Val), [<<96>>]);
      bindResponse ->
         'enc_BindResponse'(element(2,Val), [<<97>>]);
      unbindRequest ->
         encode_null(element(2,Val), [<<66>>]);
      searchRequest ->
         'enc_SearchRequest'(element(2,Val), [<<99>>]);
      searchResEntry ->
         'enc_SearchResultEntry'(element(2,Val), [<<100>>]);
      searchResDone ->
         'enc_SearchResultDone'(element(2,Val), [<<101>>]);
      searchResRef ->
         'enc_SearchResultReference'(element(2,Val), [<<115>>]);
      modifyRequest ->
         'enc_ModifyRequest'(element(2,Val), [<<102>>]);
      modifyResponse ->
         'enc_ModifyResponse'(element(2,Val), [<<103>>]);
      addRequest ->
         'enc_AddRequest'(element(2,Val), [<<104>>]);
      addResponse ->
         'enc_AddResponse'(element(2,Val), [<<105>>]);
      delRequest ->
         encode_restricted_string(element(2,Val), [<<74>>]);
      delResponse ->
         'enc_DelResponse'(element(2,Val), [<<107>>]);
      modDNRequest ->
         'enc_ModifyDNRequest'(element(2,Val), [<<108>>]);
      modDNResponse ->
         'enc_ModifyDNResponse'(element(2,Val), [<<109>>]);
      compareRequest ->
         'enc_CompareRequest'(element(2,Val), [<<110>>]);
      compareResponse ->
         'enc_CompareResponse'(element(2,Val), [<<111>>]);
      abandonRequest ->
         encode_integer(element(2,Val), [<<80>>]);
      extendedReq ->
         'enc_ExtendedRequest'(element(2,Val), [<<119>>]);
      extendedResp ->
         'enc_ExtendedResponse'(element(2,Val), [<<120>>]);
      intermediateResponse ->
         'enc_IntermediateResponse'(element(2,Val), [<<121>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_LDAPMessage(Tlv) ->
   dec_LDAPMessage(Tlv, [16]).

dec_LDAPMessage(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute messageID(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
if 0 =< Val1, Val1 =< 2147483647 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute protocolOp(2) with type CHOICE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_LDAPMessage_protocolOp'(V2, []),

%%-------------------------------------------------
%% attribute controls(3)   External ELDAPv3:Controls OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131072,V3}|TempTlv4] ->
    {'dec_Controls'(V3, []), TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'LDAPMessage',Term1,Term2,Term3},
Res1.
'dec_LDAPMessage_protocolOp'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'bindRequest'
    {65536, V1} -> 
        {bindRequest, 'dec_BindRequest'(V1, [])};


%% 'bindResponse'
    {65537, V1} -> 
        {bindResponse, 'dec_BindResponse'(V1, [])};


%% 'unbindRequest'
    {65538, V1} -> 
        {unbindRequest, decode_null(V1, [])};


%% 'searchRequest'
    {65539, V1} -> 
        {searchRequest, 'dec_SearchRequest'(V1, [])};


%% 'searchResEntry'
    {65540, V1} -> 
        {searchResEntry, 'dec_SearchResultEntry'(V1, [])};


%% 'searchResDone'
    {65541, V1} -> 
        {searchResDone, 'dec_SearchResultDone'(V1, [])};


%% 'searchResRef'
    {65555, V1} -> 
        {searchResRef, 'dec_SearchResultReference'(V1, [])};


%% 'modifyRequest'
    {65542, V1} -> 
        {modifyRequest, 'dec_ModifyRequest'(V1, [])};


%% 'modifyResponse'
    {65543, V1} -> 
        {modifyResponse, 'dec_ModifyResponse'(V1, [])};


%% 'addRequest'
    {65544, V1} -> 
        {addRequest, 'dec_AddRequest'(V1, [])};


%% 'addResponse'
    {65545, V1} -> 
        {addResponse, 'dec_AddResponse'(V1, [])};


%% 'delRequest'
    {65546, V1} -> 
        {delRequest, begin
binary_to_list(decode_restricted_string(V1, []))
end
};


%% 'delResponse'
    {65547, V1} -> 
        {delResponse, 'dec_DelResponse'(V1, [])};


%% 'modDNRequest'
    {65548, V1} -> 
        {modDNRequest, 'dec_ModifyDNRequest'(V1, [])};


%% 'modDNResponse'
    {65549, V1} -> 
        {modDNResponse, 'dec_ModifyDNResponse'(V1, [])};


%% 'compareRequest'
    {65550, V1} -> 
        {compareRequest, 'dec_CompareRequest'(V1, [])};


%% 'compareResponse'
    {65551, V1} -> 
        {compareResponse, 'dec_CompareResponse'(V1, [])};


%% 'abandonRequest'
    {65552, V1} -> 
        {abandonRequest, begin
Val1 = decode_integer(V1, []),
if 0 =< Val1, Val1 =< 2147483647 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'extendedReq'
    {65559, V1} -> 
        {extendedReq, 'dec_ExtendedRequest'(V1, [])};


%% 'extendedResp'
    {65560, V1} -> 
        {extendedResp, 'dec_ExtendedResponse'(V1, [])};


%% 'intermediateResponse'
    {65561, V1} -> 
        {intermediateResponse, 'dec_IntermediateResponse'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  MessageID
%%================================
enc_MessageID(Val) ->
    enc_MessageID(Val, [<<2>>]).

enc_MessageID(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_MessageID(Tlv) ->
   dec_MessageID(Tlv, [2]).

dec_MessageID(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 2147483647 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  LDAPString
%%================================
enc_LDAPString(Val) ->
    enc_LDAPString(Val, [<<4>>]).

enc_LDAPString(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_LDAPString(Tlv) ->
   dec_LDAPString(Tlv, [4]).

dec_LDAPString(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  LDAPOID
%%================================
enc_LDAPOID(Val) ->
    enc_LDAPOID(Val, [<<4>>]).

enc_LDAPOID(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_LDAPOID(Tlv) ->
   dec_LDAPOID(Tlv, [4]).

dec_LDAPOID(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  LDAPDN
%%================================
enc_LDAPDN(Val) ->
    enc_LDAPDN(Val, [<<4>>]).

enc_LDAPDN(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_LDAPDN(Tlv) ->
   dec_LDAPDN(Tlv, [4]).

dec_LDAPDN(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  RelativeLDAPDN
%%================================
enc_RelativeLDAPDN(Val) ->
    enc_RelativeLDAPDN(Val, [<<4>>]).

enc_RelativeLDAPDN(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_RelativeLDAPDN(Tlv) ->
   dec_RelativeLDAPDN(Tlv, [4]).

dec_RelativeLDAPDN(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  AttributeDescription
%%================================
enc_AttributeDescription(Val) ->
    enc_AttributeDescription(Val, [<<4>>]).

enc_AttributeDescription(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_AttributeDescription(Tlv) ->
   dec_AttributeDescription(Tlv, [4]).

dec_AttributeDescription(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  AttributeValue
%%================================
enc_AttributeValue(Val) ->
    enc_AttributeValue(Val, [<<4>>]).

enc_AttributeValue(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_AttributeValue(Tlv) ->
   dec_AttributeValue(Tlv, [4]).

dec_AttributeValue(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  AttributeValueAssertion
%%================================
enc_AttributeValueAssertion(Val) ->
    enc_AttributeValueAssertion(Val, [<<48>>]).

enc_AttributeValueAssertion(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute attributeDesc(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute assertionValue(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AttributeValueAssertion(Tlv) ->
   dec_AttributeValueAssertion(Tlv, [16]).

dec_AttributeValueAssertion(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute attributeDesc(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [4]))
end
,

%%-------------------------------------------------
%% attribute assertionValue(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
binary_to_list(decode_restricted_string(V2, [4]))
end
,

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'AttributeValueAssertion',Term1,Term2},
Res1.


%%================================
%%  AssertionValue
%%================================
enc_AssertionValue(Val) ->
    enc_AssertionValue(Val, [<<4>>]).

enc_AssertionValue(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_AssertionValue(Tlv) ->
   dec_AssertionValue(Tlv, [4]).

dec_AssertionValue(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  PartialAttribute
%%================================
enc_PartialAttribute(Val) ->
    enc_PartialAttribute(Val, [<<48>>]).

enc_PartialAttribute(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute type(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute vals(2) with type SET OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PartialAttribute_vals'(Cindex2, [<<49>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PartialAttribute_vals
%%================================
enc_PartialAttribute_vals(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_PartialAttribute_vals_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PartialAttribute_vals_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PartialAttribute_vals_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<4>>]),
   'enc_PartialAttribute_vals_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PartialAttribute(Tlv) ->
   dec_PartialAttribute(Tlv, [16]).

dec_PartialAttribute(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [4]))
end
,

%%-------------------------------------------------
%% attribute vals(2) with type SET OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PartialAttribute_vals'(V2, [17]),

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'PartialAttribute',Term1,Term2},
Res1.
'dec_PartialAttribute_vals'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
binary_to_list(decode_restricted_string(V1, [4]))
end
 || V1 <- Tlv1].




%%================================
%%  Attribute
%%================================
enc_Attribute(Val) ->
    enc_Attribute(Val, [<<48>>]).

enc_Attribute(Val, TagIn) ->
   enc_PartialAttribute(Val, TagIn).


dec_Attribute(Tlv) ->
   dec_Attribute(Tlv, [16]).

dec_Attribute(Tlv, TagIn) ->
'dec_PartialAttribute'(Tlv, TagIn).



%%================================
%%  MatchingRuleId
%%================================
enc_MatchingRuleId(Val) ->
    enc_MatchingRuleId(Val, [<<4>>]).

enc_MatchingRuleId(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_MatchingRuleId(Tlv) ->
   dec_MatchingRuleId(Tlv, [4]).

dec_MatchingRuleId(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  LDAPResult
%%================================
enc_LDAPResult(Val) ->
    enc_LDAPResult(Val, [<<48>>]).

enc_LDAPResult(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute resultCode(1) with type ENUMERATED
%%-------------------------------------------------
   {EncBytes1,EncLen1} = case Cindex1 of
success -> encode_tags([<<10>>], [0], 1);
operationsError -> encode_tags([<<10>>], [1], 1);
protocolError -> encode_tags([<<10>>], [2], 1);
timeLimitExceeded -> encode_tags([<<10>>], [3], 1);
sizeLimitExceeded -> encode_tags([<<10>>], [4], 1);
compareFalse -> encode_tags([<<10>>], [5], 1);
compareTrue -> encode_tags([<<10>>], [6], 1);
authMethodNotSupported -> encode_tags([<<10>>], [7], 1);
strongerAuthRequired -> encode_tags([<<10>>], [8], 1);
referral -> encode_tags([<<10>>], [10], 1);
adminLimitExceeded -> encode_tags([<<10>>], [11], 1);
unavailableCriticalExtension -> encode_tags([<<10>>], [12], 1);
confidentialityRequired -> encode_tags([<<10>>], [13], 1);
saslBindInProgress -> encode_tags([<<10>>], [14], 1);
noSuchAttribute -> encode_tags([<<10>>], [16], 1);
undefinedAttributeType -> encode_tags([<<10>>], [17], 1);
inappropriateMatching -> encode_tags([<<10>>], [18], 1);
constraintViolation -> encode_tags([<<10>>], [19], 1);
attributeOrValueExists -> encode_tags([<<10>>], [20], 1);
invalidAttributeSyntax -> encode_tags([<<10>>], [21], 1);
noSuchObject -> encode_tags([<<10>>], [32], 1);
aliasProblem -> encode_tags([<<10>>], [33], 1);
invalidDNSyntax -> encode_tags([<<10>>], [34], 1);
aliasDereferencingProblem -> encode_tags([<<10>>], [36], 1);
inappropriateAuthentication -> encode_tags([<<10>>], [48], 1);
invalidCredentials -> encode_tags([<<10>>], [49], 1);
insufficientAccessRights -> encode_tags([<<10>>], [50], 1);
busy -> encode_tags([<<10>>], [51], 1);
unavailable -> encode_tags([<<10>>], [52], 1);
unwillingToPerform -> encode_tags([<<10>>], [53], 1);
loopDetect -> encode_tags([<<10>>], [54], 1);
namingViolation -> encode_tags([<<10>>], [64], 1);
objectClassViolation -> encode_tags([<<10>>], [65], 1);
notAllowedOnNonLeaf -> encode_tags([<<10>>], [66], 1);
notAllowedOnRDN -> encode_tags([<<10>>], [67], 1);
entryAlreadyExists -> encode_tags([<<10>>], [68], 1);
objectClassModsProhibited -> encode_tags([<<10>>], [69], 1);
affectsMultipleDSAs -> encode_tags([<<10>>], [71], 1);
other -> encode_tags([<<10>>], [80], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute matchedDN(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

%%-------------------------------------------------
%% attribute diagnosticMessage(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

%%-------------------------------------------------
%% attribute referral(4)   External ELDAPv3:Referral OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Referral'(Cindex4, [<<163>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_LDAPResult(Tlv) ->
   dec_LDAPResult(Tlv, [16]).

dec_LDAPResult(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute resultCode(1) with type ENUMERATED
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = case decode_integer(V1, [10]) of
0 -> success;
1 -> operationsError;
2 -> protocolError;
3 -> timeLimitExceeded;
4 -> sizeLimitExceeded;
5 -> compareFalse;
6 -> compareTrue;
7 -> authMethodNotSupported;
8 -> strongerAuthRequired;
10 -> referral;
11 -> adminLimitExceeded;
12 -> unavailableCriticalExtension;
13 -> confidentialityRequired;
14 -> saslBindInProgress;
16 -> noSuchAttribute;
17 -> undefinedAttributeType;
18 -> inappropriateMatching;
19 -> constraintViolation;
20 -> attributeOrValueExists;
21 -> invalidAttributeSyntax;
32 -> noSuchObject;
33 -> aliasProblem;
34 -> invalidDNSyntax;
36 -> aliasDereferencingProblem;
48 -> inappropriateAuthentication;
49 -> invalidCredentials;
50 -> insufficientAccessRights;
51 -> busy;
52 -> unavailable;
53 -> unwillingToPerform;
54 -> loopDetect;
64 -> namingViolation;
65 -> objectClassViolation;
66 -> notAllowedOnNonLeaf;
67 -> notAllowedOnRDN;
68 -> entryAlreadyExists;
69 -> objectClassModsProhibited;
71 -> affectsMultipleDSAs;
80 -> other;
Default1 -> {asn1_enum,Default1}
end,

%%-------------------------------------------------
%% attribute matchedDN(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
binary_to_list(decode_restricted_string(V2, [4]))
end
,

%%-------------------------------------------------
%% attribute diagnosticMessage(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = begin
binary_to_list(decode_restricted_string(V3, [4]))
end
,

%%-------------------------------------------------
%% attribute referral(4)   External ELDAPv3:Referral OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {'dec_Referral'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'LDAPResult',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  Referral
%%================================
enc_Referral(Val) ->
    enc_Referral(Val, [<<48>>]).

enc_Referral(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Referral_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Referral_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Referral_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<4>>]),
   'enc_Referral_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_Referral(Tlv) ->
   dec_Referral(Tlv, [16]).

dec_Referral(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
binary_to_list(decode_restricted_string(V1, [4]))
end
 || V1 <- Tlv1].




%%================================
%%  URI
%%================================
enc_URI(Val) ->
    enc_URI(Val, [<<4>>]).

enc_URI(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_URI(Tlv) ->
   dec_URI(Tlv, [4]).

dec_URI(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  Controls
%%================================
enc_Controls(Val) ->
    enc_Controls(Val, [<<48>>]).

enc_Controls(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Controls_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Controls_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Controls_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Control'(H, [<<48>>]),
   'enc_Controls_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_Controls(Tlv) ->
   dec_Controls(Tlv, [16]).

dec_Controls(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Control'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  Control
%%================================
enc_Control(Val) ->
    enc_Control(Val, [<<48>>]).

enc_Control(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute controlType(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute criticality(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_DEFAULT ->
            {<<>>,0};
         _ when Cindex2 =:= false ->
            {<<>>,0};
         _ ->
            encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute controlValue(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<4>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_Control(Tlv) ->
   dec_Control(Tlv, [16]).

dec_Control(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute controlType(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [4]))
end
,

%%-------------------------------------------------
%% attribute criticality(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute controlValue(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{4,V3}|TempTlv4] ->
    {begin
binary_to_list(decode_restricted_string(V3, []))
end
, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'Control',Term1,Term2,Term3},
Res1.


%%================================
%%  BindRequest
%%================================
enc_BindRequest(Val) ->
    enc_BindRequest(Val, [<<96>>]).

enc_BindRequest(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute name(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

%%-------------------------------------------------
%% attribute authentication(3)   External ELDAPv3:AuthenticationChoice
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_AuthenticationChoice'(Cindex3, []),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_BindRequest(Tlv) ->
   dec_BindRequest(Tlv, [65536]).

dec_BindRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
if 1 =< Val1, Val1 =< 127 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute name(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
binary_to_list(decode_restricted_string(V2, [4]))
end
,

%%-------------------------------------------------
%% attribute authentication(3)   External ELDAPv3:AuthenticationChoice
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_AuthenticationChoice'(V3, []),

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'BindRequest',Term1,Term2,Term3},
Res1.


%%================================
%%  AuthenticationChoice
%%================================
enc_AuthenticationChoice(Val) ->
    enc_AuthenticationChoice(Val, []).

enc_AuthenticationChoice(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      simple ->
         encode_restricted_string(element(2,Val), [<<128>>]);
      sasl ->
         'enc_SaslCredentials'(element(2,Val), [<<163>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_AuthenticationChoice(Tlv) ->
   dec_AuthenticationChoice(Tlv, []).

dec_AuthenticationChoice(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'simple'
    {131072, V1} -> 
        {simple, begin
binary_to_list(decode_restricted_string(V1, []))
end
};


%% 'sasl'
    {131075, V1} -> 
        {sasl, 'dec_SaslCredentials'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  SaslCredentials
%%================================
enc_SaslCredentials(Val) ->
    enc_SaslCredentials(Val, [<<48>>]).

enc_SaslCredentials(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute mechanism(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute credentials(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<4>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_SaslCredentials(Tlv) ->
   dec_SaslCredentials(Tlv, [16]).

dec_SaslCredentials(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute mechanism(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [4]))
end
,

%%-------------------------------------------------
%% attribute credentials(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{4,V2}|TempTlv3] ->
    {begin
binary_to_list(decode_restricted_string(V2, []))
end
, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'SaslCredentials',Term1,Term2},
Res1.


%%================================
%%  BindResponse
%%================================
enc_BindResponse(Val) ->
    enc_BindResponse(Val, [<<97>>]).

enc_BindResponse(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5} = Val,

%%-------------------------------------------------
%% attribute resultCode(1) with type ENUMERATED
%%-------------------------------------------------
   {EncBytes1,EncLen1} = case Cindex1 of
success -> encode_tags([<<10>>], [0], 1);
operationsError -> encode_tags([<<10>>], [1], 1);
protocolError -> encode_tags([<<10>>], [2], 1);
timeLimitExceeded -> encode_tags([<<10>>], [3], 1);
sizeLimitExceeded -> encode_tags([<<10>>], [4], 1);
compareFalse -> encode_tags([<<10>>], [5], 1);
compareTrue -> encode_tags([<<10>>], [6], 1);
authMethodNotSupported -> encode_tags([<<10>>], [7], 1);
strongerAuthRequired -> encode_tags([<<10>>], [8], 1);
referral -> encode_tags([<<10>>], [10], 1);
adminLimitExceeded -> encode_tags([<<10>>], [11], 1);
unavailableCriticalExtension -> encode_tags([<<10>>], [12], 1);
confidentialityRequired -> encode_tags([<<10>>], [13], 1);
saslBindInProgress -> encode_tags([<<10>>], [14], 1);
noSuchAttribute -> encode_tags([<<10>>], [16], 1);
undefinedAttributeType -> encode_tags([<<10>>], [17], 1);
inappropriateMatching -> encode_tags([<<10>>], [18], 1);
constraintViolation -> encode_tags([<<10>>], [19], 1);
attributeOrValueExists -> encode_tags([<<10>>], [20], 1);
invalidAttributeSyntax -> encode_tags([<<10>>], [21], 1);
noSuchObject -> encode_tags([<<10>>], [32], 1);
aliasProblem -> encode_tags([<<10>>], [33], 1);
invalidDNSyntax -> encode_tags([<<10>>], [34], 1);
aliasDereferencingProblem -> encode_tags([<<10>>], [36], 1);
inappropriateAuthentication -> encode_tags([<<10>>], [48], 1);
invalidCredentials -> encode_tags([<<10>>], [49], 1);
insufficientAccessRights -> encode_tags([<<10>>], [50], 1);
busy -> encode_tags([<<10>>], [51], 1);
unavailable -> encode_tags([<<10>>], [52], 1);
unwillingToPerform -> encode_tags([<<10>>], [53], 1);
loopDetect -> encode_tags([<<10>>], [54], 1);
namingViolation -> encode_tags([<<10>>], [64], 1);
objectClassViolation -> encode_tags([<<10>>], [65], 1);
notAllowedOnNonLeaf -> encode_tags([<<10>>], [66], 1);
notAllowedOnRDN -> encode_tags([<<10>>], [67], 1);
entryAlreadyExists -> encode_tags([<<10>>], [68], 1);
objectClassModsProhibited -> encode_tags([<<10>>], [69], 1);
affectsMultipleDSAs -> encode_tags([<<10>>], [71], 1);
other -> encode_tags([<<10>>], [80], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute matchedDN(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

%%-------------------------------------------------
%% attribute diagnosticMessage(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

%%-------------------------------------------------
%% attribute referral(4)   External ELDAPv3:Referral OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Referral'(Cindex4, [<<163>>])
       end,

%%-------------------------------------------------
%% attribute serverSaslCreds(5) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex5, [<<135>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_BindResponse(Tlv) ->
   dec_BindResponse(Tlv, [65537]).

dec_BindResponse(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute resultCode(1) with type ENUMERATED
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = case decode_integer(V1, [10]) of
0 -> success;
1 -> operationsError;
2 -> protocolError;
3 -> timeLimitExceeded;
4 -> sizeLimitExceeded;
5 -> compareFalse;
6 -> compareTrue;
7 -> authMethodNotSupported;
8 -> strongerAuthRequired;
10 -> referral;
11 -> adminLimitExceeded;
12 -> unavailableCriticalExtension;
13 -> confidentialityRequired;
14 -> saslBindInProgress;
16 -> noSuchAttribute;
17 -> undefinedAttributeType;
18 -> inappropriateMatching;
19 -> constraintViolation;
20 -> attributeOrValueExists;
21 -> invalidAttributeSyntax;
32 -> noSuchObject;
33 -> aliasProblem;
34 -> invalidDNSyntax;
36 -> aliasDereferencingProblem;
48 -> inappropriateAuthentication;
49 -> invalidCredentials;
50 -> insufficientAccessRights;
51 -> busy;
52 -> unavailable;
53 -> unwillingToPerform;
54 -> loopDetect;
64 -> namingViolation;
65 -> objectClassViolation;
66 -> notAllowedOnNonLeaf;
67 -> notAllowedOnRDN;
68 -> entryAlreadyExists;
69 -> objectClassModsProhibited;
71 -> affectsMultipleDSAs;
80 -> other;
Default1 -> {asn1_enum,Default1}
end,

%%-------------------------------------------------
%% attribute matchedDN(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
binary_to_list(decode_restricted_string(V2, [4]))
end
,

%%-------------------------------------------------
%% attribute diagnosticMessage(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = begin
binary_to_list(decode_restricted_string(V3, [4]))
end
,

%%-------------------------------------------------
%% attribute referral(4)   External ELDAPv3:Referral OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {'dec_Referral'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute serverSaslCreds(5) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131079,V5}|TempTlv6] ->
    {begin
binary_to_list(decode_restricted_string(V5, []))
end
, TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

case Tlv6 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'BindResponse',Term1,Term2,Term3,Term4,Term5},
Res1.


%%================================
%%  UnbindRequest
%%================================
enc_UnbindRequest(Val) ->
    enc_UnbindRequest(Val, [<<66>>]).

enc_UnbindRequest(Val, TagIn) ->
encode_null(Val, TagIn).


dec_UnbindRequest(Tlv) ->
   dec_UnbindRequest(Tlv, [65538]).

dec_UnbindRequest(Tlv, TagIn) ->
decode_null(Tlv, TagIn).



%%================================
%%  SearchRequest
%%================================
enc_SearchRequest(Val) ->
    enc_SearchRequest(Val, [<<99>>]).

enc_SearchRequest(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7,Cindex8} = Val,

%%-------------------------------------------------
%% attribute baseObject(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute scope(2) with type ENUMERATED
%%-------------------------------------------------
   {EncBytes2,EncLen2} = case Cindex2 of
baseObject -> encode_tags([<<10>>], [0], 1);
singleLevel -> encode_tags([<<10>>], [1], 1);
wholeSubtree -> encode_tags([<<10>>], [2], 1);
Enumval2 -> exit({error,{asn1, {enumerated_not_in_range,Enumval2}}})
end,

%%-------------------------------------------------
%% attribute derefAliases(3) with type ENUMERATED
%%-------------------------------------------------
   {EncBytes3,EncLen3} = case Cindex3 of
neverDerefAliases -> encode_tags([<<10>>], [0], 1);
derefInSearching -> encode_tags([<<10>>], [1], 1);
derefFindingBaseObj -> encode_tags([<<10>>], [2], 1);
derefAlways -> encode_tags([<<10>>], [3], 1);
Enumval3 -> exit({error,{asn1, {enumerated_not_in_range,Enumval3}}})
end,

%%-------------------------------------------------
%% attribute sizeLimit(4) with type INTEGER
%%-------------------------------------------------
   {EncBytes4,EncLen4} = encode_integer(Cindex4, [<<2>>]),

%%-------------------------------------------------
%% attribute timeLimit(5) with type INTEGER
%%-------------------------------------------------
   {EncBytes5,EncLen5} = encode_integer(Cindex5, [<<2>>]),

%%-------------------------------------------------
%% attribute typesOnly(6) with type BOOLEAN
%%-------------------------------------------------
   {EncBytes6,EncLen6} = encode_boolean(Cindex6, [<<1>>]),

%%-------------------------------------------------
%% attribute filter(7)   External ELDAPv3:Filter
%%-------------------------------------------------
   {EncBytes7,EncLen7} = 'enc_Filter'(Cindex7, []),

%%-------------------------------------------------
%% attribute attributes(8)   External ELDAPv3:AttributeSelection
%%-------------------------------------------------
   {EncBytes8,EncLen8} = 'enc_AttributeSelection'(Cindex8, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_SearchRequest(Tlv) ->
   dec_SearchRequest(Tlv, [65539]).

dec_SearchRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute baseObject(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [4]))
end
,

%%-------------------------------------------------
%% attribute scope(2) with type ENUMERATED
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = case decode_integer(V2, [10]) of
0 -> baseObject;
1 -> singleLevel;
2 -> wholeSubtree;
Default1 -> {asn1_enum,Default1}
end,

%%-------------------------------------------------
%% attribute derefAliases(3) with type ENUMERATED
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = case decode_integer(V3, [10]) of
0 -> neverDerefAliases;
1 -> derefInSearching;
2 -> derefFindingBaseObj;
3 -> derefAlways;
Default2 -> {asn1_enum,Default2}
end,

%%-------------------------------------------------
%% attribute sizeLimit(4) with type INTEGER
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = begin
Val1 = decode_integer(V4, [2]),
if 0 =< Val1, Val1 =< 2147483647 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute timeLimit(5) with type INTEGER
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = begin
Val2 = decode_integer(V5, [2]),
if 0 =< Val2, Val2 =< 2147483647 ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute typesOnly(6) with type BOOLEAN
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = decode_boolean(V6, [1]),

%%-------------------------------------------------
%% attribute filter(7)   External ELDAPv3:Filter
%%-------------------------------------------------
[V7|Tlv8] = Tlv7, 
Term7 = 'dec_Filter'(V7, []),

%%-------------------------------------------------
%% attribute attributes(8)   External ELDAPv3:AttributeSelection
%%-------------------------------------------------
[V8|Tlv9] = Tlv8, 
Term8 = 'dec_AttributeSelection'(V8, [16]),

case Tlv9 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'SearchRequest',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8},
Res1.


%%================================
%%  AttributeSelection
%%================================
enc_AttributeSelection(Val) ->
    enc_AttributeSelection(Val, [<<48>>]).

enc_AttributeSelection(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_AttributeSelection_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AttributeSelection_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AttributeSelection_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<4>>]),
   'enc_AttributeSelection_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_AttributeSelection(Tlv) ->
   dec_AttributeSelection(Tlv, [16]).

dec_AttributeSelection(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
binary_to_list(decode_restricted_string(V1, [4]))
end
 || V1 <- Tlv1].




%%================================
%%  Filter
%%================================
enc_Filter(Val) ->
    enc_Filter(Val, []).

enc_Filter(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      'and' ->
         'enc_Filter_and'(element(2,Val), [<<160>>]);
      'or' ->
         'enc_Filter_or'(element(2,Val), [<<161>>]);
      'not' ->
         'enc_Filter'(element(2,Val), [<<162>>]);
      equalityMatch ->
         'enc_AttributeValueAssertion'(element(2,Val), [<<163>>]);
      substrings ->
         'enc_SubstringFilter'(element(2,Val), [<<164>>]);
      greaterOrEqual ->
         'enc_AttributeValueAssertion'(element(2,Val), [<<165>>]);
      lessOrEqual ->
         'enc_AttributeValueAssertion'(element(2,Val), [<<166>>]);
      present ->
         encode_restricted_string(element(2,Val), [<<135>>]);
      approxMatch ->
         'enc_AttributeValueAssertion'(element(2,Val), [<<168>>]);
      extensibleMatch ->
         'enc_MatchingRuleAssertion'(element(2,Val), [<<169>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).





%%================================
%%  Filter_and
%%================================
enc_Filter_and(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Filter_and_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Filter_and_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Filter_and_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Filter'(H, []),
   'enc_Filter_and_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  Filter_or
%%================================
enc_Filter_or(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_Filter_or_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Filter_or_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Filter_or_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Filter'(H, []),
   'enc_Filter_or_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_Filter(Tlv) ->
   dec_Filter(Tlv, []).

dec_Filter(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'and'
    {131072, V1} -> 
        {'and', 'dec_Filter_and'(V1, [])};


%% 'or'
    {131073, V1} -> 
        {'or', 'dec_Filter_or'(V1, [])};


%% 'not'
    {131074, V1} -> 
        {'not', 'dec_Filter'(V1, [])};


%% 'equalityMatch'
    {131075, V1} -> 
        {equalityMatch, 'dec_AttributeValueAssertion'(V1, [])};


%% 'substrings'
    {131076, V1} -> 
        {substrings, 'dec_SubstringFilter'(V1, [])};


%% 'greaterOrEqual'
    {131077, V1} -> 
        {greaterOrEqual, 'dec_AttributeValueAssertion'(V1, [])};


%% 'lessOrEqual'
    {131078, V1} -> 
        {lessOrEqual, 'dec_AttributeValueAssertion'(V1, [])};


%% 'present'
    {131079, V1} -> 
        {present, begin
binary_to_list(decode_restricted_string(V1, []))
end
};


%% 'approxMatch'
    {131080, V1} -> 
        {approxMatch, 'dec_AttributeValueAssertion'(V1, [])};


%% 'extensibleMatch'
    {131081, V1} -> 
        {extensibleMatch, 'dec_MatchingRuleAssertion'(V1, [])};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.
'dec_Filter_and'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Filter'(V1, []) || V1 <- Tlv1].


'dec_Filter_or'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Filter'(V1, []) || V1 <- Tlv1].




%%================================
%%  SubstringFilter
%%================================
enc_SubstringFilter(Val) ->
    enc_SubstringFilter(Val, [<<48>>]).

enc_SubstringFilter(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute type(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute substrings(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_SubstringFilter_substrings'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  SubstringFilter_substrings
%%================================
enc_SubstringFilter_substrings(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_SubstringFilter_substrings_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SubstringFilter_substrings_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SubstringFilter_substrings_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_SubstringFilter_substrings_SEQOF'(H, []),
   'enc_SubstringFilter_substrings_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  SubstringFilter_substrings_SEQOF
%%================================
enc_SubstringFilter_substrings_SEQOF(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      initial ->
         encode_restricted_string(element(2,Val), [<<128>>]);
      any ->
         encode_restricted_string(element(2,Val), [<<129>>]);
      final ->
         encode_restricted_string(element(2,Val), [<<130>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_SubstringFilter(Tlv) ->
   dec_SubstringFilter(Tlv, [16]).

dec_SubstringFilter(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [4]))
end
,

%%-------------------------------------------------
%% attribute substrings(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_SubstringFilter_substrings'(V2, [16]),

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'SubstringFilter',Term1,Term2},
Res1.
'dec_SubstringFilter_substrings'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_SubstringFilter_substrings_SEQOF'(V1, []) || V1 <- Tlv1].


'dec_SubstringFilter_substrings_SEQOF'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'initial'
    {131072, V1} -> 
        {initial, begin
binary_to_list(decode_restricted_string(V1, []))
end
};


%% 'any'
    {131073, V1} -> 
        {any, begin
binary_to_list(decode_restricted_string(V1, []))
end
};


%% 'final'
    {131074, V1} -> 
        {final, begin
binary_to_list(decode_restricted_string(V1, []))
end
};

      Else -> 
         {asn1_ExtAlt,ber_encode(Else)}
   end
.


%%================================
%%  MatchingRuleAssertion
%%================================
enc_MatchingRuleAssertion(Val) ->
    enc_MatchingRuleAssertion(Val, [<<48>>]).

enc_MatchingRuleAssertion(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute matchingRule(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute type(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute matchValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<131>>]),

%%-------------------------------------------------
%% attribute dnAttributes(4) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_DEFAULT ->
            {<<>>,0};
         _ when Cindex4 =:= false ->
            {<<>>,0};
         _ ->
            encode_boolean(Cindex4, [<<132>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_MatchingRuleAssertion(Tlv) ->
   dec_MatchingRuleAssertion(Tlv, [16]).

dec_MatchingRuleAssertion(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute matchingRule(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131073,V1}|TempTlv2] ->
    {begin
binary_to_list(decode_restricted_string(V1, []))
end
, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute type(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131074,V2}|TempTlv3] ->
    {begin
binary_to_list(decode_restricted_string(V2, []))
end
, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute matchValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = begin
binary_to_list(decode_restricted_string(V3, [131075]))
end
,

%%-------------------------------------------------
%% attribute dnAttributes(4) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131076,V4}|TempTlv5] ->
    {decode_boolean(V4, []), TempTlv5};
    _ ->
        {false,Tlv4}
end,

case Tlv5 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'MatchingRuleAssertion',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  SearchResultEntry
%%================================
enc_SearchResultEntry(Val) ->
    enc_SearchResultEntry(Val, [<<100>>]).

enc_SearchResultEntry(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute objectName(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute attributes(2)   External ELDAPv3:PartialAttributeList
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PartialAttributeList'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_SearchResultEntry(Tlv) ->
   dec_SearchResultEntry(Tlv, [65540]).

dec_SearchResultEntry(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute objectName(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [4]))
end
,

%%-------------------------------------------------
%% attribute attributes(2)   External ELDAPv3:PartialAttributeList
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PartialAttributeList'(V2, [16]),

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'SearchResultEntry',Term1,Term2},
Res1.


%%================================
%%  PartialAttributeList
%%================================
enc_PartialAttributeList(Val) ->
    enc_PartialAttributeList(Val, [<<48>>]).

enc_PartialAttributeList(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_PartialAttributeList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_PartialAttributeList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_PartialAttributeList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_PartialAttribute'(H, [<<48>>]),
   'enc_PartialAttributeList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_PartialAttributeList(Tlv) ->
   dec_PartialAttributeList(Tlv, [16]).

dec_PartialAttributeList(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_PartialAttribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  SearchResultReference
%%================================
enc_SearchResultReference(Val) ->
    enc_SearchResultReference(Val, [<<115>>]).

enc_SearchResultReference(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_SearchResultReference_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_SearchResultReference_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_SearchResultReference_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = encode_restricted_string(H, [<<4>>]),
   'enc_SearchResultReference_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_SearchResultReference(Tlv) ->
   dec_SearchResultReference(Tlv, [65555]).

dec_SearchResultReference(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
[begin
binary_to_list(decode_restricted_string(V1, [4]))
end
 || V1 <- Tlv1].




%%================================
%%  SearchResultDone
%%================================
enc_SearchResultDone(Val) ->
    enc_SearchResultDone(Val, [<<101>>]).

enc_SearchResultDone(Val, TagIn) ->
   enc_LDAPResult(Val, TagIn).


dec_SearchResultDone(Tlv) ->
   dec_SearchResultDone(Tlv, [65541]).

dec_SearchResultDone(Tlv, TagIn) ->
'dec_LDAPResult'(Tlv, TagIn).



%%================================
%%  ModifyRequest
%%================================
enc_ModifyRequest(Val) ->
    enc_ModifyRequest(Val, [<<102>>]).

enc_ModifyRequest(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute object(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute changes(2) with type SEQUENCE OF
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_ModifyRequest_changes'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  ModifyRequest_changes
%%================================
enc_ModifyRequest_changes(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_ModifyRequest_changes_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_ModifyRequest_changes_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_ModifyRequest_changes_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_ModifyRequest_changes_SEQOF'(H, [<<48>>]),
   'enc_ModifyRequest_changes_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  ModifyRequest_changes_SEQOF
%%================================
enc_ModifyRequest_changes_SEQOF(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute operation(1) with type ENUMERATED
%%-------------------------------------------------
   {EncBytes1,EncLen1} = case Cindex1 of
add -> encode_tags([<<10>>], [0], 1);
delete -> encode_tags([<<10>>], [1], 1);
replace -> encode_tags([<<10>>], [2], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute modification(2)   External ELDAPv3:PartialAttribute
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_PartialAttribute'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ModifyRequest(Tlv) ->
   dec_ModifyRequest(Tlv, [65542]).

dec_ModifyRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute object(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [4]))
end
,

%%-------------------------------------------------
%% attribute changes(2) with type SEQUENCE OF
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_ModifyRequest_changes'(V2, [16]),

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'ModifyRequest',Term1,Term2},
Res1.
'dec_ModifyRequest_changes'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_ModifyRequest_changes_SEQOF'(V1, [16]) || V1 <- Tlv1].


'dec_ModifyRequest_changes_SEQOF'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute operation(1) with type ENUMERATED
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = case decode_integer(V1, [10]) of
0 -> add;
1 -> delete;
2 -> replace;
Default1 -> {asn1_enum,Default1}
end,

%%-------------------------------------------------
%% attribute modification(2)   External ELDAPv3:PartialAttribute
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_PartialAttribute'(V2, [16]),

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'ModifyRequest_changes_SEQOF',Term1,Term2},
Res1.


%%================================
%%  ModifyResponse
%%================================
enc_ModifyResponse(Val) ->
    enc_ModifyResponse(Val, [<<103>>]).

enc_ModifyResponse(Val, TagIn) ->
   enc_LDAPResult(Val, TagIn).


dec_ModifyResponse(Tlv) ->
   dec_ModifyResponse(Tlv, [65543]).

dec_ModifyResponse(Tlv, TagIn) ->
'dec_LDAPResult'(Tlv, TagIn).



%%================================
%%  AddRequest
%%================================
enc_AddRequest(Val) ->
    enc_AddRequest(Val, [<<104>>]).

enc_AddRequest(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute entry(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute attributes(2)   External ELDAPv3:AttributeList
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AttributeList'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_AddRequest(Tlv) ->
   dec_AddRequest(Tlv, [65544]).

dec_AddRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute entry(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [4]))
end
,

%%-------------------------------------------------
%% attribute attributes(2)   External ELDAPv3:AttributeList
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AttributeList'(V2, [16]),

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'AddRequest',Term1,Term2},
Res1.


%%================================
%%  AttributeList
%%================================
enc_AttributeList(Val) ->
    enc_AttributeList(Val, [<<48>>]).

enc_AttributeList(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_AttributeList_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_AttributeList_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_AttributeList_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_Attribute'(H, [<<48>>]),
   'enc_AttributeList_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_AttributeList(Tlv) ->
   dec_AttributeList(Tlv, [16]).

dec_AttributeList(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_Attribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  AddResponse
%%================================
enc_AddResponse(Val) ->
    enc_AddResponse(Val, [<<105>>]).

enc_AddResponse(Val, TagIn) ->
   enc_LDAPResult(Val, TagIn).


dec_AddResponse(Tlv) ->
   dec_AddResponse(Tlv, [65545]).

dec_AddResponse(Tlv, TagIn) ->
'dec_LDAPResult'(Tlv, TagIn).



%%================================
%%  DelRequest
%%================================
enc_DelRequest(Val) ->
    enc_DelRequest(Val, [<<74>>]).

enc_DelRequest(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_DelRequest(Tlv) ->
   dec_DelRequest(Tlv, [65546]).

dec_DelRequest(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  DelResponse
%%================================
enc_DelResponse(Val) ->
    enc_DelResponse(Val, [<<107>>]).

enc_DelResponse(Val, TagIn) ->
   enc_LDAPResult(Val, TagIn).


dec_DelResponse(Tlv) ->
   dec_DelResponse(Tlv, [65547]).

dec_DelResponse(Tlv, TagIn) ->
'dec_LDAPResult'(Tlv, TagIn).



%%================================
%%  ModifyDNRequest
%%================================
enc_ModifyDNRequest(Val) ->
    enc_ModifyDNRequest(Val, [<<108>>]).

enc_ModifyDNRequest(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute entry(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute newrdn(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

%%-------------------------------------------------
%% attribute deleteoldrdn(3) with type BOOLEAN
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_boolean(Cindex3, [<<1>>]),

%%-------------------------------------------------
%% attribute newSuperior(4) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex4, [<<128>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ModifyDNRequest(Tlv) ->
   dec_ModifyDNRequest(Tlv, [65548]).

dec_ModifyDNRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute entry(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [4]))
end
,

%%-------------------------------------------------
%% attribute newrdn(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
binary_to_list(decode_restricted_string(V2, [4]))
end
,

%%-------------------------------------------------
%% attribute deleteoldrdn(3) with type BOOLEAN
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_boolean(V3, [1]),

%%-------------------------------------------------
%% attribute newSuperior(4) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131072,V4}|TempTlv5] ->
    {begin
binary_to_list(decode_restricted_string(V4, []))
end
, TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

case Tlv5 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'ModifyDNRequest',Term1,Term2,Term3,Term4},
Res1.


%%================================
%%  ModifyDNResponse
%%================================
enc_ModifyDNResponse(Val) ->
    enc_ModifyDNResponse(Val, [<<109>>]).

enc_ModifyDNResponse(Val, TagIn) ->
   enc_LDAPResult(Val, TagIn).


dec_ModifyDNResponse(Tlv) ->
   dec_ModifyDNResponse(Tlv, [65549]).

dec_ModifyDNResponse(Tlv, TagIn) ->
'dec_LDAPResult'(Tlv, TagIn).



%%================================
%%  CompareRequest
%%================================
enc_CompareRequest(Val) ->
    enc_CompareRequest(Val, [<<110>>]).

enc_CompareRequest(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute entry(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<4>>]),

%%-------------------------------------------------
%% attribute ava(2)   External ELDAPv3:AttributeValueAssertion
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_AttributeValueAssertion'(Cindex2, [<<48>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_CompareRequest(Tlv) ->
   dec_CompareRequest(Tlv, [65550]).

dec_CompareRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute entry(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [4]))
end
,

%%-------------------------------------------------
%% attribute ava(2)   External ELDAPv3:AttributeValueAssertion
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_AttributeValueAssertion'(V2, [16]),

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'CompareRequest',Term1,Term2},
Res1.


%%================================
%%  CompareResponse
%%================================
enc_CompareResponse(Val) ->
    enc_CompareResponse(Val, [<<111>>]).

enc_CompareResponse(Val, TagIn) ->
   enc_LDAPResult(Val, TagIn).


dec_CompareResponse(Tlv) ->
   dec_CompareResponse(Tlv, [65551]).

dec_CompareResponse(Tlv, TagIn) ->
'dec_LDAPResult'(Tlv, TagIn).



%%================================
%%  AbandonRequest
%%================================
enc_AbandonRequest(Val) ->
    enc_AbandonRequest(Val, [<<80>>]).

enc_AbandonRequest(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_AbandonRequest(Tlv) ->
   dec_AbandonRequest(Tlv, [65552]).

dec_AbandonRequest(Tlv, TagIn) ->
begin
Val1 = decode_integer(Tlv, TagIn),
if 0 =< Val1, Val1 =< 2147483647 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end.



%%================================
%%  ExtendedRequest
%%================================
enc_ExtendedRequest(Val) ->
    enc_ExtendedRequest(Val, [<<119>>]).

enc_ExtendedRequest(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute requestName(1) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_restricted_string(Cindex1, [<<128>>]),

%%-------------------------------------------------
%% attribute requestValue(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ExtendedRequest(Tlv) ->
   dec_ExtendedRequest(Tlv, [65559]).

dec_ExtendedRequest(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute requestName(1) with type OCTET STRING
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
binary_to_list(decode_restricted_string(V1, [131072]))
end
,

%%-------------------------------------------------
%% attribute requestValue(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
binary_to_list(decode_restricted_string(V2, []))
end
, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'ExtendedRequest',Term1,Term2},
Res1.


%%================================
%%  ExtendedResponse
%%================================
enc_ExtendedResponse(Val) ->
    enc_ExtendedResponse(Val, [<<120>>]).

enc_ExtendedResponse(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6} = Val,

%%-------------------------------------------------
%% attribute resultCode(1) with type ENUMERATED
%%-------------------------------------------------
   {EncBytes1,EncLen1} = case Cindex1 of
success -> encode_tags([<<10>>], [0], 1);
operationsError -> encode_tags([<<10>>], [1], 1);
protocolError -> encode_tags([<<10>>], [2], 1);
timeLimitExceeded -> encode_tags([<<10>>], [3], 1);
sizeLimitExceeded -> encode_tags([<<10>>], [4], 1);
compareFalse -> encode_tags([<<10>>], [5], 1);
compareTrue -> encode_tags([<<10>>], [6], 1);
authMethodNotSupported -> encode_tags([<<10>>], [7], 1);
strongerAuthRequired -> encode_tags([<<10>>], [8], 1);
referral -> encode_tags([<<10>>], [10], 1);
adminLimitExceeded -> encode_tags([<<10>>], [11], 1);
unavailableCriticalExtension -> encode_tags([<<10>>], [12], 1);
confidentialityRequired -> encode_tags([<<10>>], [13], 1);
saslBindInProgress -> encode_tags([<<10>>], [14], 1);
noSuchAttribute -> encode_tags([<<10>>], [16], 1);
undefinedAttributeType -> encode_tags([<<10>>], [17], 1);
inappropriateMatching -> encode_tags([<<10>>], [18], 1);
constraintViolation -> encode_tags([<<10>>], [19], 1);
attributeOrValueExists -> encode_tags([<<10>>], [20], 1);
invalidAttributeSyntax -> encode_tags([<<10>>], [21], 1);
noSuchObject -> encode_tags([<<10>>], [32], 1);
aliasProblem -> encode_tags([<<10>>], [33], 1);
invalidDNSyntax -> encode_tags([<<10>>], [34], 1);
aliasDereferencingProblem -> encode_tags([<<10>>], [36], 1);
inappropriateAuthentication -> encode_tags([<<10>>], [48], 1);
invalidCredentials -> encode_tags([<<10>>], [49], 1);
insufficientAccessRights -> encode_tags([<<10>>], [50], 1);
busy -> encode_tags([<<10>>], [51], 1);
unavailable -> encode_tags([<<10>>], [52], 1);
unwillingToPerform -> encode_tags([<<10>>], [53], 1);
loopDetect -> encode_tags([<<10>>], [54], 1);
namingViolation -> encode_tags([<<10>>], [64], 1);
objectClassViolation -> encode_tags([<<10>>], [65], 1);
notAllowedOnNonLeaf -> encode_tags([<<10>>], [66], 1);
notAllowedOnRDN -> encode_tags([<<10>>], [67], 1);
entryAlreadyExists -> encode_tags([<<10>>], [68], 1);
objectClassModsProhibited -> encode_tags([<<10>>], [69], 1);
affectsMultipleDSAs -> encode_tags([<<10>>], [71], 1);
other -> encode_tags([<<10>>], [80], 1);
Enumval1 -> exit({error,{asn1, {enumerated_not_in_range,Enumval1}}})
end,

%%-------------------------------------------------
%% attribute matchedDN(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

%%-------------------------------------------------
%% attribute diagnosticMessage(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

%%-------------------------------------------------
%% attribute referral(4)   External ELDAPv3:Referral OPTIONAL
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case Cindex4 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_Referral'(Cindex4, [<<163>>])
       end,

%%-------------------------------------------------
%% attribute responseName(5) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes5,EncLen5} =  case Cindex5 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex5, [<<138>>])
       end,

%%-------------------------------------------------
%% attribute responseValue(6) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes6,EncLen6} =  case Cindex6 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex6, [<<139>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_ExtendedResponse(Tlv) ->
   dec_ExtendedResponse(Tlv, [65560]).

dec_ExtendedResponse(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute resultCode(1) with type ENUMERATED
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = case decode_integer(V1, [10]) of
0 -> success;
1 -> operationsError;
2 -> protocolError;
3 -> timeLimitExceeded;
4 -> sizeLimitExceeded;
5 -> compareFalse;
6 -> compareTrue;
7 -> authMethodNotSupported;
8 -> strongerAuthRequired;
10 -> referral;
11 -> adminLimitExceeded;
12 -> unavailableCriticalExtension;
13 -> confidentialityRequired;
14 -> saslBindInProgress;
16 -> noSuchAttribute;
17 -> undefinedAttributeType;
18 -> inappropriateMatching;
19 -> constraintViolation;
20 -> attributeOrValueExists;
21 -> invalidAttributeSyntax;
32 -> noSuchObject;
33 -> aliasProblem;
34 -> invalidDNSyntax;
36 -> aliasDereferencingProblem;
48 -> inappropriateAuthentication;
49 -> invalidCredentials;
50 -> insufficientAccessRights;
51 -> busy;
52 -> unavailable;
53 -> unwillingToPerform;
54 -> loopDetect;
64 -> namingViolation;
65 -> objectClassViolation;
66 -> notAllowedOnNonLeaf;
67 -> notAllowedOnRDN;
68 -> entryAlreadyExists;
69 -> objectClassModsProhibited;
71 -> affectsMultipleDSAs;
80 -> other;
Default1 -> {asn1_enum,Default1}
end,

%%-------------------------------------------------
%% attribute matchedDN(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
binary_to_list(decode_restricted_string(V2, [4]))
end
,

%%-------------------------------------------------
%% attribute diagnosticMessage(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = begin
binary_to_list(decode_restricted_string(V3, [4]))
end
,

%%-------------------------------------------------
%% attribute referral(4)   External ELDAPv3:Referral OPTIONAL
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{131075,V4}|TempTlv5] ->
    {'dec_Referral'(V4, []), TempTlv5};
    _ ->
        { asn1_NOVALUE, Tlv4}
end,

%%-------------------------------------------------
%% attribute responseName(5) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term5,Tlv6} = case Tlv5 of
[{131082,V5}|TempTlv6] ->
    {begin
binary_to_list(decode_restricted_string(V5, []))
end
, TempTlv6};
    _ ->
        { asn1_NOVALUE, Tlv5}
end,

%%-------------------------------------------------
%% attribute responseValue(6) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term6,Tlv7} = case Tlv6 of
[{131083,V6}|TempTlv7] ->
    {begin
binary_to_list(decode_restricted_string(V6, []))
end
, TempTlv7};
    _ ->
        { asn1_NOVALUE, Tlv6}
end,

case Tlv7 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'ExtendedResponse',Term1,Term2,Term3,Term4,Term5,Term6},
Res1.


%%================================
%%  IntermediateResponse
%%================================
enc_IntermediateResponse(Val) ->
    enc_IntermediateResponse(Val, [<<121>>]).

enc_IntermediateResponse(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute responseName(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute responseValue(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<129>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_IntermediateResponse(Tlv) ->
   dec_IntermediateResponse(Tlv, [65561]).

dec_IntermediateResponse(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute responseName(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
binary_to_list(decode_restricted_string(V1, []))
end
, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute responseValue(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
binary_to_list(decode_restricted_string(V2, []))
end
, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'IntermediateResponse',Term1,Term2},
Res1.


%%================================
%%  PasswdModifyRequestValue
%%================================
enc_PasswdModifyRequestValue(Val) ->
    enc_PasswdModifyRequestValue(Val, [<<48>>]).

enc_PasswdModifyRequestValue(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute userIdentity(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<128>>])
       end,

%%-------------------------------------------------
%% attribute oldPasswd(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex2, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute newPasswd(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex3, [<<130>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PasswdModifyRequestValue(Tlv) ->
   dec_PasswdModifyRequestValue(Tlv, [16]).

dec_PasswdModifyRequestValue(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute userIdentity(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
binary_to_list(decode_restricted_string(V1, []))
end
, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute oldPasswd(2) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{131073,V2}|TempTlv3] ->
    {begin
binary_to_list(decode_restricted_string(V2, []))
end
, TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

%%-------------------------------------------------
%% attribute newPasswd(3) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{131074,V3}|TempTlv4] ->
    {begin
binary_to_list(decode_restricted_string(V3, []))
end
, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

case Tlv4 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'PasswdModifyRequestValue',Term1,Term2,Term3},
Res1.


%%================================
%%  PasswdModifyResponseValue
%%================================
enc_PasswdModifyResponseValue(Val) ->
    enc_PasswdModifyResponseValue(Val, [<<48>>]).

enc_PasswdModifyResponseValue(Val, TagIn) ->
{_,Cindex1} = Val,

%%-------------------------------------------------
%% attribute genPasswd(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_restricted_string(Cindex1, [<<128>>])
       end,

   BytesSoFar = [EncBytes1],
LenSoFar = EncLen1,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_PasswdModifyResponseValue(Tlv) ->
   dec_PasswdModifyResponseValue(Tlv, [16]).

dec_PasswdModifyResponseValue(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute genPasswd(1) with type OCTET STRING OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
binary_to_list(decode_restricted_string(V1, []))
end
, TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

case Tlv2 of [] -> true; _ -> true end, % ... extra fields skipped
Res1 = {'PasswdModifyResponseValue',Term1},
Res1.
maxInt() ->
2147483647.


%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_,L}|Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L)|Acc]);
collect_parts([{3,<<Unused,Bits/binary>>}|Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T,V}|Rest], Acc) ->
    collect_parts(Rest, [V|Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3,<<Unused,Bits/binary>>}|Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits|Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc|lists:reverse(Acc)]).

decode_boolean(Tlv, TagIn) ->
    Val = match_tags(Tlv, TagIn),
    case Val of
        <<0:8>> ->
            false;
        <<_:8>> ->
            true;
        _ ->
            exit({error,{asn1,{decode_boolean,Val}}})
    end.

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_null(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    case Val of
        <<>> ->
            'NULL';
        _ ->
            exit({error,{asn1,{decode_null,Val}}})
    end.

decode_restricted_string(Tlv, TagsIn) ->
    match_and_collect(Tlv, TagsIn).

encode_boolean(true, TagIn) ->
    encode_tags(TagIn, [255], 1);
encode_boolean(false, TagIn) ->
    encode_tags(TagIn, [0], 1);
encode_boolean(X, _) ->
    exit({error,{asn1,{encode_boolean,X}}}).

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes,length(Bytes)}.

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error,{asn1,{encode_integer,Val}}}).

encode_integer_neg(- 1, [B1|_T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255|Acc]).

encode_integer_pos(0, [B|_Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255|Acc]).

encode_length(L) when L =< 127 ->
    {[L],1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len|Oct],Len + 1};
        true ->
            exit({error,{asn1,too_long_length_oct,Len}})
    end.

encode_null(_Val, TagIn) ->
    encode_tags(TagIn, [], 0).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar,LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag|Trest], BytesSoFar, LenSoFar) ->
    {Bytes2,L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag,Bytes2|BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar,LenSoFar}.

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_|_] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T,V}, [T]) ->
    V;
match_tags({T,V}, [T|Tt]) ->
    match_tags(V, Tt);
match_tags([{T,V}], [T|Tt]) ->
    match_tags(V, Tt);
match_tags([{T,_V}|_] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag,_V} = Tlv, [T|_Tt]) ->
    exit({error,{asn1,{wrong_tag,{{expected,T},{got,Tag,Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255|Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).
