searchData={"items":[{"type":"module","title":"reltool","doc":"Main API of the Reltool application\n\nThis is an interface module for the Reltool application.\n\n_Reltool_ is a release management tool. It analyses a given Erlang/OTP\ninstallation and determines various dependencies between applications. The\n`graphical` frontend depicts the dependencies and enables interactive\ncustomization of a target system. The backend provides a `batch` interface for\ngeneration of customized target systems.\n\nThe tool uses an installed Erlang/OTP system as input. `root_dir` is the root\ndirectory of the analysed system and it defaults to the system executing\nReltool. Applications may also be located outside `root_dir`. `lib_dirs` defines\nlibrary directories where additional applications may reside and it defaults to\nthe directories listed by the operating system environment variable `ERL_LIBS`.\nSee the module `code` for more info.\n\nAn application directory `AppDir` under a library directory is recognized by the\nexistence of an `AppDir/ebin` directory. If this does not exist, Reltool will\nnot consider `AppDir` at all when looking for applications.\n\nIt is recommended that application directories are named as the application,\npossibly followed by a dash and the version number. For example `myapp` or\n`myapp-1.1`.\n\nFinally single modules and entire applications may be read from Escripts.\n\nSome configuration parameters control the behavior of Reltool on system (`sys`)\nlevel. Others provide control on application (`app`) level and yet others are on\nmodule (`mod`) level. Module level parameters override application level\nparameters and application level parameters override system level parameters.\nEscript `escript` level parameters override system level parameters.\n\nThe following top level `options` are supported:\n\n- **`config`** - This is the main option and it controls the configuration of\n  Reltool. It can either be a `sys` tuple or a name of a `file` containing a sys\n  tuple.\n\n- **`trap_exit`** - This option controls the error handling behavior of Reltool.\n  By default the window processes traps exit, but this behavior can altered by\n  setting `trap_exit` to `false`.\n\n- **`wx_debug`** - This option controls the debug level of `wx`. As its name\n  indicates it is only useful for debugging. See `wx:debug/1` for more info.\n\nBesides the already mentioned source parameters `root_dir` and `lib_dirs`, the\nfollowing system (`sys`) level options are supported:\n\n- **`erts`** - Erts specific configuration. See application level options below.\n\n- **`escript`** - Escript specific configuration. An escript has a mandatory\n  file name and escript level options that are described below.\n\n- **`app`** - Application specific configuration. An application has a mandatory\n  name and application level options that are described below.\n\n- **`mod_cond`** - This parameter controls the module inclusion policy. It\n  defaults to `all` which means that if an application is included (either\n  explicitly or implicitly) all modules in that application will be included.\n  This implies that both modules that exist in the `ebin` directory of the\n  application, as well as modules that are named in the `app` file will be\n  included. If the parameter is set to `ebin`, both modules in the `ebin`\n  directory and derived modules are included. If the parameter is set to `app`,\n  both modules in the `app` file and derived modules are included. `derived`\n  means that only modules that are used by other included modules are included.\n  The `mod_cond` setting on system level is used as default for all\n  applications.\n\n- **`incl_cond`** - This parameter controls the application and escript\n  inclusion policy. It defaults to `derived` which means that the applications\n  that do not have any explicit `incl_cond` setting, will only be included if\n  any other (explicitly or implicitly included) application uses it. The value\n  `include` implies that all applications and escripts that do not have any\n  explicit `incl_cond` setting will be included. `exclude` implies that all\n  applications and escripts that do not have any explicit `incl_cond` setting\n  will be excluded.\n\n- **`boot_rel`** - A target system may have several releases but the one given\n  as `boot_rel` will be used as default when the system is booting up.\n\n- **`rel`** - Release specific configuration. Each release maps to a `rel`,\n  `script` and `boot` file. See the module `systools` for more info about the\n  details. Each release has a name, a version and a set of applications with a\n  few release specific parameters such as type and included applications.\n\n- **`relocatable`** - This parameter controls whether the `erl` executable in\n  the target system should automatically determine where it is installed or if\n  it should use a hardcoded path to the installation. In the latter case the\n  target system must be installed with `reltool:install/2` before it can be\n  used. If the system is relocatable, the file tree containing the target system\n  can be moved to another location without re-installation. The default is\n  `true`.\n\n- **`profile`** - The creation of the specification for a target system is\n  performed in two steps. In the first step a complete specification is\n  generated. It will likely contain much more files than you are interested in\n  in your customized target system. In the second step the specification will be\n  filtered according to your filters. There you have the ability to specify\n  filters per application as well as system wide filters. You can also select a\n  `profile` for your system. Depending on the `profile`, different default\n  filters will be used. There are three different profiles to choose from:\n  `development`, `embedded` and `standalone`. `development` is default. The\n  parameters that are affected by the `profile` are: `incl_sys_filters`,\n  `excl_sys_filters`, `incl_app_filters` and `excl_app_filters`.\n\n- **`app_file`** - This parameter controls the default handling of the `app`\n  files when a target system is generated. It defaults to `keep` which means\n  that `app` files are copied to the target system and their contents are kept\n  as they are. `strip` means that a new `app` file is generated from the\n  contents of the original `app` file where the non included modules are removed\n  from the file. `all` does also imply that a new `app` file is generated from\n  the contents of the original `app` file, with the difference that all included\n  modules are added to the file. If the application does not have any `app` file\n  a file will be created for `all` but not for `keep` and `strip`.\n\n- **`debug_info`** - The `debug_info` parameter controls what debug information\n  in the beam file should be kept or stripped. `keep` keeps all debug info,\n  `strip` strips all debug info, and a list of chunkids keeps only those chunks.\n\n- **`excl_lib`**\n\n  > #### Warning {: .warning }\n  > This option is experimental.\n\n  If the `excl_lib` option is set to `otp_root` then reltool will not copy\n  anything from the Erlang/OTP installation ($OTPROOT) into the target\n  structure. The goal is to create a \"slim\" release which can be used together\n  with an existing Erlang/OTP installation. The target structure will therefore\n  only contain a `lib` directory with the applications that were found outside\n  of $OTPROOT (typically your own applications), and a `releases` directory with\n  the generated `.rel,` `.script` and `.boot` files.\n\n  When starting this release, three things must be specified:\n\n  - **_Which `releases` directory to use_** - Tell the release handler to use\n    the `releases` directory in our target structure instead of\n    `$OTPROOT/releases`. This is done by setting the SASL environment variable\n    `releases_dir`, either from the command line\n    (`-sasl releases_dir  /releases`) or in `sys.config`.\n\n  - **_Which boot file to use_** - The default boot file is\n    `$OTPROOT/bin/start`, but in this case we need to specify a boot file from\n    our target structure, typically ` /releases/ / `.\n    This is done with the `-boot` command line option to `erl`\n\n  - **_The location of our applications_** - The generated .script (and .boot)\n    file uses the environment variable `$RELTOOL_EXT_LIB` as prefix for the\n    paths to all applications. The `-boot_var` option to `erl` can be used for\n    specifying the value of this variable, typically\n    `-boot_var RELTOOL_EXT_LIB  /lib`.\n\n  Example:\n\n  ```text\n  erl -sasl releases_dir \\\"mytarget/releases\\\" -boot mytarget/releases/1.0/myrel\\\n   -boot_var RELTOOL_EXT_LIB mytarget/lib\n  ```\n\n- **`incl_sys_filters`** - This parameter normally contains a list of regular\n  expressions that controls which files in the system should be included. Each\n  file in the target system must match at least one of the listed regular\n  expressions in order to be included. Further the files may not match any\n  filter in `excl_sys_filters` in order to be included. Which application files\n  should be included is controlled with the parameters `incl_app_filters` and\n  `excl_app_filters`. This parameter defaults to `[\".*\"]`.\n\n- **`excl_sys_filters`** - This parameter normally contains a list of regular\n  expressions that controls which files in the system should not be included in\n  the target system. In order to be included, a file must match some filter in\n  `incl_sys_filters` but not any filter in `excl_sys_filters`. This parameter\n  defaults to `[]`.\n\n- **`incl_app_filters`** - This parameter normally contains a list of regular\n  expressions that controls which application specific files that should be\n  included. Each file in the application must match at least one of the listed\n  regular expressions in order to be included. Further the files may not match\n  any filter in `excl_app_filters` in order to be included. This parameter\n  defaults to `[\".*\"]`.\n\n- **`excl_app_filters`** - This parameter normally contains a list of regular\n  expressions that controls which application specific files should not be\n  included in the target system. In order to be included, a file must match some\n  filter in `incl_app_filters` but not any filter in `excl_app_filters`. This\n  parameter defaults to `[]`.\n\nOn application (`escript`) level, the following options are supported:\n\n- **`incl_cond`** - The value of this parameter overrides the parameter with the\n  same name on system level.\n\nOn application (`app`) level, the following options are supported:\n\n- **`vsn`** - The version of the application. In an installed system there may\n  exist several versions of an application. The `vsn` parameter controls which\n  version of the application will be chosen.\n\n  This parameter is mutual exclusive with `lib_dir`. If `vsn` and `lib_dir` are\n  both omitted, the latest version will be chosen.\n\n  Note that in order for reltool to sort application versions and thereby be\n  able to select the latest, it is required that the version id for the\n  application consists of integers and dots only, for example `1`, `2.0` or\n  `3.17.1`.\n\n- **`lib_dir`** - The directory to read the application from. This parameter can\n  be used to point out a specific location to fetch the application from. This\n  is useful for instance if the parent directory for some reason is no good as a\n  library directory on system level.\n\n  This parameter is mutual exclusive with `vsn`. If `vsn` and `lib_dir` are both\n  omitted, the latest version will be chosen.\n\n  Note that in order for reltool to sort application versions and thereby be\n  able to select the latest, it is required that the version id for the\n  application consists of integers and dots only, for example `1`, `2.0` or\n  `3.17.1`.\n\n- **`mod`** - Module specific configuration. A module has a mandatory name and\n  module level options that are described below.\n\n- **`mod_cond`** - The value of this parameter overrides the parameter with the\n  same name on system level.\n\n- **`incl_cond`** - The value of this parameter overrides the parameter with the\n  same name on system level.\n\n- **`app_file`** - The value of this parameter overrides the parameter with the\n  same name on system level.\n\n- **`debug_info`** - The value of this parameter overrides the parameter with\n  the same name on system level.\n\n- **`incl_app_filters`** - The value of this parameter overrides the parameter\n  with the same name on system level.\n\n- **`excl_app_filters`** - The value of this parameter overrides the parameter\n  with the same name on system level.\n\nOn module (`mod`) level, the following options are supported:\n\n- **`incl_cond`** - This parameter controls whether the module is included or\n  not. By default the `mod_cond` parameter on application and system level will\n  be used to control whether the module is included or not. The value of\n  `incl_cond` overrides the module inclusion policy. `include` implies that the\n  module is included, while `exclude` implies that the module is not included.\n  `derived` implies that the module is included if it is used by any other\n  included module.\n\n- **`debug_info`** - The value of this parameter overrides the parameter with\n  the same name on application level.","ref":"reltool.html"},{"type":"function","title":"reltool.create_target/2","doc":"Create a target system.\n\nGives the same result as `{ok,TargetSpec}=reltool:get_target_spec(Server)` and\n`reltool:eval_target_spec(TargetSpec,RootDir,TargetDir)`.","ref":"reltool.html#create_target/2"},{"type":"function","title":"reltool.eval_target_spec/3","doc":"Create the actual target system from a specification generated by\n`reltool:get_target_spec/1`.\n\nThe creation of the specification for a target system is performed in two steps.\nIn the first step a complete specification will be generated. It will likely contain\nmuch more files than you are interested in your target system. In the second\nstep the specification will be filtered according to your filters. There you have the\nability to specify filters per application as well as system wide filters. You can\nalso select a `profile` for your system. Depending on the `profile`, different\ndefault filters will be used.\n\nThe top directories `bin`, `releases` and `lib` are treated differently from\nother files. All other files are by default copied to the target system. The\n`releases` directory contains generated `rel`, `script`, and `boot` files. The\n`lib` directory contains the applications. Which applications are included and\nif they should be customized (stripped from debug info etc.) is specified with\nvarious configuration parameters. The files in the `bin` directory are copied\nfrom the `erts-vsn/bin` directory, but only those files that were originally\nincluded in the `bin` directory of the source system.\n\nIf the configuration parameter `relocatable` was set to `true` there is no need\nto install the target system with `reltool:install/2` before it can be started.\nIn that case the file tree containing the target system can be moved without\nre-installation.\n\nIn most cases, the `RootDir` parameter should be set to the same as the\n`root_dir` configuration parameter used in the call to\n`reltool:get_target_spec/1` (or `code:root_dir/0` if the configuration parameter\nis not set). In some cases it might be useful to evaluate the same target\nspecification towards different root directories. This should, however, be used\nwith great care as it requires equivalent file structures under all roots.","ref":"reltool.html#eval_target_spec/3"},{"type":"function","title":"reltool.get_config/1","doc":"","ref":"reltool.html#get_config/1"},{"type":"function","title":"reltool.get_config/3","doc":"Get reltool configuration.\n\nNormally, only the explicit configuration parameters with values that differ from\ntheir defaults are interesting. But the builtin default values can be returned by\nsetting `InclDefaults` to `true`. The derived configuration can be returned by\nsetting `InclDerived` to `true`.","ref":"reltool.html#get_config/3"},{"type":"function","title":"reltool.get_rel/2","doc":"Get contents of a release file. See [`rel`](`e:sasl:rel.md`) for more details.","ref":"reltool.html#get_rel/2"},{"type":"function","title":"reltool.get_script/2","doc":"Get contents of a boot script file. See [`script`](`e:sasl:script.md`) for more details.","ref":"reltool.html#get_script/2"},{"type":"function","title":"reltool.get_server/1","doc":"Return the process identifier of the server process.","ref":"reltool.html#get_server/1"},{"type":"function","title":"reltool.get_status/1","doc":"Get status about the configuration","ref":"reltool.html#get_status/1"},{"type":"function","title":"reltool.get_target_spec/1","doc":"Return a specification of the target system. The actual target system can be\ncreated with `reltool:eval_target_spec/3`.","ref":"reltool.html#get_target_spec/1"},{"type":"function","title":"reltool.install/2","doc":"Install a created target system","ref":"reltool.html#install/2"},{"type":"function","title":"reltool.start/0","doc":"Start a main window process with default options","ref":"reltool.html#start/0"},{"type":"function","title":"reltool.start/1","doc":"Start a main window process with options","ref":"reltool.html#start/1"},{"type":"function","title":"reltool.start_link/1","doc":"Start a main window process with options. The process is linked.","ref":"reltool.html#start_link/1"},{"type":"function","title":"reltool.start_server/1","doc":"Start a server process with options. The server process identity can be given as\nan argument to several other functions in the API.","ref":"reltool.html#start_server/1"},{"type":"function","title":"reltool.stop/1","doc":"Stop a server or window process","ref":"reltool.html#stop/1"},{"type":"type","title":"reltool.app/0","doc":"","ref":"reltool.html#t:app/0"},{"type":"type","title":"reltool.app_file/0","doc":"","ref":"reltool.html#t:app_file/0"},{"type":"type","title":"reltool.app_name/0","doc":"","ref":"reltool.html#t:app_name/0"},{"type":"type","title":"reltool.app_type/0","doc":"","ref":"reltool.html#t:app_type/0"},{"type":"type","title":"reltool.app_vsn/0","doc":"","ref":"reltool.html#t:app_vsn/0"},{"type":"type","title":"reltool.base_dir/0","doc":"","ref":"reltool.html#t:base_dir/0"},{"type":"type","title":"reltool.base_file/0","doc":"","ref":"reltool.html#t:base_file/0"},{"type":"type","title":"reltool.boot_rel/0","doc":"","ref":"reltool.html#t:boot_rel/0"},{"type":"type","title":"reltool.config/0","doc":"","ref":"reltool.html#t:config/0"},{"type":"type","title":"reltool.debug_info/0","doc":"","ref":"reltool.html#t:debug_info/0"},{"type":"type","title":"reltool.dir/0","doc":"","ref":"reltool.html#t:dir/0"},{"type":"type","title":"reltool.escript/0","doc":"","ref":"reltool.html#t:escript/0"},{"type":"type","title":"reltool.escript_file/0","doc":"","ref":"reltool.html#t:escript_file/0"},{"type":"type","title":"reltool.excl_app_filters/0","doc":"","ref":"reltool.html#t:excl_app_filters/0"},{"type":"type","title":"reltool.excl_lib/0","doc":"","ref":"reltool.html#t:excl_lib/0"},{"type":"type","title":"reltool.excl_sys_filters/0","doc":"","ref":"reltool.html#t:excl_sys_filters/0"},{"type":"type","title":"reltool.file/0","doc":"","ref":"reltool.html#t:file/0"},{"type":"type","title":"reltool.incl_app/0","doc":"","ref":"reltool.html#t:incl_app/0"},{"type":"type","title":"reltool.incl_app_filters/0","doc":"","ref":"reltool.html#t:incl_app_filters/0"},{"type":"type","title":"reltool.incl_cond/0","doc":"","ref":"reltool.html#t:incl_cond/0"},{"type":"type","title":"reltool.incl_defaults/0","doc":"","ref":"reltool.html#t:incl_defaults/0"},{"type":"type","title":"reltool.incl_derived/0","doc":"","ref":"reltool.html#t:incl_derived/0"},{"type":"type","title":"reltool.incl_sys_filters/0","doc":"","ref":"reltool.html#t:incl_sys_filters/0"},{"type":"type","title":"reltool.lib_dir/0","doc":"","ref":"reltool.html#t:lib_dir/0"},{"type":"type","title":"reltool.mod/0","doc":"","ref":"reltool.html#t:mod/0"},{"type":"type","title":"reltool.mod_cond/0","doc":"","ref":"reltool.html#t:mod_cond/0"},{"type":"type","title":"reltool.mod_name/0","doc":"","ref":"reltool.html#t:mod_name/0"},{"type":"type","title":"reltool.option/0","doc":"","ref":"reltool.html#t:option/0"},{"type":"type","title":"reltool.options/0","doc":"","ref":"reltool.html#t:options/0"},{"type":"type","title":"reltool.profile/0","doc":"","ref":"reltool.html#t:profile/0"},{"type":"type","title":"reltool.re_regexp/0","doc":"","ref":"reltool.html#t:re_regexp/0"},{"type":"type","title":"reltool.reason/0","doc":"","ref":"reltool.html#t:reason/0"},{"type":"type","title":"reltool.regexps/0","doc":"","ref":"reltool.html#t:regexps/0"},{"type":"type","title":"reltool.rel_app/0","doc":"","ref":"reltool.html#t:rel_app/0"},{"type":"type","title":"reltool.rel_file/0","doc":"","ref":"reltool.html#t:rel_file/0"},{"type":"type","title":"reltool.rel_name/0","doc":"","ref":"reltool.html#t:rel_name/0"},{"type":"type","title":"reltool.rel_opt/0","doc":"","ref":"reltool.html#t:rel_opt/0"},{"type":"type","title":"reltool.rel_vsn/0","doc":"","ref":"reltool.html#t:rel_vsn/0"},{"type":"type","title":"reltool.relocatable/0","doc":"","ref":"reltool.html#t:relocatable/0"},{"type":"type","title":"reltool.root_dir/0","doc":"","ref":"reltool.html#t:root_dir/0"},{"type":"type","title":"reltool.script_file/0","doc":"","ref":"reltool.html#t:script_file/0"},{"type":"type","title":"reltool.server/0","doc":"","ref":"reltool.html#t:server/0"},{"type":"type","title":"reltool.server_pid/0","doc":"","ref":"reltool.html#t:server_pid/0"},{"type":"type","title":"reltool.sys/0","doc":"","ref":"reltool.html#t:sys/0"},{"type":"type","title":"reltool.target_dir/0","doc":"","ref":"reltool.html#t:target_dir/0"},{"type":"type","title":"reltool.target_spec/0","doc":"","ref":"reltool.html#t:target_spec/0"},{"type":"type","title":"reltool.top_dir/0","doc":"","ref":"reltool.html#t:top_dir/0"},{"type":"type","title":"reltool.top_file/0","doc":"","ref":"reltool.html#t:top_file/0"},{"type":"type","title":"reltool.warning/0","doc":"","ref":"reltool.html#t:warning/0"},{"type":"type","title":"reltool.window_pid/0","doc":"","ref":"reltool.html#t:window_pid/0"},{"type":"extras","title":"Reltool Release Notes","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Reltool Release Notes\n\nThis document describes the changes made to the Reltool system from version to\nversion. The intention of this document is to list all incompatibilities as well\nas all enhancements and bugfixes for every release of Reltool. Each release of\nReltool thus constitutes one section in this document. The title of each section\nis the version number of Reltool.","ref":"notes.html"},{"type":"extras","title":"Reltool 1.0.1 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-1-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- The dependencies for this application are now listed in the app file.\n\n  Own Id: OTP-18831 Aux Id: [PR-7441]\n\n[PR-7441]: https://github.com/erlang/otp/pull/7441","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 1.0 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-1-0"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- Add possibility to strip specific chunks from beam files included in a\n  release. Before this change it was only possible to strip all chunks from the\n  beam files.\n\n  Own Id: OTP-18230 Aux Id: PR-5936\n\n- Runtime dependencies have been updated.\n\n  Own Id: OTP-18350\n\n- Support for the experimental code archives feature has been removed from\n  `reltool`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18488 Aux Id: PR-6836\n\n- The implementation has been fixed to use `proc_lib:init_fail/2,3` where\n  appropriate, instead of `proc_lib:init_ack/1,2`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-18490 Aux Id: OTP-18471, GH-6339, PR-6843","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.9.1.1 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-9-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"* Fixed runtime dependencies.\n\n  Own Id: OTP-19064","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Reltool 0.9.1 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-9-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- Fixed a bug that would cause analysis to crash.\n\n  Own Id: OTP-18372 Aux Id: GH-6580","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Reltool 0.9 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-9"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- Recognize new key 'optional_applications' in application resource files.\n\n  Own Id: OTP-17189 Aux Id: PR-2675\n\n- Removed timestamps from files generated by `sasl` and `reltool` to enable\n  deterministic builds.\n\n  Own Id: OTP-17292 Aux Id: PR-4685, PR-4684","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.8 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-8"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- A new element, `Opts`, can now be included in a `rel` tuple in the reltool\n  release specific configuration format: \\{rel, Name, Vsn, RelApps, Opts\\}.\n\n  This supports the use of\n  `{rel, Name, Vsn, RelApps, [{load_dot_erlang, false}]}` to prevent the boot\n  script from running the `.erlang` file.\n\n  The incompatibilities are as follows:\n\n  \\* The return from `reltool:get_config/1` and `reltool:get_config/3` includes\n  the new `rel` tuple for all releases where the `load_dot_erlang` option is set\n  to `false`.  \n  \\* The return from `reltool:get_config/3` includes the new `rel` tuple for ALL\n  releases if the `InclDefs` parameter is set to `true`.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-15571","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.7.8 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-7-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- Reltool would earlier erroneously split paths like `\"c:\\foo\"` into\n  `[\"c\",\"\\foo\"]` when reading the `$ERL_LIBS` variable on windows. This is now\n  corrected.\n\n  Own Id: OTP-15454","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Reltool 0.7.7 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-7-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- Improved documentation.\n\n  Own Id: OTP-15190","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Reltool 0.7.6 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-7-6"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- Calls to `erlang:get_stacktrace()` are removed.\n\n  Own Id: OTP-14861","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.7.5 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-7-5"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- Files generated by `release_handler` and `reltool`, which might contain\n  Unicode characters, are now encoded as UTF-8 and written with format \"~tp\" or\n  \"~ts\". If the file is to be read by `file:consult/1`, an encoding comment is\n  added.\n\n  Own Id: OTP-14463","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.7.4 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-7-4"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- The User's Guide examples are updated after removal of support for Dets files\n  created with Erlang/OTP R7 and earlier.\n\n  Own Id: OTP-14422 Aux Id: OTP-13830","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.7.3 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-7-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- Fixed xml issues in old release notes\n\n  Own Id: OTP-14269","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Reltool 0.7.2 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-7-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- Dependencies specified in .app files would earlier only be followed for\n  applications that are included in a 'rel' spec in the reltool config. For\n  other applications, only xref would decide the dependencies.\n\n  Some dependency chains would even be missed for applications that are included\n  in a 'rel' spec in the reltool config. E.g.\n\n  - Application x has y as included application, and y in turn has z as included\n    application. Then z is not included.\n  - Application x has y in its 'applications' tag in the .app file, and y in\n    turn has z as included application. Then z is not included.\n\n  These bugs are now corrected.\n\n  Own Id: OTP-11993","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Reltool 0.7.1 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-7-1"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- Modify the code as motivated by a change of the Erlang Parser (`undefined` is\n  no longer automatically inserted to the type of record fields without an\n  initializer).\n\n  Own Id: OTP-13033 Aux Id: OTP-12719","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.7 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-7"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- Change license text from Erlang Public License to Apache Public License v2\n\n  Own Id: OTP-12845","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.6.6 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-6-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- Fixed a minor typo in an error message from reltool_server.\n\n  Own Id: OTP-11977","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Reltool 0.6.5 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-6-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- When adding a regexp to a filter in reltool using \\{add,Regexp\\}, and the\n  existing regexp was undefined, reltool would crash since it got an improper\n  list. This has been corrected. (Thanks to Håkan Mattsson)\n\n  Own Id: OTP-11591\n\n- Adapted reltool test server to common test usage of tc_status. (Note that this\n  code is not used by OTP daily test runs.) (Thanks to Håkan Mattsson)\n\n  Own Id: OTP-11592\n\n- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Reltool 0.6.4.1 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-6-4-1"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- The encoding of the `notes.xml` file has been changed from latin1 to utf-8 to\n  avoid future merge problems.\n\n  Own Id: OTP-11310","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.6.4 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-6-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- Fix receive support in erl_eval with a BEAM module. Thanks to Anthony Ramine.\n\n  Own Id: OTP-11137","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- Reltool used to fail if an application was mentioned in the config file which\n  was not found in the file system, even if the application was explicitly\n  excluded in the config. This has been changed and will only produce a warning.\n  If the application is not explicitly excluded it will still cause reltool to\n  fail. Thanks to Håkan Mattsson\\!\n\n  Own Id: OTP-10988\n\n- Fix possibly \"not owner\" error while file copy with reltool. Thanks to Alexey\n  Saltanov.\n\n  Own Id: OTP-11099","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.6.3 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-6-3"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- Some updates are made to reltool for handling unicode.\n\n  Own Id: OTP-10781","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.6.2 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-6-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- - If `incl_cond` was set to `derived` on module level, then reltool_server\n    would crash with a `case_clause`. This has been corrected. `incl_cond` on\n    module level now overwrites `mod_cond` on app or sys level as described in\n    the documentation.\n  - If a `rel` spec in the reltool config does not contain all applications that\n    are listed as `{applications,Applications}` in a `.app` file, then these\n    applications are automatically added when creating the `.rel` file. For\n    'included_applications', the behaviour was not the same. I.e. if a `rel`\n    spec in the reltool config did not contain all applications that are listed\n    as `{included_applications,InclApplications}` in a `.app` file, then reltool\n    would fail with reason \"Undefined applications\" when creating the `.rel`\n    file. This has been corrected, so both `applications` and\n    `included_applications` are now automatically added if not already in the\n    `rel` spec.\n  - The `rel` specification now dictates the order in which included and used\n    applications (specified in the `.app` file as `included_applications` and\n    `applications` respectively) are loaded/started by the boot file. If the\n    applications are not specified in the `rel` spec, then the order from the\n    `.app` file is used. This was a bug earlier reported on systools, and is now\n    also implemented in reltool.\n  - Instead of only looking at the directory name, reltool now first looks for a\n    `.app` file in order to figure out the name of an application.\n\n  Own Id: OTP-10012 Aux Id: kunagi-171 \\[82]","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- Some examples overflowing the width of PDF pages have been corrected.\n\n  Own Id: OTP-10665","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.6.1 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-6-1"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- A new sys level configuration parameter `{excl_lib,otp_root}` is added. When\n  this is set, the target system will not contain anything from `$OTPROOT`. It\n  will only contain a releases directory with rel, script and boot files, and a\n  lib directory with applications found outside of `$OTPROOT` (i.e. \"your own\"\n  applications).\n\n  Own Id: OTP-9743","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.6 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- Miscellaneous corrections:\n\n  - Start of reltool GUI would sometimes crash with a badmatch in\n    reltool_sys_win:do_init. This has been corrected.\n  - Minor corrections of documentation and type specifications of app() and\n    mod() are done.\n  - If a module name is duplicated in an app file reltool would return an error.\n    This is now changed to a warning.\n  - Reltool would earlier not necessarily keep the order of applications as\n    listed in the rel specification in the configuration. This has been\n    corrected.\n  - Reltool would earlier set the default for included applications to an empty\n    list if it was not set in the rel specification in the configuration. This\n    was correct according to sasl/systools documentation, but not according to\n    sasl/systools implementation. We decided to change the documentation and\n    reltool to use the value of included_applications from the .app file as\n    default instead of the empty list, since this seems more intuitive and since\n    systools always has done the same.\n  - The value of included applications in the rel specification in the\n    configuration did not overwrite included_applications in the .app file if it\n    was set to an empty list. This has been corrected.\n  - Reltool would earlier add load instructions in the script/boot files for ALL\n    modules in the ebin directory of an application even if mod_cond was set to\n    app (include only modules listed in the .app file). This has been corrected.\n  - Reltool would earlier add start instructions in the script/boot file for\n    included applications. This has been corrected - included applications shall\n    only be loaded since the including application is responsible for starting\n    them.\n  - Status bar now indicates that reltool is working (Processing libraries...)\n    for all configuration changes, and when generating target system.\n  - Title of dependencies column in app and mod window is changed from \"Modules\n    used by others\" to \"Modules using this\".\n\n  Own Id: OTP-9792\n\n- Configuration changes via the GUI had a few bugs related to error handling,\n  rollback and undo. A major re-write of the reltool_server has been done in\n  order to align the way reltool_server updates and uses its state and tables\n  for all different kinds of configuration change.\n\n  All configuration changes (except undo) now cause a re-read of the file\n  system, meaning that if something has changed in the file system it will be\n  reflected in the result of the configuration change.\n\n  When loading a new configuration file via the GUI, the old configuration is\n  now completely scratched, and only the new is valid.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-9794\n\n- Some bug fixes related to the handling of escripts:\n\n  - Reltool could not handle escripts with inlined applications. This has been\n    corrected. Inlined applications will be visible in the GUI, but not possible\n    to include/exclude separately.\n  - Loading a config which contains an escript via the GUI menu did not produce\n    the same result as when using the same configuration at reltool start.\n    Paths, version and label could differ. This has been corrected.\n  - Loading config with same escript (source) twice caused reltool to add same\n    module twice. This has been corrected.\n  - Loading config with same escript (inlined beam) twice caused reltool to fail\n    saying module is included by two different applications. This has been\n    corrected.\n  - Loading config which in addition to an existing escript also adds another\n    escript, for which the name sorts before the existing one, would cause\n    reltool to fail saying \"Application name clash\". This has been corrected.\n\n  Own Id: OTP-9968\n\n- Reltool would sometimes generate a .app file containing\n  `{start_phases,undefined}`, which would cause an exception in systools at\n  parse time. This has been corrected so reltool now omits the `start_phases`\n  entry if the value is `undefined`. (Thanks to Juan Jose Comellas)\n\n  In order to align with reltool, sasl will also omit `start_phases` entries\n  with value `undefined` in .script files.\n\n  Own Id: OTP-10003","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- A warning list is added to the sys window of the reltool GUI. This list will\n  continuously show all warnings produced by the current configuration.\n\n  Own Id: OTP-9967\n\n- As a way of specifying one specific version of an application, the following\n  configuration parameter is added on application level:\n\n  \\{lib_dir,Dir\\}, Dir = string()\n\n  This can be useful if the parent directory of the application directory is not\n  suitable to use as a lib dir on system level.\n\n  Own Id: OTP-9977","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.5.7.1 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-5-7-1"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- Added recommendation about `RootDir` parameter to\n  `reltool:eval_target_spec/3`.\n\n  Own Id: OTP-9742","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.5.7 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-5-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- If a module was duplicated in the library directories visible to reltool, and\n  the configuration did not point out which file to use, then reltool:start\n  would always fail. A pop-up is added which asks if you want to continue with a\n  safe and minimal configuration.\n\n  Own Id: OTP-9383\n\n- wx would sometimes crash due to an empty radiobox on the 'releases' tab of the\n  system window. This radiobox is removed, and replaced by a listbox which will\n  always contain at least kernel and stdlib applications.\n\n  Own Id: OTP-9384","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Reltool 0.5.6 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-5-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- The system level option `app_files` is documented to allow the values\n  `keep | strip | all`, but it only allowed `keep`. This is corrected.\n\n  Own Id: OTP-9135\n\n- Allow the same module name in multiple applications visible to reltool, as\n  long as all but one of the applications/modules are explicitly excluded.\n  (Thanks to Andrew Gopienko and Jay Nelson)\n\n  Own Id: OTP-9229","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Reltool 0.5.5 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-5-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- The reltool module contained two seriously erroneous specs which caused bogus\n  warnings when dialyzing reltool and some correct code of users. These were\n  fixed (specs for start_link/1 and eval_server/3)\n\n  \\- Code cleanups and simplifications - Fix a bug in the calculation of\n  circular dependencies - Eliminate two dialyzer warnings - Put files\n  alphabetically\n\n  Own Id: OTP-9120","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Reltool 0.5.4 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-5-4"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- Added function `zip:foldl/3` to iterate over zip archives.\n\n  Added functions to create and extract escripts. See `escript:create/2` and\n  `escript:extract/2`.\n\n  The undocumented function `escript:foldl/3` has been removed. The same\n  functionality can be achieved with the more flexible functions\n  `escript:extract/2` and `zip:foldl/3`.\n\n  Record fields has been annotated with type info. Source files as been adapted\n  to fit within 80 chars and trailing whitespace has been removed.\n\n  Own Id: OTP-8521\n\n- A new escript, called `reltool`, has been introduced in order to simplify the\n  usage of the reltool application from makefiles.\n\n  The handling of applications included in releases has been improved.\n  Applications that are required to be started before other applications in a\n  release are now automatically included in the release. The Kernel and STDLIB\n  applications are always included as they are mandatory.\n\n  Applications that are (explicitly or implicitly) included in a release are now\n  automatically included as if they were explicitly included with the incl_cond\n  flag.\n\n  A new `embedded_app_type` option has been introduced. It is intended to be\n  used for embedded systems where all included applications must be loaded from\n  the boot script, as these systems does not utilize dynamic code loading. If\n  `embedded_app_type `is set to something else than `undefined`, all included\n  applications will be included in both the release as well as in the boot\n  script. If the `profile` is `embedded` the `embedded_app_type` option defaults\n  to `load`.\n\n  A new function called `reltool:get_status/1` has been introduced. It returns\n  status about the configuration in the server.\n\n  The API functions that may take `PidOrOptions` as input and actually gets\n  `Options` does now print out warnings.\n\n  The internal error handling has been improved. For example `{error,Reason}` is\n  always returned in case of errors even when the server dies.\n\n  `app` and `appup` files has been added as well as a corresponding test suite.\n\n  Various cleanups has been made in the code and in the documentation.\n\n  Own Id: OTP-8590","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.5.3 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-5-3"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- Removed spurious documentation files.\n\n  Own Id: OTP-8057","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.5.2 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-5-2"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the HTML frames are\n  removed.\n\n  Own Id: OTP-8254","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.5.1 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- In the new release of Reltool (0.5) there is a severe bug that may cause your\n  source files to be deleted. The bug is triggered when you generate a target\n  system WITH archive files AND your library directories are given with absolute\n  paths. (Library directories are given with the ERL_LIBS environment variable\n  or with the lib_dirs configuration parameter.)\n\n  Own Id: OTP-8199","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Reltool 0.5 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-5"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- The tool is still experimental. Feedback is appreciated.\n\n  Major improvements of the target system generation has been performed. Now it\n  is possible to generate a relocatable target system that does not need to be\n  re-installed if it is moved to a new location. Archive files are automatically\n  generated. A detailed specification of the target system can be generated\n  without actually creating the target system. Relocatable escripts are put in\n  the bin directory of the target system. etc. etc.\n\n  Some new functions has been introduced in the `reltool` module:\n  `start/1, start_link/1, get_config/3, get_target_spec/1 and eval_target_spec/3`.\n\n  Some new configuration parameters has been introduced:\n  `profile, incl_sys_filters, excl_sys_filters, incl_app_filters, excl_app_filters, incl_archive_filters, excl_archive_filters, archive_opts, escript and relocatable`.\n\n  Some parameters have been obsoleted and given new semantics:\n  `incl_erts_dirs (incl_sys_filters), excl_erts_dirs (excl_sys_filters), incl_app_dirs (incl_app_filters), excl_app_dirs (excl_app_filters) and escripts (escript).`\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-7949","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Known Bugs and Problems - Reltool Release Notes","doc":"- The application is experimental. Feedback is appreciated.","ref":"notes.html#known-bugs-and-problems"},{"type":"extras","title":"Reltool 0.2.2 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Reltool Release Notes","doc":"- The tool crashed when rel, script and boot files were generated via the GUI.\n  This has been fixed.\n\n  Own Id: OTP-7999","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Reltool 0.2.1 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-2-1"},{"type":"extras","title":"Improvements and New Features - Reltool Release Notes","doc":"- Minor GUI fixes\n\n  Own Id: OTP-7840","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Reltool 0.2 - Reltool Release Notes","doc":"","ref":"notes.html#reltool-0-2"},{"type":"extras","title":"Improvements and new features - Reltool Release Notes","doc":"This is the first (experimental) release of Reltool.","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Known Bugs and Problems - Reltool Release Notes","doc":"- The application is experimental.","ref":"notes.html#known-bugs-and-problems"},{"type":"extras","title":"Introduction","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Introduction\n\nReltool is a release management tool. It analyses a given Erlang/OTP\ninstallation and determines various dependencies between applications. The\n`graphical` frontend depicts the dependencies and enables interactive\ncustomization of a target system. The backend provides a `batch` interface for\ngeneration of customized target systems.","ref":"reltool_intro.html"},{"type":"extras","title":"Scope and Purpose - Introduction","doc":"This manual describes the Reltool application, as a component of the Erlang/Open\nTelecom Platform development environment. It is assumed that the reader is\nfamiliar with the Erlang Development Environment, which is described in a\nseparate User's Guide.","ref":"reltool_intro.html#scope-and-purpose"},{"type":"extras","title":"Prerequisites - Introduction","doc":"The following prerequisites are required for understanding the material in the\nReltool User's Guide:\n\n- familiarity with Erlang/OTP system principles and Erlang/OTP design principles\n\nThe application requires Erlang/OTP release R13B02 or later.","ref":"reltool_intro.html#prerequisites"},{"type":"extras","title":"About This Manual - Introduction","doc":"In addition to this introductory chapter, the Reltool User's Guide contains the\nfollowing chapters:\n\n- Chapter 2: [\"Usage\"](reltool_usage.md) describes the architecture and typical usage of the\n  application.\n- Chapter 3: [\"Examples\"](reltool_examples.md) gives some usage examples","ref":"reltool_intro.html#about-this-manual"},{"type":"extras","title":"Where to Find More Information - Introduction","doc":"Refer to the following documentation for more information about Reltool and\nabout the Erlang/OTP development system:\n\n- the [Reference Manual of Reltool](`m:reltool`)\n- the Erlang/OTP [`System Principles`](`e:system:system_principles.md`)\n- the Erlang/OTP [`Design Principles`](`e:system:design_principles.md`)\n- Programming Erlang: Software for a Concurrent World (2007), Pragmatic\n  Bookshelf, ISBN13: 9781934356005.","ref":"reltool_intro.html#where-to-find-more-information"},{"type":"extras","title":"Usage","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Usage","ref":"reltool_usage.html"},{"type":"extras","title":"Overview - Usage","doc":"This document focuses on the graphical parts of the tool. The concepts are\nexplained in the reference manual for the module `reltool`.","ref":"reltool_usage.html#overview"},{"type":"extras","title":"System window - Usage","doc":"The system window is started with the function `reltool:start/1`. At startup the\ntool will process all `beam` files and `app` files in order to find out\ndependencies between applications and their modules. Once all this information\nhas been derived, it will be possible to explore the tool.\n\nThe system window consists of four main pages (tabs):\n\n- Libraries\n- System settings\n- Applications\n- Releases\n\nClick on a name tag to display its page.","ref":"reltool_usage.html#system-window"},{"type":"extras","title":"Libraries - Usage","doc":"On the library page it is possible to control which sources the tool will use.\nThe page is organized as a tree which can be expanded and collapsed by clicking\non the little symbol in the beginning of the expandable/collapsible lines.\n\nThe `Root directory` can be edited by selecting the line where the path of the\nroot directory is displayed and clicking the right mouse button. Choose edit in\nthe menu that pops up.\n\nLibrary directories can be added, edited or deleted. This is done by selecting\nthe line where the path to a library directory is displayed and clicking the\nright mouse button. Choose add, edit or delete in the menu that pops up. New\nlibrary directories can also be added by selecting the line\n`Library directories` and clicking the right mouse button. Choose add in the\nmenu that pops up.\n\nEscript files can be added, edited or deleted. This is done by selecting the\nline where the path to an escript file is displayed and clicking the right mouse\nbutton. Choose add, edit or delete in the menu that pops up. New escripts can\nalso be added by selecting the line `Escript files` and clicking the right mouse\nbutton. Choose add in the menu that pops up.\n\nWhen libraries and escripts are expanded, the names of their contained\napplications will be displayed. Double click on an application name to launch an\napplication window.","ref":"reltool_usage.html#libraries"},{"type":"extras","title":"System settings - Usage","doc":"On the system settings page it is possible to control some global settings that\nare used as defaults for all applications. Set the\n`Application inclusion policy` to `include` to include all applications that are\nnot explicitly excluded. See `incl_cond` (application inclusion) and `mod_cond`\n(module inclusion) in the reference manual for the module `reltool` for more\ninfo.\n\nThe system settings page is rather incomplete.","ref":"reltool_usage.html#system-settings"},{"type":"extras","title":"Applications - Usage","doc":"There are four categories of applications on the applications page. `Included`\ncontains applications that are explicitly included. `Excluded` contains\napplications that are explicitly excluded. `Derived` contains applications that\neither are used directly by explicitly included applications or by other derived\napplications. `Available` contains the remaining applications.\n\nSelect one or more applications and click on a button directly below the\napplication column to change application category. For example, select an\navailable application and click on its tick button to move the application to\nthe included category. Clicking on the tick symbol for included applications\nwill move the application back to the available category. The tick is undone.\n\nThe symbols in front of the application names are intended to describe the\nstatus of the application. There are error and warning symbols to signalize that\nthere is something which needs attention. The tick symbol means that the\napplication is included or derived and no problem has been detected. The cross\nsymbol means that the application is excluded or available and no problem has\nbeen detected. Applications with error symbols are listed first in each category\nand are followed by the warnings and the normal ones (ticks and crosses) at the\nend.\n\nDouble click on an application to launch its application window.","ref":"reltool_usage.html#applications"},{"type":"extras","title":"Releases - Usage","doc":"The releases page is incomplete and very experimental.","ref":"reltool_usage.html#releases"},{"type":"extras","title":"File menu - Usage","doc":"- `Display application dependency graph` \\- Launches an application force graph\n  window. All included and derived applications and their dependencies will be\n  shown in a graph.\n- `Display module dependency graph` \\- Launch a module force graph window. All\n  included and derived modules and their dependencies will be shown in a graph.\n- `Reset configuration to default`\n- `Undo configuration (toggle)`\n- `Load configuration` \\- Loads a new configuration from file.\n- `Save configuration` \\- Saves the current configuration to file. Normally,\n  only the explicit configuration parameters with values that differ from their\n  defaults are saved. But the configuration with or without default values and\n  with or without derived values may also be saved.\n- `Generate rel, script and boot files`\n- `Generate target system`\n- `Close` \\- Close the system window and all its subwindows.","ref":"reltool_usage.html#file-menu"},{"type":"extras","title":"Dependencies between applications or modules displayed as a graph - Usage","doc":"The dependency graph windows are launched from the file menu in the system\nwindow. The graph depicts all included and derived applications/modules and\ntheir dependencies.\n\nIt is possible to perform some limited manipulations of the graph. Nodes can be\nmoved, selected, locked or deleted. Move a single node or the entire graph by\nmoving the mouse while the left mouse button is pressed. A node can be locked\ninto a fix position by holding down the shift button when the left mouse button\nis released. Select several nodes by moving the mouse while the control key and\nthe left mouse button are pressed. Selected nodes can be locked, unlocked or\ndeleted by clicking on a suitable button.\n\nThe algorithm that is used to draw a graph with as few crossed links as possible\nis called force graph. A force graph consists of nodes and directed links\nbetween nodes. Each node is associated with a repulsive force that pushes nodes\naway from each other. This force can be adjusted with the left slider or with\nthe mouse wheel. Each link is associated with an attractive force that pulls the\nnodes nearer to each other. This force can be adjusted with the right slider. If\nthis force becomes too strong, the graph will be unstable. The third parameter\nthat can be adjusted is the length of the links. It is adjusted with the middle\nslider.\n\nThe `Freeze` button starts/stops the redrawing of the graph. `Reset` moves the\ngraph to the middle of the window and resets all graph settings to default, with\nthe exception of deleted nodes.","ref":"reltool_usage.html#dependencies-between-applications-or-modules-displayed-as-a-graph"},{"type":"extras","title":"Application window - Usage","doc":"The application window is started by double clicking on an application name. The\napplication window consists of four pages (tabs):\n\n- Application settings\n- Modules\n- Application dependencies\n- Module dependencies\n\nClick on a name tag to display its page.","ref":"reltool_usage.html#application-window"},{"type":"extras","title":"Application settings - Usage","doc":"Select version of the application in the `Source selection policy` part of the\npage. By default the latest version of the application is selected, but it is\npossible to override this by explicitly selecting another version.\n\nNote that in order for reltool to sort application versions and thereby be able\nto select the latest, it is required that the version id for the application\nconsists of integers and dots only, for example `1`, `2.0` or `3.17.1`.\n\nBy default the `Application inclusion policy` on system level is used for all\napplications. Set the value to `include` if you want to explicitly include one\nparticular application. Set it to `exclude` if you want to exclude the\napplication despite that it is used by another (explicitly or implicitly)\nincluded application. `derived` means that the application automatically will be\nincluded if some other (explicitly or implicitly) included application uses it.\n\nBy default the `Module inclusion policy` on system level is used for all\napplications. Set it to `derived` if you only want actually used modules to be\nincluded. Set it to `app` if you, besides derived modules, also want the modules\nlisted in the app file to be included. Set it to `ebin` if you, besides derived\nmodules, also want the modules that exist as beam files in the ebin directory to\nbe included. Set it to `all` if you want all modules to be included, that is the\nunion of modules found in the ebin directory and listed in the app file.\n\nThe application settings page is rather incomplete.","ref":"reltool_usage.html#application-settings"},{"type":"extras","title":"Modules - Usage","doc":"There are four categories of modules on the modules page. `Included` contains\nmodules that are explicitly included. `Excluded` contains modules that are\nexplicitly excluded. `Derived` contains modules that either are used directly by\nexplicitly included modules or by other derived modules. `Available` contains\nthe remaining modules.\n\nSelect one or more modules and click on a button directly below the module\ncolumn to change module category. For example, select an available module and\nclick on its tick button to move the module to the included category. Clicking\non the tick symbol for included modules will move the module back to the\navailable category. The tick is undone.\n\nThe symbols in front of the module names are intended to describe the status of\nthe module. There are error and and warning symbols to signalize that there is\nsomething that needs attention. The tick symbol means that the module is\nincluded or derived and no problem has been detected. The cross symbol means\nthat the module is excluded or available and no problem has been detected.\nModules with error symbols are listed first in each category and are followed by\nwarnings and the normal ones (ticks and crosses) at the end.\n\nDouble click on a module to launch its module window.","ref":"reltool_usage.html#modules"},{"type":"extras","title":"Application dependencies - Usage","doc":"There are four categories of applications on the `Application dependencies`\npage. If the application is used by other applications, these are listed under\n`Used by`. If the application requires other applications be started before it\ncan be started, these are listed under `Required`. These applications are listed\nin the `applications` part of the `app` file. If the application includes other\napplications, these are listed under `Included`. These applications are listed\nin the `included_applications` part of the `app` file. If the application uses\nother applications, these are listed under `Uses`.\n\nDouble click on an application name to launch an application window.","ref":"reltool_usage.html#application-dependencies"},{"type":"extras","title":"Module dependencies - Usage","doc":"There are two categories of modules on the `Module dependencies` page. If the\nmodule is used by other modules, these are listed under `Modules using this`. If\nthe module uses other modules, these are listed under `Used modules`.\n\nDouble click on an module name to launch a module window.","ref":"reltool_usage.html#module-dependencies"},{"type":"extras","title":"Module window - Usage","doc":"The module window is started by double clicking on an module name. The module\nwindow consists initially of two pages (tabs):\n\n- Dependencies\n- Code\n\nClick on a name tag to display its page.","ref":"reltool_usage.html#module-window"},{"type":"extras","title":"Dependencies - Usage","doc":"There are two categories of modules on the `Dependencies` page. If the module is\nused by other modules, these are listed under `Modules using this`. If the\nmodule uses other modules, these are listed under `Used modules`.\n\nDouble click on an module name to launch a module window.","ref":"reltool_usage.html#dependencies"},{"type":"extras","title":"Code - Usage","doc":"On the `Code` page the Erlang source code is displayed. It is possible to search\nforwards and backwards for text in the module. Enter a regular expression in the\n`Find` field and press enter. It is also possible to go to a certain line in the\nmodule. The `Back` button can be used to go back to the previous position.\n\nPut the marker on a function name and double click to go to the definition of\nthe function. If the function is defined in another module, that module will be\nloaded and added to the page list.","ref":"reltool_usage.html#code"},{"type":"extras","title":"Examples","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Examples","ref":"reltool_examples.html"},{"type":"extras","title":"Start and stop windows and servers - Examples","doc":"The main process in Reltool is the server. It can be used as it is or be used\nvia the GUI frontend process. When the GUI is started, a server process will\nautomatically be started. The GUI process is started with `reltool:start/0`,\n`reltool:start/1` or `reltool:start_link/1`. The pid of its server can be\nobtained with [`reltool:get_server/1`](`reltool:start_link/1`)\n\n```erlang\nErlang/OTP 20 [erts-9.0] [source-c13b302] [64-bit] [smp:4:4] [ds:4:4:10] [async-threads:10]\n[hipe] [kernel-poll:false]\nEshell V9.0  (abort with ^G)\n1>\n1> {ok, Win} = reltool:start([]).\n{ok,<0.36.01>}\n2> {ok, Server} = reltool:get_server(Win).\n{ok,<0.37.01>}\n3> reltool:get_config(Server).\n{ok,{sys,[]}}\n4>\n4> {ok, Server2} = reltool:start_server([]).\n{ok,<0.6535.01>}\n5> reltool:get_config(Server2).\n{ok,{sys,[]}}\n6> reltool:stop(Server2).\nok\n```","ref":"reltool_examples.html#start-and-stop-windows-and-servers"},{"type":"extras","title":"Inspecting the configuration - Examples","doc":"```erlang\nErlang/OTP 20 [erts-9.0] [source-c13b302] [64-bit] [smp:4:4] [ds:4:4:10] [async-threads:10]\n[hipe] [kernel-poll:false]\nEshell V9.0  (abort with ^G)\n1>\n1> Config = {sys, [{escript, \"examples/display_args\", [{incl_cond, include}]},\n\t\t   {app, inets, [{incl_cond, include}]},\n\t\t   {app, mnesia, [{incl_cond, exclude}]},\n\t\t   {app, ssl, [{incl_cond, exclude}]},\n\t\t   {app, runtime_tools, [{incl_cond, exclude}]},\n\t\t   {app, syntax_tools, [{incl_cond, exclude}]}]}.\n{sys,[{escript,\"examples/display_args\",[{incl_cond,include}]},\n      {app,inets,[{incl_cond,include}]},\n      {app,mnesia,[{incl_cond,exclude}]},\n      {app,ssl,[{incl_cond,exclude}]},\n      {app,runtime_tools,[{incl_cond,exclude}]},\n      {app,syntax_tools,[{incl_cond,exclude}]}]}\n2>\n2> {ok, Server} = reltool:start_server([Config]).\n{ok,<0.66.0>}\n3>\n3> reltool:get_config(Server).\n{ok,{sys,[{escript,\"/usr/local/lib/erlang/lib/reltool-0.7.3/examples/display_args\",\n                   [{incl_cond,include}]},\n          {app,inets,[{incl_cond,include}]},\n          {app,mnesia,[{incl_cond,exclude}]},\n          {app,runtime_tools,[{incl_cond,exclude}]},\n          {app,ssl,[{incl_cond,exclude}]},\n          {app,syntax_tools,[{incl_cond,exclude}]}]}}\n4>\n4> reltool:get_config(Server, false, false).\n{ok,{sys,[{escript,\"/usr/local/lib/erlang/lib/reltool-0.7.3/examples/display_args\",\n                   [{incl_cond,include}]},\n          {app,inets,[{incl_cond,include}]},\n          {app,mnesia,[{incl_cond,exclude}]},\n          {app,runtime_tools,[{incl_cond,exclude}]},\n          {app,ssl,[{incl_cond,exclude}]},\n          {app,syntax_tools,[{incl_cond,exclude}]}]}}\n5>\n5> reltool:get_config(Server, true, false).\n{ok,{sys,[{root_dir,\"/usr/local/lib/erlang\"},\n          {lib_dirs,[]},\n          {escript,\"/usr/local/lib/erlang/lib/reltool-0.7.3/examples/display_args\",\n                   [{incl_cond,include}]},\n          {mod_cond,all},\n          {incl_cond,derived},\n          {app,inets,\n               [{incl_cond,include},{vsn,undefined},{lib_dir,undefined}]},\n          {app,mnesia,[{incl_cond,exclude}]},\n          {app,runtime_tools,[{incl_cond,exclude}]},\n          {app,ssl,[{incl_cond,exclude}]},\n          {app,syntax_tools,[{incl_cond,exclude}]},\n          {boot_rel,\"start_clean\"},\n          {rel,\"start_clean\",\"1.0\",[]},\n          {rel,\"start_sasl\",\"1.0\",[sasl]},\n          {emu_name,\"beam\"},\n          {relocatable,true},\n          {profile,development},\n          {incl_sys_filters,[\".*\"]},\n          {excl_sys_filters,[]},\n          {incl_app_filters,[\".*\"]},\n          {excl_app_filters,[]},\n          {rel_app_type,...},\n          {...}|...]}}\n6>\n6> reltool:get_config(Server, true, true).\n{ok,{sys,[{root_dir,\"/usr/local/lib/erlang\"},\n          {lib_dirs,[]},\n          {escript,\"/usr/local/lib/erlang/lib/reltool-0.7.3/examples/display_args\",\n                   [{incl_cond,include}]},\n          {mod_cond,all},\n          {incl_cond,derived},\n          {erts,[{app,erts,\n                      [{vsn,\"10.0\"},\n                       {lib_dir,\"/usr/local/lib/erlang/lib/erts-10.0\"},\n                       {mod,erl_prim_loader,[]},\n                       {mod,erl_tracer,[]},\n                       {mod,erlang,[]},\n                       {mod,erts_code_purger,[]},\n                       {mod,erts_dirty_process_signal_handler,[]},\n                       {mod,erts_internal,[]},\n                       {mod,erts_literal_area_collector,[]},\n                       {mod,init,[]},\n                       {mod,erl_init,...},\n                       {mod,...},\n                       {...}|...]}]},\n          {app,compiler,\n               [{vsn,\"7.0.4\"},\n                {lib_dir,\"/usr/local/lib/erlang/lib/compiler-7.0.4\"},\n                {mod,beam_a,[]},\n                {mod,beam_asm,[]},\n                {mod,beam_block,[]},\n                {mod,beam_bs,[]},\n                {mod,beam_bsm,[]},\n                {mod,beam_clean,[]},\n                {mod,beam_dead,[]},\n                {mod,beam_dict,[]},\n                {mod,beam_disasm,[]},\n                {mod,beam_except,[]},\n                {mod,beam_flatten,...},\n                {mod,...},\n                {...}|...]},\n          {app,crypto,\n               [{vsn,\"3.7.4\"},\n                {lib_dir,\"/usr/local/lib/erlang/lib/crypto-3.7.4\"},\n                {mod,crypto,[]},\n                {mod,crypto_ec_curves,[]}]},\n          {app,hipe,\n               [{vsn,\"3.15.4\"},\n                {lib_dir,\"/usr/local/lib/erlang/lib/hipe-3.15.4\"},\n                {mod,cerl_cconv,[]},\n                {mod,cerl_closurean,[]},\n                {mod,cerl_hipeify,[]},\n                {mod,cerl_lib,[]},\n                {mod,cerl_messagean,[]},\n                {mod,cerl_pmatch,[]},\n                {mod,cerl_prettypr,[]},\n                {mod,cerl_to_icode,[]},\n                {mod,cerl_typean,...},\n                {mod,...},\n                {...}|...]},\n          {app,inets,\n               [{incl_cond,include},\n                {vsn,\"6.3.9\"},\n                {lib_dir,\"/usr/local/lib/erlang/lib/inets-6.3.9\"},\n                {mod,ftp,[]},\n                {mod,ftp_progress,[]},\n                {mod,ftp_response,[]},\n                {mod,ftp_sup,[]},\n                {mod,http_chunk,[]},\n                {mod,http_request,[]},\n                {mod,http_response,...},\n                {mod,...},\n                {...}|...]},\n          {app,kernel,\n               [{vsn,\"5.2\"},\n                {lib_dir,\"/usr/local/lib/erlang/lib/kernel-5.2\"},\n                {mod,application,[]},\n                {mod,application_controller,[]},\n                {mod,application_master,[]},\n                {mod,application_starter,[]},\n                {mod,auth,[]},\n                {mod,code,[]},\n                {mod,code_server,...},\n                {mod,...},\n                {...}|...]},\n          {app,mnesia,[{incl_cond,exclude}]},\n          {app,runtime_tools,[{incl_cond,exclude}]},\n          {app,sasl,\n               [{vsn,\"3.0.3\"},\n                {lib_dir,\"/usr/local/lib/erlang/lib/sasl-3.0.3\"},\n                {mod,alarm_handler,[]},\n                {mod,erlsrv,[]},\n                {mod,format_lib_supp,[]},\n                {mod,misc_supp,...},\n                {mod,...},\n                {...}|...]},\n          {app,ssl,[{incl_cond,exclude}]},\n          {app,stdlib,\n               [{vsn,\"3.3\"},\n                {lib_dir,\"/usr/local/lib/erlang/lib/stdlib-3.3\"},\n                {mod,array,[]},\n                {mod,base64,...},\n                {mod,...},\n                {...}|...]},\n          {app,syntax_tools,[{incl_cond,exclude}]},\n          {app,tools,\n               [{vsn,\"2.9.1\"},{lib_dir,[...]},{mod,...},{...}|...]},\n          {boot_rel,\"start_clean\"},\n          {rel,\"start_clean\",\"1.0\",[]},\n          {rel,\"start_sasl\",\"1.0\",[...]},\n          {emu_name,\"beam\"},\n          {relocatable,true},\n          {profile,...},\n          {...}|...]}}\n7>\n7> reltool:get_config([{sys, [{profile, embedded}]}], true, false).\n{ok,{sys,[{root_dir,\"/usr/local/lib/erlang\"},\n          {lib_dirs,[]},\n          {mod_cond,all},\n          {incl_cond,derived},\n          {boot_rel,\"start_clean\"},\n          {rel,\"start_clean\",\"1.0\",[]},\n          {rel,\"start_sasl\",\"1.0\",[sasl]},\n          {emu_name,\"beam\"},\n          {relocatable,true},\n          {profile,embedded},\n          {incl_sys_filters,[\"^bin\",\"^erts\",\"^lib\",\"^releases\"]},\n          {excl_sys_filters,[\"^bin/(erlc|dialyzer|typer)(|\\\\.exe)$\",\n                             \"^erts.*/bin/(erlc|dialyzer|typer)(|\\\\.exe)$\",\n                             \"^erts.*/bin/.*(debug|pdb)\"]},\n          {incl_app_filters,[\"^ebin\",\"^include\",\"^priv\"]},\n          {excl_app_filters,[]},\n          {rel_app_type,permanent},\n          {embedded_app_type,load},\n          {app_file,keep},\n          {debug_info,keep}]}}\n8>\n8> reltool:get_config([{sys, [{profile, standalone}]}], true, false).\n{ok,{sys,[{root_dir,\"/usr/local/lib/erlang\"},\n          {lib_dirs,[]},\n          {mod_cond,all},\n          {incl_cond,derived},\n          {boot_rel,\"start_clean\"},\n          {rel,\"start_clean\",\"1.0\",[]},\n          {rel,\"start_sasl\",\"1.0\",[sasl]},\n          {emu_name,\"beam\"},\n          {relocatable,true},\n          {profile,standalone},\n          {incl_sys_filters,[\"^bin/(erl|epmd)(|\\\\.exe|\\\\.ini)$\",\n                             \"^bin/start(|_clean).boot$\",\"^erts.*/bin\",\"^lib$\"]},\n          {excl_sys_filters,[\"^erts.*/bin/(erlc|dialyzer|typer)(|\\\\.exe)$\",\n                             \"^erts.*/bin/(start|escript|to_erl|run_erl)(|\\\\.exe)$\",\n                             \"^erts.*/bin/.*(debug|pdb)\"]},\n          {incl_app_filters,[\"^ebin\",\"^priv\"]},\n          {excl_app_filters,[\"^ebin/.*\\\\.appup$\"]},\n          {rel_app_type,permanent},\n          {app_file,keep},\n          {debug_info,keep}]}}\n```","ref":"reltool_examples.html#inspecting-the-configuration"},{"type":"extras","title":"Generate release and script files - Examples","doc":"```erlang\nErlang/OTP 20 [erts-10.0] [source-c13b302] [64-bit] [smp:4:4] [ds:4:4:10] [async-threads:10]\n[hipe] [kernel-poll:false]\nEshell V10.0  (abort with ^G)\n1>\n1> {ok, Server} = reltool:start_server([{config,\n                                         {sys,\n                                          [{boot_rel, \"NAME\"},\n                                           {rel, \"NAME\", \"VSN\",\n                                            [sasl],\n                                            [{load_dot_erlang, false}]}]}}]).\n{ok,<0.1288.0>}\n2>\n2> reltool:get_config(Server).\n{ok,{sys,[{boot_rel,\"NAME\"},\n          {rel,\"NAME\",\"VSN\",[sasl]}]}}\n3>\n3> reltool:get_rel(Server, \"NAME\").\n{ok,{release,{\"NAME\",\"VSN\"},\n             {erts,\"10.0\"},\n             [{kernel,\"5.2\"},{stdlib,\"3.3\"},{sasl,\"3.0.3\"}]}}\n4>\n4> reltool:get_script(Server, \"NAME\").\n{ok,{script,{\"NAME\",\"VSN\"},\n            [{preLoaded,[erl_prim_loader,erl_tracer,erlang,\n                         erts_code_purger,erts_dirty_process_signal_handler,\n                         erts_internal,erts_literal_area_collector,init,erl_init,\n                         prim_eval,prim_file,prim_inet,prim_zip,zlib]},\n             {progress,preloaded},\n             {path,[\"$ROOT/lib/kernel-5.2/ebin\",\n                    \"$ROOT/lib/stdlib-3.3/ebin\"]},\n             {primLoad,[error_handler]},\n             {kernel_load_completed},\n             {progress,kernel_load_completed},\n             {path,[\"$ROOT/lib/kernel-5.2/ebin\"]},\n             {primLoad,[application,application_controller,\n                        application_master,application_starter,auth,code,\n                        code_server,disk_log,disk_log_1,disk_log_server,\n                        disk_log_sup,dist_ac,dist_util,erl_boot_server|...]},\n             {path,[\"$ROOT/lib/stdlib-3.3/ebin\"]},\n             {primLoad,[array,base64,beam_lib,binary,c,calendar,dets,\n                        dets_server,dets_sup,dets_utils,dets_v9,dict|...]},\n             {path,[\"$ROOT/lib/sasl-3.0.3/ebin\"]},\n             {primLoad,[alarm_handler,erlsrv,format_lib_supp,misc_supp,\n                        rb,rb_format_supp,release_handler,release_handler_1,sasl,\n                        sasl_report|...]},\n             {progress,modules_loaded},\n             {path,[\"$ROOT/lib/kernel-5.2/ebin\",\n                    \"$ROOT/lib/stdlib-3.3/ebin\",\"$ROOT/lib/sasl-3.0.3/ebin\"]},\n             {kernelProcess,heart,{heart,start,[]}},\n             {kernelProcess,error_logger,{error_logger,start_link,[]}},\n             {kernelProcess,application_controller,\n                            {application_controller,start,[{...}]}},\n             {progress,init_kernel_started},\n             {apply,{application,load,[...]}},\n             {apply,{application,load,...}},\n             {progress,applications_loaded},\n             {apply,{...}},\n             {apply,...},\n             {...}|...]}}\n5>\n5> reltool:stop(Server).\nok\n```","ref":"reltool_examples.html#generate-release-and-script-files"},{"type":"extras","title":"Create a target system - Examples","doc":"```erlang\nErlang/OTP 20 [erts-10.0] [source-c13b302] [64-bit] [smp:4:4] [ds:4:4:10] [async-threads:10]\n[hipe] [kernel-poll:false]\nEshell V10.0  (abort with ^G)\n1>\n1> Config = {sys, [{escript, \"examples/display_args\", [{incl_cond, include}]},\n\t\t   {app, inets, [{incl_cond, include}]},\n\t\t   {app, mnesia, [{incl_cond, exclude}]},\n\t\t   {app, ssl, [{incl_cond, exclude}]},\n\t\t   {app, runtime_tools, [{incl_cond, exclude}]},\n\t\t   {app, syntax_tools, [{incl_cond, exclude}]}]}.\n{sys,[{escript,\"examples/display_args\",[{incl_cond,include}]},\n      {app,inets,[{incl_cond,include}]},\n      {app,mnesia,[{incl_cond,exclude}]},\n      {app,ssl,[{incl_cond,exclude}]},\n      {app,runtime_tools,[{incl_cond,exclude}]},\n      {app,syntax_tools,[{incl_cond,exclude}]}]}\n2>\n2> {ok, Spec} = reltool:get_target_spec([Config]).\n{ok,[{create_dir,\"releases\",\n         [{write_file,\"start_erl.data\",\"10.0 1.0\\n\"},\n          {create_dir,\"1.0\",\n              [{write_file,\"start_clean.rel\",\n                   [37,37,32,114,101,108,32,103,101,110,101,114,97,116|...]},\n               {write_file,\"start_clean.script\",\n                   [37,37,32,115,99,114,105,112,116,32,103,101,110|...]},\n               {write_file,\"start_clean.boot\",\n                   <<131,104,3,119,6,115,99,114,105,112,116,104,...>>},\n               {write_file,\"start_sasl.rel\",\n                   [37,37,32,114,101,108,32,103,101,110,101|...]},\n               {write_file,\"start_sasl.script\",\n                   [37,37,32,115,99,114,105,112,116,32|...]},\n               {write_file,\"start_sasl.boot\",\n                   <<131,104,3,119,6,115,99,114,105,...>>}]}]},\n     {create_dir,\"bin\",\n         [{copy_file,\"display_args.escript\",\n              \"/usr/local/lib/erlang/lib/reltool-0.7.3/examples/display_args\"},\n          {copy_file,\"display_args\",\"erts-10.0/bin/escript\"},\n          {copy_file,\"start\",\"erts-10.0/bin/start\"},\n          {copy_file,\"ct_run\",\"erts-10.0/bin/ct_run\"},\n          {copy_file,\"dialyzer\",\"erts-10.0/bin/dialyzer\"},\n          {copy_file,\"run_erl\",\"erts-10.0/bin/run_erl\"},\n          {copy_file,\"erl\",\"erts-10.0/bin/dyn_erl\"},\n          {copy_file,\"to_erl\",\"erts-10.0/bin/to_erl\"},\n          {copy_file,\"epmd\",\"erts-10.0/bin/epmd\"},\n          {copy_file,\"erlc\",\"erts-10.0/bin/erlc\"},\n          {copy_file,\"typer\",\"erts-10.0/bin/typer\"},\n          {copy_file,\"escript\",\"erts-10.0/bin/escript\"},\n          {write_file,\"start_clean.boot\",<<131,104,3,119,6,115,...>>},\n          {write_file,\"start_sasl.boot\",<<131,104,3,119,6,...>>},\n          {write_file,\"start.boot\",<<131,104,3,119,...>>}]},\n     {copy_file,\"Install\"},\n     {create_dir,\"misc\",\n         [{copy_file,\"format_man_pages\"}]},\n     {create_dir,\"usr\",\n         [{create_dir,\"lib\",\n              [{copy_file,\"liberl_interface_st.a\"},\n               {copy_file,\"libic.a\"},\n               {copy_file,\"liberl_interface.a\"},\n               {copy_file,\"libei_st.a\"},\n               {copy_file,\"libei.a\"}]},\n          {create_dir,\"include\",\n              [{copy_file,\"driver_int.h\"},\n               {copy_file,\"ei_connect.h\"},\n               {copy_file,\"ei.h\"},\n               {copy_file,\"erl_nif_api_funcs.h\"},\n               {copy_file,\"erl_fixed_size_int_types.h\"},\n               {copy_file,\"erl_int_sizes_config.h\"},\n               {copy_file,\"erl_interface.h\"},\n               {copy_file,\"eicode.h\"},\n               {copy_file,\"erl_driver.h\"},\n               {copy_file,\"erlang.idl\"},\n               {copy_file,[...]},\n               {copy_file,...},\n               {...}]}]},\n     {create_dir,\"erts-10.0\",\n         [{create_dir,\"bin\",\n              [{copy_file,\"start\"},\n               {copy_file,\"ct_run\"},\n               {copy_file,\"erlexec\"},\n               {copy_file,\"dialyzer\"},\n               {copy_file,\"beam.smp\"},\n               {copy_file,\"run_erl\"},\n               {copy_file,\"erl\",\"erts-10.0/bin/dyn_erl\"},\n               {copy_file,\"to_erl\"},\n               {copy_file,\"epmd\"},\n               {copy_file,\"erl_child_setup\"},\n               {copy_file,\"heart\"},\n               {copy_file,[...]},\n               {copy_file,...},\n               {...}|...]},\n          {create_dir,\"lib\",\n              [{create_dir,\"internal\",\n                   [{copy_file,\"liberts_internal.a\"},\n                    {copy_file,\"liberts_internal_r.a\"},\n                    {copy_file,\"libethread.a\"},\n                    {copy_file,\"README\"}]},\n               ]},\n          {create_dir,\"src\",[{copy_file,\"setuid_socket_wrap.c\"}]},\n          {create_dir,\"doc\",[]},\n          {create_dir,\"man\",[]},\n          {create_dir,\"include\",\n              [{create_dir,\"internal\",\n                   [{create_dir,\"i386\",[{...}|...]},\n                    {copy_file,\"erl_errno.h\"},\n                    {copy_file,[...]},\n                    {copy_file,...},\n                    {...}|...]},\n               {copy_file,\"driver_int.h\"},\n               {copy_file,\"erl_nif_api_funcs.h\"},\n               {copy_file,\"erl_fixed_size_int_types.h\"},\n               {copy_file,\"erl_int_sizes_config.h\"},\n               {copy_file,[...]},\n               {copy_file,...},\n               {...}]}]},\n     {create_dir,\"lib\",\n         [{create_dir,\"compiler-7.0.4\",\n              [{create_dir,\"src\",\n                   [{copy_file,\"beam_flatten.erl\"},\n                    {copy_file,[...]},\n                    {copy_file,...},\n                    {...}|...]},\n               {create_dir,\"ebin\",\n                   [{copy_file,[...]},{copy_file,...},{...}|...]}]},\n          {create_dir,\"crypto-3.7.4\",\n              [{create_dir,\"src\",[{copy_file,[...]},{copy_file,...}]},\n               {create_dir,\"ebin\",[{copy_file,...},{...}|...]}]},\n          {create_dir,\"crypto-3.7.4\",\n              [{create_dir,\"priv\",\n                   [{create_dir,\"lib\",[{copy_file,[...]},{copy_file,...}]},\n                    {create_dir,\"obj\",[{copy_file,...},{...}|...]}]}]},\n          {create_dir,\"erts-10.0\",\n              [{create_dir,\"src\",[{...}|...]},\n               {create_dir,\"ebin\",[...]}]},\n          {create_dir,\"hipe-3.15.4\",\n              [{create_dir,\"flow\",[...]},\n               {copy_file,[...]},\n               {create_dir,...},\n               {...}|...]},\n          {create_dir,\"inets-6.3.9\",\n              [{create_dir,[...],...},{create_dir,...},{...}]},\n          {create_dir,\"inets-6.3.9\",\n              [{create_dir,\"priv\",[{create_dir,[...],...}]},\n               {create_dir,\"include\",[{copy_file,...},{...}]}]},\n          {create_dir,\"kernel-5.2\",[{...}|...]},\n          {create_dir,\"kernel-5.2\",\n              [{create_dir,\"include\",[{...}|...]}]},\n          {create_dir,[...],...},\n          {create_dir,...},\n          {create_dir,\"stdlib-3.3\",[{create_dir,...}]},\n          ...]}]}\n3>\n3> TargetDir = \"/tmp/my_target_dir\".\n\"/tmp/my_target_dir\"\n4>\n4> reltool:eval_target_spec(Spec, code:root_dir(), TargetDir).\n{error,\"/tmp/my_target_dir: no such file or directory\"}\n5>\n5> file:make_dir(TargetDir).\nok\n6>\n6> reltool:eval_target_spec(Spec, code:root_dir(), TargetDir).\nok\n7>\n7> file:list_dir(TargetDir).\n{ok,[\"bin\",\"Install\",\"lib\",\"misc\",\"usr\",\"erts-10.0\",\n     \"releases\"]}\n8>\n8> file:list_dir(filename:join([TargetDir,\"lib\"])).\n{ok,[\"tools-2.9.1\",\"inets-6.3.9\",\n     \"kernel-5.2\",\"sasl-3.0.3\",\n     \"crypto-3.7.4\",\"erts-10.0\",\n     \"stdlib-3.3\",\"compiler-7.0.4\"]}\n9>\n9> file:make_dir(\"/tmp/yet_another_target_dir\").\nok\n10>\n10> reltool:create_target([Config], \"/tmp/yet_another_target_dir\").\nok\n11>\n11> file:list_dir(\"/tmp/yet_another_target_dir\").\n{ok,[\"bin\",\"Install\",\"lib\",\"misc\",\"usr\",\"erts-10.0\",\n     \"releases\"]}\n```","ref":"reltool_examples.html#create-a-target-system"}],"content_type":"text/plain","producer":{"name":"ex_doc","version":[48,46,51,52,46,49]}}