/*
 * vars.h: header for vars.c
 *
 * Copyright 1990, 1995 Michael Sandroff, Matthew Green and others.
 * Copyright 1997 EPIC Software Labs
 */

#ifndef __vars_h__
#define __vars_h__

/* indexes for the irc_variable array */
/*
enum VAR_TYPES {
*/

#ifndef VARS_C
extern
#endif

int	ALLOW_C1_CHARS_VAR,
	ALWAYS_SPLIT_BIGGEST_VAR,
	BANNER_VAR,
	BANNER_EXPAND_VAR,
	BEEP_VAR,
	CHANNEL_NAME_WIDTH_VAR,
	CLIENT_INFORMATION_VAR,
	CLOCK_VAR,
	CLOCK_24HOUR_VAR,
	CLOCK_FORMAT_VAR,
	CLOCK_INTERVAL_VAR,
	CMDCHARS_VAR,
	COMMENT_HACK_VAR,
	CONTINUED_LINE_VAR,
	CPU_SAVER_AFTER_VAR,
	CPU_SAVER_EVERY_VAR,
	CURRENT_WINDOW_LEVEL_VAR,
	DCC_AUTO_SEND_REJECTS_VAR,
	DCC_CONNECT_TIMEOUT_VAR,
	DCC_DEQUOTE_FILENAMES_VAR,
	DCC_LONG_PATHNAMES_VAR,
	DCC_SLIDING_WINDOW_VAR,
	DCC_STORE_PATH_VAR,
	DCC_USE_GATEWAY_ADDR_VAR,
	DEBUG_VAR,
	DEFAULT_REALNAME_VAR,
	DEFAULT_USERNAME_VAR,
	DISPATCH_UNKNOWN_COMMANDS_VAR,
	DISPLAY_VAR,
	DO_NOTIFY_IMMEDIATELY_VAR,
	FIRST_LINE_VAR,
	FLOATING_POINT_MATH_VAR,
	FLOATING_POINT_PRECISION_VAR,
	FLOOD_AFTER_VAR,
	FLOOD_IGNORE_VAR,
	FLOOD_MASKUSER_VAR,
	FLOOD_RATE_VAR,
	FLOOD_RATE_PER_VAR,
	FLOOD_USERS_VAR,
	FLOOD_WARNING_VAR,
	HIDE_PRIVATE_CHANNELS_VAR,
	HIGHLIGHT_CHAR_VAR,
	HOLD_SLIDER_VAR,
	INDENT_VAR,
	INPUT_INDICATOR_LEFT_VAR,
        INPUT_INDICATOR_RIGHT_VAR,
	INPUT_PROMPT_VAR,
	INSERT_MODE_VAR,
	KEY_INTERVAL_VAR,
	LASTLOG_VAR,
	LASTLOG_LEVEL_VAR,
	LASTLOG_REWRITE_VAR,
	LOAD_PATH_VAR,
	LOG_VAR,
	LOGFILE_VAR,
	LOG_REWRITE_VAR,
	MAIL_VAR,
	MAIL_INTERVAL_VAR,
	MAIL_TYPE_VAR,
	MANGLE_DISPLAY_VAR,
	MANGLE_INBOUND_VAR,
	MANGLE_LOGFILES_VAR,
	MANGLE_OUTBOUND_VAR,
	METRIC_TIME_VAR,
	MIRC_BROKEN_DCC_RESUME_VAR,
	MODE_STRIPPER_VAR,
	NEW_SERVER_LASTLOG_LEVEL_VAR,
	NOTIFY_VAR,
	NOTIFY_INTERVAL_VAR,
	NOTIFY_LEVEL_VAR,
	NOTIFY_ON_TERMINATION_VAR,
	NOTIFY_USERHOST_AUTOMATIC_VAR,
	NO_CONTROL_LOG_VAR,
	NO_CTCP_FLOOD_VAR,
	NO_FAIL_DISCONNECT_VAR,
	OLD_MATH_PARSER_VAR,
	OLD_SERVER_LASTLOG_LEVEL_VAR,
	OUTPUT_REWRITE_VAR,
	PAD_CHAR_VAR,
	QUIT_MESSAGE_VAR,
	RANDOM_SOURCE_VAR,
	SCREEN_OPTIONS_VAR,
	SCROLLBACK_VAR,
	SCROLLBACK_RATIO_VAR,
	SCROLL_LINES_VAR,
	SHELL_VAR,
	SHELL_FLAGS_VAR,
	SHELL_LIMIT_VAR,
	SHOW_CHANNEL_NAMES_VAR,
	SHOW_NUMERICS_VAR,
	SHOW_STATUS_ALL_VAR,
	SSL_ROOT_CERTS_LOCATION_VAR,
	STATUS_AWAY_VAR,
	STATUS_CHANNEL_VAR,
	STATUS_CHANOP_VAR,
	STATUS_CLOCK_VAR,
	STATUS_CPU_SAVER_VAR,
	STATUS_DOES_EXPANDOS_VAR,
	STATUS_FORMAT_VAR,
	STATUS_FORMAT1_VAR,
	STATUS_FORMAT2_VAR,
	STATUS_HALFOP_VAR,
	STATUS_HOLD_VAR,
	STATUS_HOLD_LINES_VAR,
	STATUS_HOLDMODE_VAR,
	STATUS_INSERT_VAR,
	STATUS_MAIL_VAR,
	STATUS_MODE_VAR,
	STATUS_NICKNAME_VAR,
	STATUS_NOSWAP_VAR,
	STATUS_NOTIFY_VAR,
	STATUS_NO_REPEAT_VAR,
	STATUS_OPER_VAR,
	STATUS_OVERWRITE_VAR,
	STATUS_PREFIX_WHEN_CURRENT_VAR,
	STATUS_PREFIX_WHEN_NOT_CURRENT_VAR,
	STATUS_QUERY_VAR,
	STATUS_SCROLLBACK_VAR,
	STATUS_SERVER_VAR,
	STATUS_SSL_OFF_VAR,
	STATUS_SSL_ON_VAR,
	STATUS_UMODE_VAR,
	STATUS_USER_VAR,
	STATUS_USER1_VAR,
	STATUS_USER10_VAR,
	STATUS_USER11_VAR,
	STATUS_USER12_VAR,
	STATUS_USER13_VAR,
	STATUS_USER14_VAR,
	STATUS_USER15_VAR,
	STATUS_USER16_VAR,
	STATUS_USER17_VAR,
	STATUS_USER18_VAR,
	STATUS_USER19_VAR,
	STATUS_USER2_VAR,
	STATUS_USER20_VAR,
	STATUS_USER21_VAR,
	STATUS_USER22_VAR,
	STATUS_USER23_VAR,
	STATUS_USER24_VAR,
	STATUS_USER25_VAR,
	STATUS_USER26_VAR,
	STATUS_USER27_VAR,
	STATUS_USER28_VAR,
	STATUS_USER29_VAR,
	STATUS_USER3_VAR,
	STATUS_USER30_VAR,
	STATUS_USER31_VAR,
	STATUS_USER32_VAR,
	STATUS_USER33_VAR,
	STATUS_USER34_VAR,
	STATUS_USER35_VAR,
	STATUS_USER36_VAR,
	STATUS_USER37_VAR,
	STATUS_USER38_VAR,
	STATUS_USER39_VAR,
	STATUS_USER4_VAR,
	STATUS_USER5_VAR,
	STATUS_USER6_VAR,
	STATUS_USER7_VAR,
	STATUS_USER8_VAR,
	STATUS_USER9_VAR,
	STATUS_VOICE_VAR,
	STATUS_WINDOW_VAR,
	SUPPRESS_FROM_REMOTE_SERVER_VAR,
	SWITCH_CHANNELS_BETWEEN_WINDOWS_VAR,
	TERM_DOES_BRIGHT_BLINK_VAR,
	TMUX_OPTIONS_VAR,
	USER_INFORMATION_VAR,
	WORD_BREAK_VAR,
	WSERV_PATH_VAR,
	WSERV_TYPE_VAR,
	XTERM_VAR,
	XTERM_OPTIONS_VAR,
	NUMBER_OF_VARIABLES
/* } */ ;

/* var_settings indexes ... also used in display.c for highlights */
#define OFF 			0
#define ON 			1
#define TOGGLE 			2

#define	DEBUG_COMMANDS		0x0001
#define	DEBUG_EXPANSIONS	0x0002
#define DEBUG_FUNCTIONS		0x0004

typedef union builtin_variable {
        char *  string;                 /* string value of variable */
        int     integer;                /* int value of variable */
} VARIABLE;

/* the types of IrcVariables */
#define STR_VAR 	0
#define INT_VAR 	1
#define CHAR_VAR 	2
#define BOOL_VAR 	3

/* IrcVariable: structure for each variable in the variable table */
typedef struct
{
        int             type;           /* variable types, see below */
        VARIABLE *      data;           /* The value of the variable */
        void    (*func) (void *); 	/* func called when var is set */
	char *		script;		/* script called when var is set */
        unsigned short  pending;        /* set when it is being changed (prevents recursion) */
}       IrcVariable;



	BUILT_IN_COMMAND(setcmd);

	int	do_boolean 		(char *, int *);
	int	do_short_boolean 	(char *, short *);
	int	get_int_var 		(int);
const	char *	get_string_var 		(int);
	void	set_var_value		(int, const char *, int);
	int	is_var_builtin		(const char *);
	void	init_variables_stage1	(void);
	void	init_variables_stage2	(void);
	char*	make_string_var 	(const char *);
	int     make_string_var2 	(const char *, char **);
	int	charset_size 		(void);
	void	save_variables 		(FILE *, int);
	void	do_stack_set		(int, char *);
	int	parse_mangle		(const char *, int, char **);
	char	*get_set		(const char *);
	char *	make_string_var_bydata	(const void *);
	int	set_variable		(const char *, IrcVariable *, const char *, int);
	IrcVariable *   clone_biv	(IrcVariable *);
	void	unclone_biv		(const char *, IrcVariable *);

#endif /* _VARS_H_ */
