// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; comment-column: 35; -*-

//-----------------------------------------------------------------------------
// eoLinearDecreasingWeightUp.h
// (c) OPAC 2007
/*
    Contact: paradiseo-help@lists.gforge.inria.fr
 */
//-----------------------------------------------------------------------------

#ifndef EOLINEARDECREASINGWEIGHTUP_H
#define EOLINEARDECREASINGWEIGHTUP_H

//-----------------------------------------------------------------------------
#include <eoWeightUpdater.h>
//-----------------------------------------------------------------------------


/**
 * Linear (inertia) weight updater. Update a weight according to:
 * w(t)=(w(0)-w(Nt))*(Nt -t)/Nt + w(Nt) where
 *  t is the current generation/event
 *  Nt is the total number of generations/event
 *  w(0) is the initial weight
 *  w(Nt) is the last inertia weight
 */
template <class WeightType, class StopCriteriaType> class eoLinearDecreasingWeightUp:public eoWeightUpdater<WeightType>
{
public:

    /**
     * Ctor
     */
    eoLinearDecreasingWeightUp(
        const StopCriteriaType & _stop,
        const WeightType  & _initialValue,
        const WeightType & _finalValue,
        eoValueParam<StopCriteriaType> &  _counter):
            stop(_stop),
            initialValue(_initialValue),
            finalValue(_finalValue),
            counter(_counter){}

    /**
     * Update the given weight
     */
    void operator() (WeightType & _weight)
    {
        _weight=(initialValue-finalValue)* (WeightType)(stop-counter.value())/(WeightType)stop + finalValue;

    }

protected:
    const StopCriteriaType & stop;
    const WeightType & initialValue,finalValue;
    eoValueParam<StopCriteriaType> & counter; // a counter of the number of past events (should say "generations")
};



#endif/*EOLINEARDECREASINGWEIGHTUP_H*/
