# EnTT in Action

# Table of Contents

* [Introduction](#introduction)
* [EnTT in Action](#entt-in-action)
  * [Games](#games)
  * [Engines and the like](#engines-and-the-like)
  * [Articles, videos and blog posts](#articles-videos-and-blog-posts)
  * [Any Other Business](#any-other-business)

# Introduction

`EnTT` is widely used in private and commercial applications. I cannot even
mention most of them because of some signatures I put on some documents time
ago. Fortunately, there are also people who took the time to implement open
source projects based on `EnTT` and didn't hold back when it came to documenting
them.

Below an incomplete list of games, applications and articles that can be used as
a reference.<br/>
Where I put the word _apparently_ means that the use of `EnTT` is documented but
the authors didn't make explicit announcements or contacted me directly.

If you know of other resources out there that are about `EnTT`, feel free to
open an issue or a PR and I'll be glad to add them to this page.<br/>
I hope the following lists can grow much more in the future.

# EnTT in Action

## Games

  * [Minecraft](https://minecraft.net/en-us/attribution/) by
    [Mojang](https://mojang.com/): of course, **that** Minecraft, see the
    open source attributions page for more details.
  * [Minecraft Legends](https://www.minecraft.net/it-it/about-legends) by
    [Mojang](https://mojang.com/): an action strategy game where users have to
    fight to defend the Overworld.
  * [Minecraft Earth](https://www.minecraft.net/en-us/about-earth) by
    [Mojang](https://mojang.com/): an augmented reality game for mobile, that
    lets users bring Minecraft into the real world.
  * [Ember Sword](https://embersword.com/): a modern Free-to-Play MMORPG with a
    player-driven economy, a classless combat system, and scarce, tradable
    cosmetic collectibles.
  * Apparently [Diablo II: Resurrected](https://diablo2.blizzard.com/) by
    [Blizzard](https://www.blizzard.com/): monsters, heroes, items, spells, all
    resurrected. Thanks unknown insider.
  * [Apparently](https://www.youtube.com/watch?v=P8xvOA3ikrQ&t=1105s)
    [Call of Duty: Vanguard](https://www.callofduty.com/vanguard) by
    [Sledgehammer Games](https://www.sledgehammergames.com/): I can neither
    confirm nor deny but there is a license I know in the credits.
  * Apparently [D&D Dark Alliance](https://darkalliance.wizards.com) by
    [Wizards of the Coast](https://company.wizards.com): your party, their
    funeral.
  * [TiltedEvolution](https://github.com/tiltedphoques/TiltedEvolution) by
    [Tilted Phoques](https://github.com/tiltedphoques): Skyrim and Fallout 4 mod
    to play online.
  * [Antkeeper](https://github.com/antkeeper/antkeeper-source): an ant colony
    simulation [game](https://antkeeper.com/).
  * [Openblack](https://github.com/openblack/openblack): open source
    reimplementation of the game _Black & White_ (2001).
  * [Land of the Rair](https://github.com/LandOfTheRair/core2): the new backend
    of [a retro-style MUD](https://rair.land/) for the new age.
  * [Face Smash](https://play.google.com/store/apps/details?id=com.gamee.facesmash):
    a game to play with your face.
  * [EnTT Pacman](https://github.com/Kerndog73/EnTT-Pacman): an example of how
    to make Pacman with `EnTT`.
  * [Wacman](https://github.com/carlfindahl/wacman): a pacman clone with OpenGL.
  * [Classic Tower Defence](https://github.com/kerndog73/Classic-Tower-Defence):
    a tiny little tower defence game featuring a homemade font.
    [Check it out](https://indi-kernick.itch.io/classic-tower-defence).
  * [The Machine](https://github.com/Kerndog73/The-Machine): a box pushing
    puzzler with logic gates and other cool stuff.
    [Check it out](https://indi-kernick.itch.io/the-machine-web-version).
  * [EnTTPong](https://github.com/DomRe/EnttPong): a basic game made to showcase
    different parts of `EnTT` and C++17.
  * [Randballs](https://github.com/gale93/randballs): simple `SFML` and `EnTT`
    playground.
  * [EnTT Tower Defense](https://github.com/Daivuk/tddod): a data oriented tower
    defense example.
  * [EnTT Breakout](https://github.com/vblanco20-1/entt-breakout): simple
    example of a breakout game, using `SDL` and `EnTT`.
  * [Arcade puzzle game with EnTT](https://github.com/MasonRG/ArcadePuzzleGame):
    arcade puzzle game made in C++ using the `SDL2` and `EnTT` libraries.
  * [Snake with EnTT](https://github.com/MasonRG/SnakeGame): simple snake game
    made in C++ with the `SDL2` and `EnTT` libraries.
  * [Mirrors lasers and robots](https://github.com/guillaume-haerinck/imac-tower-defense):
    a small tower defense game based on mirror orientation.
  * [PopHead](https://github.com/SPC-Some-Polish-Coders/PopHead/): 2D, Zombie,
    RPG game made from scratch in C++.
  * [Robotligan](https://github.com/Trisslotten/robotligan): multiplayer
    football game.
  * [DungeonSlayer](https://github.com/alohaeee/DungeonSlayer): 2D game made
    from scratch in C++.
  * [3DGame](https://github.com/kwarkGorny/3DGame): 2.5D top-down space shooter.
  * [Pulcher](https://github.com/AODQ/pulcher): 2D cross-platform game inspired
    by Quake.
  * [Destroid](https://github.com/tyrannicaltoucan/destroid): _one-bazillionth_
    arcade game about shooting dirty rocks in space, inspired by Asteroids.
  * [Wanderer](https://github.com/albin-johansson/wanderer): a 2D exploration
    based indie game.
  * [Spelunky Classic remake](https://github.com/dbeef/spelunky-psp): a truly
    multiplatform experience with a rewrite from scratch.
  * [CubbyTower](https://github.com/utilForever/CubbyTower): a simple tower
    defense game using C++ with Entity Component System (ECS).
  * [Runeterra](https://github.com/utilForever/Runeterra): Legends of Runeterra
    simulator using C++ with some reinforcement learning.
  * [Black Sun](https://store.steampowered.com/app/1670930/Black_Sun/): fly your
    space ship through a large 2D open world.
  * [PokeMaster](https://github.com/utilForever/PokeMaster): Pokemon Battle
    simulator using C++ with some reinforcement learning.
  * [HomeHearth](https://youtu.be/GrEWl8npL9Y): choose your hero, protect the
    town, before it's too late.
  * [City Builder Game](https://github.com/PhiGei2000/CityBuilderGame): a simple
    city-building game using C++ and OpenGL.
  * [BattleSub](https://github.com/bfeldpw/battlesub): two player 2D submarine
    game with some fluid dynamics.
  * [Crimson Rush](https://github.com/WilKam01/LuaCGame): a dungeon-crawler and
    rougelike inspired game about exploring and surviving as long as possible.
  * [Space Fight](https://github.com/cholushkin/SpaceFight): one screen
    multi-player arcade shooter game prototype.
  * [Confetti Party](https://github.com/hexerei/entt-confetti): C++ sample
    application as a starting point using `EnTT` and `SDL2`.
  * [Hellbound](https://buas.itch.io/hellbound): a top-down action rogue-like
    where to fight colossal demons in procedurally generated levels of hell.
  * [Saurian Sorcery](https://github.com/cajallen/spellbook): a tower defense
    game where to assemble a tribe of lizards to defend against robot invaders.
  * [robotfindskitten](https://github.com/autogalkin/robotfindskitten): a clone
    of `robotfindskitten` inside `Notepad.exe`, powered by `EnTT`.
  * [Orion](https://github.com/alekskoloch/Orion): Outer-space Research and
    Interstellar Observation Network (a space shooter game).
  * [EnTT Boids](https://github.com/DanielEliasib/entt_boids): a simple boids
    implementation using `EnTT` and `Raylib`.
  * [PalmRide: After Flight](https://store.steampowered.com/app/2812540/PalmRide_After_Flight/):
    an on-rails shooter with retro outrun aesthetics.
  * [Exhibition of Speed](https://store.steampowered.com/app/2947450/Exhibition_of_Speed/):
    build your own car and go racing.
  * [Lichgate](https://buas.itch.io/lichgate): top-down action rogue-like where
    users unlock abilities to fight horde of enemies in an endless world.
  * [Letalka](https://github.com/dviglo2d-learn/mini_games/tree/main/letalka):
    small demo game with ships and bullets flying everywhere on the screen.

## Engines and the like:

  * [Hazel Engine](https://github.com/TheCherno/Hazel): a work in progress
    engine created by [The Cherno](https://github.com/TheCherno/Hazel) during
    one of his most famous video series.
  * [Aether Engine](https://hadean.com/spatial-simulation/)
    [v1.1+](https://docs.hadean.com/v1.1/Licenses/) by
    [Hadean](https://hadean.com/): a library designed for spatially partitioning
    agent-based simulations.
  * [Fling Engine](https://github.com/flingengine/FlingEngine): a Vulkan game
    engine with a focus on data oriented design.
  * [NovusCore](https://github.com/novuscore/NovusCore): a modern take on World
    of Warcraft emulation.
  * [Chrysalis](https://github.com/ivanhawkes/Chrysalis): action RPG SDK for
    CRYENGINE games.
  * [LM-Engine](https://github.com/Lawrencemm/LM-Engine): the Vim of game
    engines.
  * [Edyn](https://github.com/xissburg/edyn): a real-time physics engine
    organized as an ECS.
  * [MushMachine](https://github.com/MadeOfJelly/MushMachine): engine...
    vrooooommm.
  * [Antara Gaming SDK](https://github.com/KomodoPlatform/antara-gaming-sdk):
    the Komodo Gaming Software Development Kit.
  * [XVP](https://ravingbots.com/xvp-expansive-vehicle-physics-for-unreal-engine/):
    [_eXpansive Vehicle Physics_](https://github.com/raving-bots/xvp/wiki/Plugin-integration-guide)
    plugin for Unreal Engine.
  * [Apparently](https://teamwisp.github.io/credits/)
    [Wisp](https://teamwisp.github.io/product/) by
    [Team Wisp](https://teamwisp.github.io/): an advanced real-time ray tracing
    renderer built for the demands of video game artists.
  * [shiva](https://github.com/Milerius/shiva): modern C++ engine with
    modularity.
  * [ImGui/EnTT editor](https://github.com/Green-Sky/imgui_entt_entity_editor):
    a drop-in, single-file entity editor for `EnTT` that uses `ImGui` as
    graphical backend (with
    [demo code](https://github.com/Green-Sky/imgui_entt_entity_editor_demo)).
  * [SgOgl](https://github.com/stwe/SgOgl): a game engine library for OpenGL
    developed for educational purposes.
  * [Lumos](https://github.com/jmorton06/Lumos): game engine written in C++
    using OpenGL and Vulkan.
  * [Silvanus](https://github.com/hobbyistmaker/silvanus): Silvanus Fusion 360
    Box Generator.
  * [Lina Engine](https://github.com/inanevin/LinaEngine): an open-source,
    modular, tiny and fast C++ game engine, aimed to develop 3D desktop games.
  * [Spike](https://github.com/FahimFuad/Spike): a powerful game engine which
    can run on a toaster.
  * [Helena Framework](https://github.com/NIKEA-SOFT/HelenaFramework): a modern
    framework in C++17 for backend development.
  * [Unity/EnTT](https://github.com/TongTungGiang/unity-entt): tech demo of a
    native simulation layer using `EnTT` and `Unity` as a rendering engine.
  * [OverEngine](https://github.com/OverShifted/OverEngine): an over-engineered
    game engine.
  * [Electro](https://github.com/Electro-Technologies/Electro): high performance
    3D game engine with a high emphasis on rendering.
  * [Kawaii](https://github.com/Mathieu-Lala/Kawaii_Engine): a modern data
    oriented game engine.
  * [Becketron](https://github.com/Doctor-Foxling/Becketron): a game engine
    written mostly in C++.
  * [Spatial Engine](https://github.com/luizgabriel/Spatial.Engine): a
    cross-platform engine created on top of google's filament rendering engine.
  * [Kaguya](https://github.com/KaiH0717/Kaguya): D3D12 Rendering Engine.
  * [OpenAWE](https://github.com/OpenAWE-Project/OpenAWE): open implementation
    of the Alan Wake Engine.
  * [Nazara Engine](https://github.com/DigitalPulseSoftware/NazaraEngine): fast,
    cross-platform, object-oriented API to help in daily developer life.
  * [Billy Engine](https://github.com/billy4479/BillyEngine): some kind of a 2D
    engine based on `SDL2` and `EnTT`.
  * [Ducktape](https://github.com/DucktapeEngine/Ducktape): an open source C++
    2D & 3D game engine that focuses on being fast and powerful.
  * [The Worst Engine](https://github.com/Parasik72/TWE): a game engine based on
    OpenGL.
  * [Ecsact](https://ecsact.dev/): a language aimed at describing ECS, with a
    [runtime implementation](https://github.com/ecsact-dev/ecsact_rt_entt) based
    on `EnTT`.
  * [AGE (Arc Game Engine)](https://github.com/MohitSethi99/ArcGameEngine): an
    open-source engine for building 2D & 3D real-time rendering and interactive
    contents.
  * [Kengine](https://github.com/phisko/kengine): the _Koala engine_ is a game
    engine entirely implemented as an entity-component-system.
  * [Scion2D](https://github.com/dwjclark11/Scion2D): 2D game engine with
    [YouTube series](https://www.youtube.com/playlist?list=PL3HUvSWOJR7XRDwVVQqqWO-zyyscb8L-v)
    included.
  * [EnTT Editor](https://github.com/TheDimin/EnttEditor): an editor for `EnTT`
    libary that combines its built-in reflection system with `ImGui`.
  * [Era Game Engine](https://github.com/EldarMuradov/EraGameEngine): a modern
    ECS-based game engine.
  * [Core SDK of Trollworks engine](https://github.com/trollworks/sdk-core): 2D
    game engine based on procrastination.
  * [Rocky](https://github.com/pelicanmapping/rocky): 3D geospatial application
    engine.
  * [Donner](https://github.com/jwmcglynn/donner): a modern C++20 SVG2 rendering
    API with CSS3.
  * [Coral Engine](https://github.com/GuusKemperman/CoralEngine): open-source
    student engine with the tools to make games in C++ and Visual scripting.

## Articles, videos and blog posts:

  * [Some posts](https://skypjack.github.io/tags/#entt) on my personal
    [blog](https://skypjack.github.io/) are about `EnTT`, for those who want to
    know **more** on this project.
  * [Game Engine series](https://www.youtube.com/c/TheChernoProject/videos) by
    [The Cherno](https://github.com/TheCherno) (not only about `EnTT` but also
    on the use of an ECS in general):
    - [Intro to EnTT](https://www.youtube.com/watch?v=D4hz0wEB978).
    - [Entities and Components](https://www.youtube.com/watch?v=-B1iu4QJTUc).
    - [The ENTITY Class](https://www.youtube.com/watch?v=GfSzeAcsBb0).
    - [Camera Systems](https://www.youtube.com/watch?v=ubZn7BlrnTU).
    - [Scene Camera](https://www.youtube.com/watch?v=UKVFRRufKzo).
    - [Native Scripting](https://www.youtube.com/watch?v=iIUhg88MK5M).
    - [Native Scripting (now with virtual functions!)](https://www.youtube.com/watch?v=1cHEcrIn8IQ).
    - [Scene Hierarchy Panel](https://www.youtube.com/watch?v=wziDnE8guvI).
    - [Properties Panel](https://www.youtube.com/watch?v=NBpB0qscF3E).
    - [Camera Component UI](https://www.youtube.com/watch?v=RIMt_6agUiU).
    - [Drawing Component UI](https://www.youtube.com/watch?v=u3yq8s3KuSE).
    - [Transform Component UI](https://www.youtube.com/watch?v=8JqcXYbzPJc).
    - [Adding/Removing Entities and Components UI](https://www.youtube.com/watch?v=PsyGmsIgp9M).
    - [Saving and Loading Scenes](https://www.youtube.com/watch?v=IEiOP7Y-Mbc).
    - ... And so on.
      [Check out](https://www.youtube.com/channel/UCQ-W1KE9EYfdxhL6S4twUNw) the
      _Game Engine Series_ by The Cherno for more videos.
  * [Game Engine series](https://www.youtube.com/@JADE-iteGames/videos) by
    [dwjclark11](https://github.com/dwjclark11) (not just `EnTT` but a lot of
    it):
    - [Getting into ECS](https://youtu.be/k9CbonLopJU?si=za3Tisyc96_92DWM)
    - [Creating ECS Wrapper Classes](https://youtu.be/yetyuMJRdbo?si=PJTkmap4Ysqbzb_M)
    - [Runtime Reflection using EnTT meta](https://youtu.be/GrXV5A07GTY?si=fKdWTj9AOhnhtiXq)
    - [Adding entt::meta and Sol2 bindings](https://youtu.be/IM55JgxOqFA?si=rsbb4AG_NVh4IUmD)
      (with [part two](https://youtu.be/-PTt-b1tzRw?si=zPJ4vEluyheMcNgO) too)
    - ... And so on.
      [Check it out](https://www.youtube.com/playlist?list=PL3HUvSWOJR7XRDwVVQqqWO-zyyscb8L-v)
      for more videos.
  * [Warmonger Dynasty devlog series](https://david-delassus.medium.com/list/warmonger-dynasty-devlogs-f64b71f556de)
    by [linkdd](https://github.com/linkdd): an interesting walkthrough of
    developing a game (also) with EnTT.
  * [Use EnTT When You Need An ECS](https://www.codingwiththomas.com/blog/use-entt-when-you-need-an-ecs)
    by [Thomas](https://www.codingwiththomas.com/): I couldn't have said it
    better.
  * [Space Battle: Huge edition](http://victor.madtriangles.com/code%20experiment/2018/06/11/post-ecs-battle-huge.html):
    huge space battle built entirely from scratch.
  * [Space Battle](https://github.com/vblanco20-1/ECS_SpaceBattle): huge space
    battle built on `UE4`.
  * [Experimenting with ECS in UE4](http://victor.madtriangles.com/code%20experiment/2018/03/25/post-ue4-ecs-battle.html):
    interesting article about `UE4` and `EnTT`.
  * [Implementing ECS architecture in UE4](https://forums.unrealengine.com/development-discussion/c-gameplay-programming/1449913-implementing-ecs-architecture-in-ue4-giant-space-battle):
    giant space battle.
  * [Conan Adventures (SFML and EnTT in C++)](https://leinnan.github.io/blog/conan-adventuressfml-and-entt-in-c.html):
    create projects in modern C++ using `SFML`, `EnTT`, `Conan` and `CMake`.
  * [Adding EnTT ECS to Chrysalis](https://www.tauradius.com/post/adding-an-ecs-to-chrysalis/):
    a blog entry (and its 
    [follow-up](https://www.tauradius.com/post/chrysalis-update-2020-08-02/)) 
    about the integration of `EnTT` into `Chrysalis`, an action RPG SDK for
    CRYENGINE games.
  * [Creating Minecraft in One Week with C++ and Vulkan](https://vazgriz.com/189/creating-minecraft-in-one-week-with-c-and-vulkan/):
    a crack at recreating Minecraft in one week using a custom C++ engine and
    Vulkan ([code included](https://github.com/vazgriz/VoxelGame)).
  * [Ability Creator](https://www.erichildebrand.net/blog/ability-creator-project-retrospect):
    project retrospect by [Eric Hildebrand](https://www.erichildebrand.net/).
  * [EnTT Entity Component System Gaming Library](https://gamefromscratch.com/entt-entity-component-system-gaming-library/):
    `EnTT` on GameFromScratch.com.
  * [Custom C++ server for UE5](https://youtu.be/fbXZVNCOvjM) optimized for
    MMO(RPG)s and its [follow-up](https://youtu.be/yGlZeopx2hU) episode about
    player bots and full external ECS: a series definitely worth looking at.

## Any Other Business:

  * [ArcGIS Runtime SDKs](https://developers.arcgis.com/arcgis-runtime/) by
    [Esri](https://www.esri.com/): they use `EnTT` for the internal ECS and the
    cross platform C++ rendering engine. The SDKs are utilized by a lot of
    enterprise custom apps, as well as by Esri for its own public applications
    such as
    [Explorer](https://play.google.com/store/apps/details?id=com.esri.explorer),
    [Collector](https://play.google.com/store/apps/details?id=com.esri.arcgis.collector)
    and
    [Navigator](https://play.google.com/store/apps/details?id=com.esri.navigator).
  * [FASTSUITE Edition 2](https://www.fastsuite.com/en_EN/fastsuite/fastsuite-edition-2.html)
    by [Cenit](http://www.cenit.com/en_EN/about-us/overview.html): they use
    `EnTT` to drive their simulation, that is, the communication between robot
    controller emulator and renderer.
  * [Ragdoll](https://ragdolldynamics.com/): real-time physics for Autodesk Maya
    2020.
  * [Project Lagrange](https://github.com/adobe/lagrange): a robust geometry
    processing library by [Adobe](https://github.com/adobe).
  * [AtomicDEX](https://github.com/KomodoPlatform/atomicDEX-Desktop): a secure
    wallet and non-custodial decentralized exchange rolled into one application.
  * [Apparently](https://www.linkedin.com/in/skypjack/)
    [NIO](https://www.nio.io/): there was a collaboration to make some changes
    to `EnTT`, at the time used for internal projects.
  * [Apparently](https://www.linkedin.com/jobs/view/architekt-c%2B%2B-at-tieto-1219512333/)
    [Tieto](https://www.tieto.com/): they published a job post where `EnTT` was
    listed on their software stack.
  * [Sequentity](https://github.com/alanjfs/sequentity): A MIDI-like
    sequencer/tracker for C++ and `ImGui` (with `Magnum` and `EnTT`).
  * [EnTT meets Sol2](https://github.com/skaarj1989/entt-meets-sol2): freely
    available examples of how to combine `EnTT` and `Sol2`.
  * [Godot meets EnTT](https://github.com/portaloffreedom/godot_entt_example/):
    a simple example on how to use `EnTT` within
    [`Godot`](https://godotengine.org/).
  * [Godot and GameNetworkingSockets meet EnTT](https://github.com/portaloffreedom/godot_entt_net_example):
    a simple example on how to use `EnTT` and
    [`GameNetworkingSockets`](https://github.com/ValveSoftware/GameNetworkingSockets)
    within [`Godot`](https://godotengine.org/).
  * [MatchOneEntt](https://github.com/mhaemmerle/MatchOneEntt): port of
    [Match One](https://github.com/sschmid/Match-One) for `Entitas-CSharp`.
  * GitHub contains also
    [many other examples](https://github.com/search?o=desc&q=%22skypjack%2Fentt%22&s=indexed&type=Code)
    of use of `EnTT` from which to take inspiration if interested.
