---
sidebar_position: 26
---

# W0026 - Unexported function

## Error

```erlang
  main() ->
    dep:public(),
    dep:private().
%%  ^^^^^^^^^^^^^^^^ 💡 warning: Function 'dep:private/0' is not exported.
```

## Explanation

The warning message indicates that the invoked function exists in the target module but is not exported.

The problem could be due to missing export for the function, to misspelling, to the wrong number of arguments passed to the function or to a dependency change.

To fix the problem you should verify whether the invoked function is the one you want to call and export it from the dependent module. Remember that in Erlang a function is identified by its name **and** the number of arguments it takes.

In case of false positives, the [standard `elp:ignore` mechanism](../erlang-error-index.md#ignoring-diagnostics) should be used. Please report this as a bug should this be the case.
