---
sidebar_position: 21
---

# W0021 - Cannot Evaluate Common Test Callbacks

## Error

```erlang
   -module(my_SUITE).~

   -export([all/0]).
   -export([a/1]).

   all() -> my_external_helper:all().
%% ^^^ warning: Could not evaluate function. No code lenses for tests will be available.

   a(_Config) ->
     ok.
```

## Explanation

The error indicates that the `all/0` and/or the `groups/0` callback functions could not be evaluated successfully by the ELP language server, resulting in a degraded IDE experience. This can happen in two cases:

* The test suite has significant compilation times (i.e. several seconds)
* The `all/0` or `groups/0` function contain code which depends on external modules, a scenario currently not supported by ELP

**The warning only indicates a degradation for the IDE experience where certain features won't be available**, such as the `Debug/Run` code lenses and CT diagnostics such as the [Unreachable Test Case](./W0008.md) one.

When encountering the warning, you should considering simplifying or splitting your test suite.
