---
sidebar_position: 12
---

# W0012 - Missing `warn_missing_spec` compiler attribute

## Error

```erlang
   -module(main).

   -compile([export_all, nowarn_export_all]).
%% ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ error: Please add "-compile(warn_missing_spec)." or
%%                                          | "-compile(warn_missing_spec_all)." to the module.
%%                                          | If exported functions are not all specced, they need to be specced.
```

## Explanation

The error is indicating that the given module does not have a `warn_missing_spec` or `warn_missing_spec_all` compiler attribute but it should have one.

This diagnostic can be particularly useful for large code bases where type information (via `-spec` attributes) are added incrementally and it's not possible to specify the option globally.

To fix this warning you can add one of the following compiler attributes:

```erlang
-compile(warn_missing_spec). %% To enable warnings on exported functions only
-compile(warn_missing_spec_all). %% To enable warnings on all functions
```

Notice that multiple compiler attributes can be listed using the same attribute. For example:

```erlang
-compile([export_all, nowarn_export_all, warn_missing_spec]).
```

For more information about compiler attributes and their meaning see [here](https://www.erlang.org/doc/man/compile).
