---
sidebar_position: 11
---

# W0011 - Application Get Env

## Error

```erlang title="/app_a/src/main.erl"
-module(main).

get_app_b_env() ->
    application:get_env(app_b, key).
%%  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ warning: module `main` belongs to app `app_a`, but reads env for `app_b`
```

## Explanation

The error message is indicating that a module belonging to an application `app_a` is attempting at reading the environment for a different application `app_b`.

Erlang provides an [API](https://www.erlang.org/doc/man/application#get_env-2) to access the application environment of a different application from the one the calling module (or, to be more precise, the calling process executing that module) belongs to.

This pattern can lead to subtle bugs since the target application (`app_b` in the above example) could not yet be loaded at the time of the call or it could be missing from a specific [release](https://www.erlang.org/doc/design_principles/release_structure.html).

Sometimes accessing another application's environment is a totally acceptable behaviour. In those cases, the warning can be silenced via the [standard `elp:ignore` mechanirm](../erlang-error-index.md#ignoring-diagnostics).
