---
sidebar_position: 8
---

# W0008 - Unreachable Test

## Error

```erlang
   -module(my_SUITE).
   -export([all/0]).
   -export([a/1, b/1]).
   all() -> [a].
   a(_Config) ->
     ok.
   b(_Config) ->
%% ^ warning: Unreachable test (b/1)
     ok.
```

## Explanation

The error message is indicating that the `b` test case is not _reachable_ by the [Common Test](https://www.erlang.org/doc/man/common_test.html) testing framework and that it won't be executed by the testing framework.

In _Common Test_, test cases are auto-discovered by the framework via the `all/0` and `groups/1` function.

A function is deemed an _unreachable test_ if:

* the function belongs to a module name ending with `_SUITE`
* the function has arity `1`
* the function is exported
* the function is not a Common Test callback function (i.e. `init_per_suite/1`, `end_per_suite/1` or `group/1`)
* the function is not a callback implementation of an included behaviour
* the function is not reachable via the `all/0` and `group/0` functions and it is therefore not executed by the Erlang Common Test framework.

In the above snippet, the `b/1` function falls into that category since all of the above apply.

To fix this warning you should either remove the test cases (if not necessary any longer) or make it reachable via the `all/0` function.

Sometimes it is intentional to have test cases which are defined but not running (e.g. they are occasionally run manually). In such case you can silent the warning by using an ELP [ignore annotation](../erlang-error-index.md#ignoring-diagnostics).
