---
sidebar_position: 5
---

# W0005 - Mutable Variable Bug

## Error

```erlang
-module(main).
-export([test/0]).
test() ->
    Zero = 0,
    One = 1,

    Result = One = Zero,
%%  ^^^^^^^^^^^^^^^^^^^ error: Possible mutable variable bug

    io:format("~p ~p~n", [Zero, One]),
    Result.
```

## Explanation

The error message indicates that this specific pattern could trigger a [known bug](https://github.com/erlang/otp/issues/6873) with certain OTP releases. Earlier (i.e. < OTP 26) Erlang releases were affected by a subtle bug which caused the _pattern matching_ operator to incorrectly mutate variables.

By compiling the above snippet on one of the problematic releases you'd get:

```erlang
1> test:test().
0 0
0
```

The code should have crashed with a _pattern match_ error. Instead, the variable `One` mutated from the original value `1` to the value `0`.
