---
sidebar_position: 3
---

# W0003 - Unused Record Field

## Error

```erlang
-module(main).

-export([main/1]).

-record(used_field, {field_a, field_b = 42}).
-record(unused_field, {field_c, field_d}).
                             %% ^^^^^^^ warning: Unused record field (unused_field.field_d)

main(#used_field{field_a = A, field_b = B}) ->
    {A, B};
main(R) ->
    R#unused_field.field_c.
```

## Explanation

The error message is indicating that the field `field_d` in the record `unused_field` is defined but not used anywhere in the code.

In Erlang, records are a way to define a data structure with named fields. However, if a field is defined but not used, it is considered _unused_ and will generate a warning when the code is compiled.

To fix this warning, you should either use the field somewhere in the code or remove the definition of the field if it is no longer needed.
It's worth noting that the field `field_c` in the same record is being used in the function `main/1`, so it's not considered unused.
