---
sidebar_position: 0
---

# W0000 - Bound Variable in Pattern

## Error

:::caution

This error code is not emitted any longer. [Semantic tokens](../../feature-gallery.mdx#semantic-syntax-highlighting) are used instead.

:::

## Explanation

Inspired by Elixir's [pinning operator](https://elixir-lang.org/getting-started/pattern-matching.html#the-pin-operator), this diagnostic marks variables in patterns, if they are already bound. This can be problematic if the binding is not intentional and it can lead to subtle bugs.

Consider the following code snippet:

```erlang showLineNumbers
handle_request(Message) ->
  case next_action() of
    {send, Message} ->
      ...
    {error, Error}
      ...
  end
```

The pattern on line `3` will only be matched if and only if the `Message` returned by the call to `next_action/1` is the same as the one on line `1`. This behaviour could be intentional or not. If not, it can easily lead to bugs.

An alternative, more explicit, way to express that behaviour - when intentional - could be:

```erlang showLineNumbers
handle_request(Message) ->
  case next_action() of
    {send, ActionMessage} when ActionMessage =:= Message ->
      ...
    {error, Error}
      ...
  end
```
