---
sidebar_position: 227
---

# L1227 - Undefined Function

## Error

```erlang
  main() ->
    exists(),
    not_exists().
%%  ^^^^^^^^^^^^ 💡 warning: Function 'not_exists/0' is undefined.
```

## Explanation

The warning message indicates that the invoked function cannot be found.

The problem is usually due to misspelling, to the wrong number of arguments passed to the function, or to a recent removal of the target function.

To fix the problem you should verify whether the invoked function actually exists and has the correct _arity_. Remember that in Erlang a function is identified by its name **and** the number of arguments it takes.

In case of false positives, the [standard `elp:ignore` mechanism](../erlang-error-index.md#ignoring-diagnostics) should be used. Please report this as a bug should this be the case.

This diagnostic is limited to local function calls (i.e. function calls which do not specify the module name), since fully qualified (aka remote) calls to undefined functions are reported by [W0017](../w/W0017.md).
