/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under both the MIT license found in the
 * LICENSE-MIT file in the root directory of this source tree and the Apache
 * License, Version 2.0 found in the LICENSE-APACHE file in the root directory
 * of this source tree.
 */

use std::fmt;

use elp_syntax::TextRange;

#[derive(Debug, PartialEq, Eq, Clone)]
pub struct Diagnostic {
    pub location: TextRange,
    pub message: DiagnosticMessage,
}

#[derive(Debug, PartialEq, Eq, Clone)]
pub enum DiagnosticMessage {
    VarNameOutsideMacro,
}

impl fmt::Display for DiagnosticMessage {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        match self {
            DiagnosticMessage::VarNameOutsideMacro => {
                write!(
                    f,
                    "using variable instead of an atom name is allowed only inside -define"
                )
            }
        }
    }
}
