---
sidebar_position: 13
---

# W0013 - Misspelled Attribute

## Error

```erlang
  -dyalizer({nowarn_function, f/0}).
%% ^^^^^^^^ error: misspelled attribute, saw 'dyalizer' but expected 'dialyzer'
```

## Explanation

The message is indicating that the attribute name is suspiciously similar to a _known_ one and it could therefore contain a typo.

To fix the error either correct the attribute spelling or ignore the warning via [the standard `elp:ignore` mechanism](../erlang-error-index.md#ignoring-diagnostics).
