---
sidebar_position: 1
---

# W0001 - Module Mismatch

## Error

```erlang
-module(bar).
%%      ^^^ error: Module name (bar) does not match file name (foo)
```

## Explanation

The error message is indicating that the module name specified in the `-module` attribute (`bar`) does not match the file name of the source code file (`foo.erl`).

In Erlang, the module name - an atom - has to be same as the file name minus the extension `.erl`. This is to ensure code loading works as intended.

To fix this error, you should either change the `-module` directive to match the file name (i.e. `-module(foo)`) or rename the file to match the module name (i.e. `foo.erl -> bar.erl`).
