---
sidebar_position: 6
---

# O0006 - ``` `` ``` Quote ended unexpectedly

## Error

```erlang
    %% @doc To execute the program, call `main`
    %% Here is some code:
    %% `` 'erlang@localhost' ``
%%  ^^^^^^^^^^^^^^^^^^^^^^^^^^^ warning: ``-quote ended unexpectedly
    main() ->
      ok.
```

## Explanation

Double back-quotes in EDoc are used to quote text containing single `'` characters.
If you are getting this error, you are most likely using _markdown-style_ monospace quoting instead of _EDoc's_ monospace quotes. To fix the error, replace the last occurrence of ``` `` ``` with `` '' ``:

```erlang
    %% @doc To execute the program, call `main`
    %% Here is some code:
    %% `` 'erlang@localhost' ''
    main() ->
      ok.
```

You can read more about verbatim quoting in EDoc [here](https://www.erlang.org/doc/apps/edoc/chapter.html#verbatim-quoting).
