---
sidebar_position: 309
---

# L1309 - Missing function specification

## Error

```erlang
    foo() -> ok.
%%  ^^^ 💡 warning: missing specification for function foo/0.
```

## Explanation

The warning message indicates that a specification for the specified function could not be found.

To fix it, add a `-spec` annotation to the function, such as:

```erlang
-spec foo() -> atom().
foo() -> ok.
```
