Code.require_file "../../test_helper.exs", __DIR__

defmodule Mix.Tasks.DoTest do
  use MixTest.Case

  test "runs given tasks", context do
    in_tmp context.test, fn ->
      Mix.Tasks.Do.run ["compile", "--list,", "help"]
      assert_received {:mix_shell, :info, ["mix help" <> _]}
      assert_received {:mix_shell, :info, ["mix compile.app" <> _]}
    end
  end

  test "gather_command ignore spaces and trailing commas" do
    import Mix.Tasks.Do, only: [gather_commands: 1]
    assert gather_commands(["compile", "--list,", "help"]) == [["compile", "--list"], ["help"]]
    assert gather_commands(["compile", "--list,help"]) == [["compile", "--list"], ["help"]]
    assert gather_commands(["help", ",compile", "--list"]) == [["help"], ["compile", "--list"]]
    assert gather_commands(["compile", "--list", ",", "help"]) == [["compile", "--list"], ["help"]]
    assert gather_commands(["compile,", "run", "-e", "IO.puts :hello"]) == [["compile"], ["run", "-e", "IO.puts :hello"]]
    assert gather_commands(
      [",", "compile,", "run", "-e", "IO.puts :hello",",foo", "--bar", "--baz", ",", "baz,qux,abc", ","]) ==
      [["compile"], ["run", "-e", "IO.puts :hello"], ["foo", "--bar", "--baz"], ["baz"], ["qux"], ["abc"]]
  end
end
