/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.joda.JodaDeprecationPatterns;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;

public class IndexDeprecationChecks {
    private static final Set<String> TYPES_THAT_DONT_COUNT;

    private static void fieldLevelMappingIssue(IndexMetaData indexMetaData, BiConsumer<MappingMetaData, Map<String, Object>> checker) {
        for (ObjectCursor mappingMetaData : indexMetaData.getMappings().values()) {
            Map sourceAsMap = ((MappingMetaData)mappingMetaData.value).sourceAsMap();
            checker.accept((MappingMetaData)mappingMetaData.value, sourceAsMap);
        }
    }

    static List<String> findInPropertiesRecursively(String type, Map<String, Object> parentMap, Function<Map<?, ?>, Boolean> predicate, BiFunction<String, Map.Entry<?, ?>, String> fieldFormatter) {
        ArrayList<String> issues = new ArrayList<String>();
        Map properties = (Map)parentMap.get("properties");
        if (properties == null) {
            return issues;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Map values;
            Map valueMap = (Map)entry.getValue();
            if (predicate.apply(valueMap).booleanValue()) {
                issues.add("[" + fieldFormatter.apply(type, entry) + "]");
            }
            if ((values = (Map)valueMap.get("fields")) != null) {
                for (Map.Entry multifieldEntry : values.entrySet()) {
                    Map multifieldValueMap = (Map)multifieldEntry.getValue();
                    if (predicate.apply(multifieldValueMap).booleanValue()) {
                        issues.add("[" + fieldFormatter.apply(type, entry) + ", multifield: " + multifieldEntry.getKey() + "]");
                    }
                    if (!multifieldValueMap.containsKey("properties")) continue;
                    issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, multifieldValueMap, predicate, fieldFormatter));
                }
            }
            if (!valueMap.containsKey("properties")) continue;
            issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(type, valueMap, predicate, fieldFormatter));
        }
        return issues;
    }

    private static String formatDateField(String type, Map.Entry<?, ?> entry) {
        Map value = (Map)entry.getValue();
        return "type: " + type + ", field: " + entry.getKey() + ", format: " + value.get("format") + ", suggestion: " + JodaDeprecationPatterns.formatSuggestion((String)((String)value.get("format")));
    }

    private static String formatField(String type, Map.Entry<?, ?> entry) {
        return "type: " + type + ", field: " + entry.getKey();
    }

    static DeprecationIssue oldIndicesCheck(IndexMetaData indexMetaData) {
        Version createdWith = indexMetaData.getCreationVersion();
        if (createdWith.before(Version.V_7_0_0)) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Index created before 7.0", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-8.0.html", "This index was created using version: " + createdWith);
        }
        return null;
    }

    static DeprecationIssue tooManyFieldsCheck(IndexMetaData indexMetaData) {
        if (indexMetaData.getSettings().get(IndexSettings.DEFAULT_FIELD_SETTING.getKey()) == null) {
            AtomicInteger fieldCount = new AtomicInteger(0);
            IndexDeprecationChecks.fieldLevelMappingIssue(indexMetaData, (mappingMetaData, sourceAsMap) -> fieldCount.addAndGet(IndexDeprecationChecks.countFieldsRecursively(mappingMetaData.type(), sourceAsMap)));
            if (fieldCount.get() > 1024) {
                return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Number of fields exceeds automatic field expansion limit", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#_limiting_the_number_of_auto_expanded_fields", "This index has [" + fieldCount.get() + "] fields, which exceeds the automatic field expansion limit of 1024 and does not have [" + IndexSettings.DEFAULT_FIELD_SETTING.getKey() + "] set, which may cause queries which use automatic field expansion, such as query_string, simple_query_string, and multi_match to fail if fields are not explicitly specified in the query.");
            }
        }
        return null;
    }

    static DeprecationIssue deprecatedDateTimeFormat(IndexMetaData indexMetaData) {
        Version createdWith = indexMetaData.getCreationVersion();
        if (createdWith.before(Version.V_7_0_0)) {
            ArrayList fields = new ArrayList();
            IndexDeprecationChecks.fieldLevelMappingIssue(indexMetaData, (mappingMetaData, sourceAsMap) -> fields.addAll(IndexDeprecationChecks.findInPropertiesRecursively(mappingMetaData.type(), sourceAsMap, IndexDeprecationChecks::isDateFieldWithDeprecatedPattern, IndexDeprecationChecks::formatDateField)));
            if (fields.size() > 0) {
                return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Date field format uses patterns which has changed meaning in 7.0", "https://www.elastic.co/guide/en/elasticsearch/reference/7.0/breaking-changes-7.0.html#breaking_70_java_time_changes", "This index has date fields with deprecated formats: " + fields + ". " + "Use new java.time date format specifiiers.");
            }
        }
        return null;
    }

    private static boolean isDateFieldWithDeprecatedPattern(Map<?, ?> property) {
        return "date".equals(property.get("type")) && property.containsKey("format") && JodaDeprecationPatterns.isDeprecatedPattern((String)((String)property.get("format")));
    }

    static DeprecationIssue chainedMultiFieldsCheck(IndexMetaData indexMetaData) {
        ArrayList issues = new ArrayList();
        IndexDeprecationChecks.fieldLevelMappingIssue(indexMetaData, (mappingMetaData, sourceAsMap) -> issues.addAll(IndexDeprecationChecks.findInPropertiesRecursively(mappingMetaData.type(), sourceAsMap, IndexDeprecationChecks::containsChainedMultiFields, IndexDeprecationChecks::formatField)));
        if (issues.size() > 0) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Multi-fields within multi-fields", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-8.0.html#_defining_multi_fields_within_multi_fields", "The names of fields that contain chained multi-fields: " + ((Object)issues).toString());
        }
        return null;
    }

    private static boolean containsChainedMultiFields(Map<?, ?> property) {
        if (property.containsKey("fields")) {
            Map fields = (Map)property.get("fields");
            for (Object rawSubField : fields.values()) {
                Map subField = (Map)rawSubField;
                if (!subField.containsKey("fields")) continue;
                return true;
            }
        }
        return false;
    }

    static int countFieldsRecursively(String type, Map<String, Object> parentMap) {
        int fields = 0;
        Map properties = (Map)parentMap.get("properties");
        if (properties == null) {
            return fields;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Map values;
            Map valueMap = (Map)entry.getValue();
            if (valueMap.containsKey("type") && !(valueMap.get("type").equals("object") && !valueMap.containsKey("properties")) && !TYPES_THAT_DONT_COUNT.contains(valueMap.get("type"))) {
                ++fields;
            }
            if ((values = (Map)valueMap.get("fields")) != null) {
                for (Map.Entry multifieldEntry : values.entrySet()) {
                    Map multifieldValueMap = (Map)multifieldEntry.getValue();
                    if (multifieldValueMap.containsKey("type") && !TYPES_THAT_DONT_COUNT.contains(valueMap.get("type"))) {
                        ++fields;
                    }
                    if (!multifieldValueMap.containsKey("properties")) continue;
                    fields += IndexDeprecationChecks.countFieldsRecursively(type, multifieldValueMap);
                }
            }
            if (!valueMap.containsKey("properties")) continue;
            fields += IndexDeprecationChecks.countFieldsRecursively(type, valueMap);
        }
        return fields;
    }

    static DeprecationIssue translogRetentionSettingCheck(IndexMetaData indexMetaData) {
        boolean softDeletesEnabled = (Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(indexMetaData.getSettings());
        if (softDeletesEnabled && (IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.exists(indexMetaData.getSettings()) || IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.exists(indexMetaData.getSettings()))) {
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "translog retention settings are ignored", "https://www.elastic.co/guide/en/elasticsearch/reference/current/index-modules-translog.html", "translog retention settings [index.translog.retention.size] and [index.translog.retention.age] are ignored because translog is no longer used in peer recoveries with soft-deletes enabled (default in 7.0 or later)");
        }
        return null;
    }

    static {
        HashSet<String> typesThatDontCount = new HashSet<String>();
        typesThatDontCount.add("binary");
        typesThatDontCount.add("geo_point");
        typesThatDontCount.add("geo_shape");
        TYPES_THAT_DONT_COUNT = Collections.unmodifiableSet(typesThatDontCount);
    }
}

