/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.time.OffsetTime;
import java.time.ZonedDateTime;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.GeoShape;
import org.elasticsearch.xpack.sql.expression.literal.Interval;
import org.elasticsearch.xpack.sql.type.DataType;

public final class DataTypes {
    private DataTypes() {
    }

    public static boolean isNull(DataType from) {
        return from == DataType.NULL;
    }

    public static boolean isUnsupported(DataType from) {
        return from == DataType.UNSUPPORTED;
    }

    public static DataType fromJava(Object value) {
        if (value == null) {
            return DataType.NULL;
        }
        if (value instanceof Integer) {
            return DataType.INTEGER;
        }
        if (value instanceof Long) {
            return DataType.LONG;
        }
        if (value instanceof Boolean) {
            return DataType.BOOLEAN;
        }
        if (value instanceof Double) {
            return DataType.DOUBLE;
        }
        if (value instanceof Float) {
            return DataType.FLOAT;
        }
        if (value instanceof Byte) {
            return DataType.BYTE;
        }
        if (value instanceof Short) {
            return DataType.SHORT;
        }
        if (value instanceof OffsetTime) {
            return DataType.TIME;
        }
        if (value instanceof ZonedDateTime) {
            return DataType.DATETIME;
        }
        if (value instanceof String || value instanceof Character) {
            return DataType.KEYWORD;
        }
        if (value instanceof Interval) {
            return ((Interval)value).dataType();
        }
        if (value instanceof GeoShape) {
            return DataType.GEO_SHAPE;
        }
        throw new SqlIllegalArgumentException("No idea what's the DataType for {}", value.getClass());
    }

    public static boolean isInterval(DataType type) {
        int ordinal = type.ordinal();
        return ordinal >= DataType.INTERVAL_YEAR.ordinal() && ordinal <= DataType.INTERVAL_MINUTE_TO_SECOND.ordinal();
    }

    public static DataType compatibleInterval(DataType left, DataType right) {
        if (left == right) {
            return left;
        }
        if (DataTypes.isYearMonthInterval(left) && DataTypes.isYearMonthInterval(right)) {
            return DataType.INTERVAL_YEAR_TO_MONTH;
        }
        if (DataTypes.isDayTimeInterval(left) && DataTypes.isDayTimeInterval(right)) {
            int indexOf;
            String lName = left.name().substring(9);
            String rName = right.name().substring(9);
            char leading = lName.charAt(0);
            if (rName.charAt(0) < leading) {
                leading = rName.charAt(0);
            }
            if (lName.length() > 6) {
                indexOf = lName.indexOf("_TO_");
                lName = lName.substring(indexOf + 4);
            }
            if (rName.length() > 6) {
                indexOf = rName.indexOf("_TO_");
                rName = rName.substring(indexOf + 4);
            }
            char trailing = lName.charAt(0);
            if (rName.charAt(0) > trailing) {
                trailing = rName.charAt(0);
            }
            return DataType.fromTypeName("INTERVAL_" + DataTypes.intervalUnit(leading) + "_TO_" + DataTypes.intervalUnit(trailing));
        }
        return null;
    }

    private static boolean isYearMonthInterval(DataType type) {
        return type == DataType.INTERVAL_YEAR || type == DataType.INTERVAL_MONTH || type == DataType.INTERVAL_YEAR_TO_MONTH;
    }

    private static boolean isDayTimeInterval(DataType type) {
        int ordinal = type.ordinal();
        return ordinal >= DataType.INTERVAL_DAY.ordinal() && ordinal <= DataType.INTERVAL_SECOND.ordinal() || ordinal >= DataType.INTERVAL_DAY_TO_HOUR.ordinal() && ordinal <= DataType.INTERVAL_MINUTE_TO_SECOND.ordinal();
    }

    private static String intervalUnit(char unitChar) {
        switch (unitChar) {
            case 'D': {
                return "DAY";
            }
            case 'H': {
                return "HOUR";
            }
            case 'M': {
                return "MINUTE";
            }
            case 'S': {
                return "SECOND";
            }
        }
        throw new SqlIllegalArgumentException("Unknown unit {}", Character.valueOf(unitChar));
    }

    public static Integer metaSqlDataType(DataType t) {
        if (t == DataType.DATETIME) {
            return 9;
        }
        return t.sqlType.getVendorTypeNumber();
    }

    public static Integer metaSqlDateTimeSub(DataType t) {
        if (t == DataType.DATETIME) {
            return 3;
        }
        return 0;
    }

    public static Short metaSqlMinimumScale(DataType t) {
        return DataTypes.metaSqlSameScale(t);
    }

    public static Short metaSqlMaximumScale(DataType t) {
        return DataTypes.metaSqlSameScale(t);
    }

    private static Short metaSqlSameScale(DataType t) {
        if (t.isInteger()) {
            return (short)0;
        }
        if (t.isDateBased() || t.isRational()) {
            return (short)t.defaultPrecision;
        }
        return null;
    }

    public static Integer metaSqlRadix(DataType t) {
        return t.isInteger() ? Integer.valueOf(10) : (t.isRational() ? Integer.valueOf(2) : null);
    }

    public static Integer precision(DataType t) {
        if (t.isNumeric()) {
            return t.defaultPrecision;
        }
        return t.displaySize;
    }

    public static boolean areTypesCompatible(DataType left, DataType right) {
        if (left == right) {
            return true;
        }
        return left == DataType.NULL || right == DataType.NULL || left.isString() && right.isString() || left.isNumeric() && right.isNumeric();
    }
}

