/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.type;

import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypes;
import org.elasticsearch.xpack.sql.util.DateUtils;

public abstract class DataTypeConversion {
    public static DataType commonType(DataType left, DataType right) {
        if (left == right) {
            return left;
        }
        if (DataTypes.isNull(left)) {
            return right;
        }
        if (DataTypes.isNull(right)) {
            return left;
        }
        if (left.isString() && right.isString()) {
            if (left == DataType.TEXT) {
                return DataType.TEXT;
            }
            return right;
        }
        if (left.isNumeric() && right.isNumeric()) {
            if (left.isInteger()) {
                if (right.isInteger()) {
                    return left.size > right.size ? left : right;
                }
                return right;
            }
            if (right.isInteger()) {
                return left;
            }
            return left.size > right.size ? left : right;
        }
        if (left.isString() && right.isNumeric()) {
            return right;
        }
        if (right.isString() && left.isNumeric()) {
            return left;
        }
        if (left == DataType.DATE && DataTypes.isInterval(right)) {
            return left;
        }
        if (right == DataType.DATE && DataTypes.isInterval(left)) {
            return right;
        }
        if (left == DataType.TIME) {
            if (right == DataType.DATE) {
                return DataType.DATETIME;
            }
            if (DataTypes.isInterval(right)) {
                return left;
            }
        }
        if (right == DataType.TIME) {
            if (left == DataType.DATE) {
                return DataType.DATETIME;
            }
            if (DataTypes.isInterval(left)) {
                return right;
            }
        }
        if (left == DataType.DATETIME) {
            if (right == DataType.DATE || right == DataType.TIME) {
                return left;
            }
            if (DataTypes.isInterval(right)) {
                return left;
            }
        }
        if (right == DataType.DATETIME) {
            if (left == DataType.DATE || left == DataType.TIME) {
                return right;
            }
            if (DataTypes.isInterval(left)) {
                return right;
            }
        }
        if (DataTypes.isInterval(left) && right.isInteger()) {
            return left;
        }
        if (DataTypes.isInterval(right) && left.isInteger()) {
            return right;
        }
        if (DataTypes.isInterval(left) && DataTypes.isInterval(right)) {
            return DataTypes.compatibleInterval(left, right);
        }
        return null;
    }

    public static boolean canConvert(DataType from, DataType to) {
        if (from == to || from == DataType.NULL) {
            return true;
        }
        return from.isPrimitive() && to.isPrimitive() && DataTypeConversion.conversion(from, to) != null;
    }

    public static Conversion conversionFor(DataType from, DataType to) {
        if (from == to) {
            return Conversion.IDENTITY;
        }
        if (to == DataType.NULL || from == DataType.NULL) {
            return Conversion.NULL;
        }
        if (from == DataType.NULL) {
            return Conversion.NULL;
        }
        Conversion conversion = DataTypeConversion.conversion(from, to);
        if (conversion == null) {
            throw new SqlIllegalArgumentException("cannot convert from [" + from.typeName + "] to [" + to.typeName + "]");
        }
        return conversion;
    }

    private static Conversion conversion(DataType from, DataType to) {
        switch (to) {
            case KEYWORD: 
            case TEXT: {
                return DataTypeConversion.conversionToString(from);
            }
            case IP: {
                return DataTypeConversion.conversionToIp(from);
            }
            case LONG: {
                return DataTypeConversion.conversionToLong(from);
            }
            case INTEGER: {
                return DataTypeConversion.conversionToInt(from);
            }
            case SHORT: {
                return DataTypeConversion.conversionToShort(from);
            }
            case BYTE: {
                return DataTypeConversion.conversionToByte(from);
            }
            case FLOAT: {
                return DataTypeConversion.conversionToFloat(from);
            }
            case DOUBLE: {
                return DataTypeConversion.conversionToDouble(from);
            }
            case DATE: {
                return DataTypeConversion.conversionToDate(from);
            }
            case TIME: {
                return DataTypeConversion.conversionToTime(from);
            }
            case DATETIME: {
                return DataTypeConversion.conversionToDateTime(from);
            }
            case BOOLEAN: {
                return DataTypeConversion.conversionToBoolean(from);
            }
        }
        return null;
    }

    private static Conversion conversionToString(DataType from) {
        if (from == DataType.DATE) {
            return Conversion.DATE_TO_STRING;
        }
        if (from == DataType.TIME) {
            return Conversion.TIME_TO_STRING;
        }
        if (from == DataType.DATETIME) {
            return Conversion.DATETIME_TO_STRING;
        }
        return Conversion.OTHER_TO_STRING;
    }

    private static Conversion conversionToIp(DataType from) {
        if (from.isString()) {
            return Conversion.STRING_TO_IP;
        }
        return null;
    }

    private static Conversion conversionToLong(DataType from) {
        if (from.isRational()) {
            return Conversion.RATIONAL_TO_LONG;
        }
        if (from.isInteger()) {
            return Conversion.INTEGER_TO_LONG;
        }
        if (from == DataType.BOOLEAN) {
            return Conversion.BOOL_TO_LONG;
        }
        if (from.isString()) {
            return Conversion.STRING_TO_LONG;
        }
        if (from == DataType.DATE) {
            return Conversion.DATE_TO_LONG;
        }
        if (from == DataType.TIME) {
            return Conversion.TIME_TO_LONG;
        }
        if (from == DataType.DATETIME) {
            return Conversion.DATETIME_TO_LONG;
        }
        return null;
    }

    private static Conversion conversionToInt(DataType from) {
        if (from.isRational()) {
            return Conversion.RATIONAL_TO_INT;
        }
        if (from.isInteger()) {
            return Conversion.INTEGER_TO_INT;
        }
        if (from == DataType.BOOLEAN) {
            return Conversion.BOOL_TO_INT;
        }
        if (from.isString()) {
            return Conversion.STRING_TO_INT;
        }
        if (from == DataType.DATE) {
            return Conversion.DATE_TO_INT;
        }
        if (from == DataType.TIME) {
            return Conversion.TIME_TO_INT;
        }
        if (from == DataType.DATETIME) {
            return Conversion.DATETIME_TO_INT;
        }
        return null;
    }

    private static Conversion conversionToShort(DataType from) {
        if (from.isRational()) {
            return Conversion.RATIONAL_TO_SHORT;
        }
        if (from.isInteger()) {
            return Conversion.INTEGER_TO_SHORT;
        }
        if (from == DataType.BOOLEAN) {
            return Conversion.BOOL_TO_SHORT;
        }
        if (from.isString()) {
            return Conversion.STRING_TO_SHORT;
        }
        if (from == DataType.DATE) {
            return Conversion.DATE_TO_SHORT;
        }
        if (from == DataType.TIME) {
            return Conversion.TIME_TO_SHORT;
        }
        if (from == DataType.DATETIME) {
            return Conversion.DATETIME_TO_SHORT;
        }
        return null;
    }

    private static Conversion conversionToByte(DataType from) {
        if (from.isRational()) {
            return Conversion.RATIONAL_TO_BYTE;
        }
        if (from.isInteger()) {
            return Conversion.INTEGER_TO_BYTE;
        }
        if (from == DataType.BOOLEAN) {
            return Conversion.BOOL_TO_BYTE;
        }
        if (from.isString()) {
            return Conversion.STRING_TO_BYTE;
        }
        if (from == DataType.DATE) {
            return Conversion.DATE_TO_BYTE;
        }
        if (from == DataType.TIME) {
            return Conversion.TIME_TO_BYTE;
        }
        if (from == DataType.DATETIME) {
            return Conversion.DATETIME_TO_BYTE;
        }
        return null;
    }

    private static Conversion conversionToFloat(DataType from) {
        if (from.isRational()) {
            return Conversion.RATIONAL_TO_FLOAT;
        }
        if (from.isInteger()) {
            return Conversion.INTEGER_TO_FLOAT;
        }
        if (from == DataType.BOOLEAN) {
            return Conversion.BOOL_TO_FLOAT;
        }
        if (from.isString()) {
            return Conversion.STRING_TO_FLOAT;
        }
        if (from == DataType.DATE) {
            return Conversion.DATE_TO_FLOAT;
        }
        if (from == DataType.TIME) {
            return Conversion.TIME_TO_FLOAT;
        }
        if (from == DataType.DATETIME) {
            return Conversion.DATETIME_TO_FLOAT;
        }
        return null;
    }

    private static Conversion conversionToDouble(DataType from) {
        if (from.isRational()) {
            return Conversion.RATIONAL_TO_DOUBLE;
        }
        if (from.isInteger()) {
            return Conversion.INTEGER_TO_DOUBLE;
        }
        if (from == DataType.BOOLEAN) {
            return Conversion.BOOL_TO_DOUBLE;
        }
        if (from.isString()) {
            return Conversion.STRING_TO_DOUBLE;
        }
        if (from == DataType.DATE) {
            return Conversion.DATE_TO_DOUBLE;
        }
        if (from == DataType.TIME) {
            return Conversion.TIME_TO_DOUBLE;
        }
        if (from == DataType.DATETIME) {
            return Conversion.DATETIME_TO_DOUBLE;
        }
        return null;
    }

    private static Conversion conversionToDate(DataType from) {
        if (from.isRational()) {
            return Conversion.RATIONAL_TO_DATE;
        }
        if (from.isInteger()) {
            return Conversion.INTEGER_TO_DATE;
        }
        if (from == DataType.BOOLEAN) {
            return Conversion.BOOL_TO_DATE;
        }
        if (from.isString()) {
            return Conversion.STRING_TO_DATE;
        }
        if (from == DataType.DATETIME) {
            return Conversion.DATETIME_TO_DATE;
        }
        return null;
    }

    private static Conversion conversionToTime(DataType from) {
        if (from.isRational()) {
            return Conversion.RATIONAL_TO_TIME;
        }
        if (from.isInteger()) {
            return Conversion.INTEGER_TO_TIME;
        }
        if (from == DataType.BOOLEAN) {
            return Conversion.BOOL_TO_TIME;
        }
        if (from.isString()) {
            return Conversion.STRING_TO_TIME;
        }
        if (from == DataType.DATE) {
            return Conversion.DATE_TO_TIME;
        }
        if (from == DataType.DATETIME) {
            return Conversion.DATETIME_TO_TIME;
        }
        return null;
    }

    private static Conversion conversionToDateTime(DataType from) {
        if (from.isRational()) {
            return Conversion.RATIONAL_TO_DATETIME;
        }
        if (from.isInteger()) {
            return Conversion.INTEGER_TO_DATETIME;
        }
        if (from == DataType.BOOLEAN) {
            return Conversion.BOOL_TO_DATETIME;
        }
        if (from.isString()) {
            return Conversion.STRING_TO_DATETIME;
        }
        if (from == DataType.DATE) {
            return Conversion.DATE_TO_DATETIME;
        }
        return null;
    }

    private static Conversion conversionToBoolean(DataType from) {
        if (from.isNumeric()) {
            return Conversion.NUMERIC_TO_BOOLEAN;
        }
        if (from.isString()) {
            return Conversion.STRING_TO_BOOLEAN;
        }
        if (from == DataType.DATE) {
            return Conversion.DATE_TO_BOOLEAN;
        }
        if (from == DataType.TIME) {
            return Conversion.TIME_TO_BOOLEAN;
        }
        if (from == DataType.DATETIME) {
            return Conversion.DATETIME_TO_BOOLEAN;
        }
        return null;
    }

    public static byte safeToByte(long x) {
        if (x > 127L || x < -128L) {
            throw new SqlIllegalArgumentException("[" + x + "] out of [byte] range");
        }
        return (byte)x;
    }

    public static short safeToShort(long x) {
        if (x > 32767L || x < -32768L) {
            throw new SqlIllegalArgumentException("[" + x + "] out of [short] range");
        }
        return (short)x;
    }

    public static int safeToInt(long x) {
        if (x > Integer.MAX_VALUE || x < Integer.MIN_VALUE) {
            throw new SqlIllegalArgumentException("[" + x + "] out of [integer] range");
        }
        return (int)x;
    }

    public static long safeToLong(double x) {
        if (x > 9.223372036854776E18 || x < -9.223372036854776E18) {
            throw new SqlIllegalArgumentException("[" + x + "] out of [long] range");
        }
        return Math.round(x);
    }

    public static Number toInteger(double x, DataType dataType) {
        long l = DataTypeConversion.safeToLong(x);
        switch (dataType) {
            case BYTE: {
                return DataTypeConversion.safeToByte(l);
            }
            case SHORT: {
                return DataTypeConversion.safeToShort(l);
            }
            case INTEGER: {
                return DataTypeConversion.safeToInt(l);
            }
        }
        return l;
    }

    public static boolean convertToBoolean(String val) {
        String lowVal = val.toLowerCase(Locale.ROOT);
        if (!Booleans.isBoolean((String)lowVal)) {
            throw new SqlIllegalArgumentException("cannot cast [" + val + "] to [boolean]");
        }
        return Booleans.parseBoolean((String)lowVal);
    }

    public static Object convert(Object value, DataType dataType) {
        DataType detectedType = DataTypes.fromJava(value);
        if (detectedType == dataType || value == null) {
            return value;
        }
        return DataTypeConversion.conversionFor(detectedType, dataType).convert(value);
    }

    public static DataType asInteger(DataType dataType) {
        if (!dataType.isNumeric()) {
            return dataType;
        }
        return dataType.isInteger() ? dataType : DataType.LONG;
    }

    public static enum Conversion {
        IDENTITY(Function.identity()),
        NULL(value -> null),
        DATE_TO_STRING(o -> DateUtils.toDateString((ZonedDateTime)o)),
        TIME_TO_STRING(o -> DateUtils.toTimeString((OffsetTime)o)),
        DATETIME_TO_STRING(o -> DateUtils.toString((ZonedDateTime)o)),
        OTHER_TO_STRING(String::valueOf),
        RATIONAL_TO_LONG(Conversion.fromDouble(DataTypeConversion::safeToLong)),
        INTEGER_TO_LONG(Conversion.fromLong(value -> value)),
        STRING_TO_LONG(Conversion.fromString(Long::valueOf, "long")),
        DATE_TO_LONG(Conversion.fromDateTime(value -> value)),
        TIME_TO_LONG(Conversion.fromTime(value -> value)),
        DATETIME_TO_LONG(Conversion.fromDateTime(value -> value)),
        RATIONAL_TO_INT(Conversion.fromDouble(value -> DataTypeConversion.safeToInt(DataTypeConversion.safeToLong(value)))),
        INTEGER_TO_INT(Conversion.fromLong(DataTypeConversion::safeToInt)),
        BOOL_TO_INT(Conversion.fromBool(value -> value != false ? 1 : 0)),
        STRING_TO_INT(Conversion.fromString(Integer::valueOf, "integer")),
        DATE_TO_INT(Conversion.fromDateTime(DataTypeConversion::safeToInt)),
        TIME_TO_INT(Conversion.fromTime(DataTypeConversion::safeToInt)),
        DATETIME_TO_INT(Conversion.fromDateTime(DataTypeConversion::safeToInt)),
        RATIONAL_TO_SHORT(Conversion.fromDouble(value -> DataTypeConversion.safeToShort(DataTypeConversion.safeToLong(value)))),
        INTEGER_TO_SHORT(Conversion.fromLong(DataTypeConversion::safeToShort)),
        BOOL_TO_SHORT(Conversion.fromBool(value -> value != false ? (short)1 : (short)0)),
        STRING_TO_SHORT(Conversion.fromString(Short::valueOf, "short")),
        DATE_TO_SHORT(Conversion.fromDateTime(DataTypeConversion::safeToShort)),
        TIME_TO_SHORT(Conversion.fromTime(DataTypeConversion::safeToShort)),
        DATETIME_TO_SHORT(Conversion.fromDateTime(DataTypeConversion::safeToShort)),
        RATIONAL_TO_BYTE(Conversion.fromDouble(value -> DataTypeConversion.safeToByte(DataTypeConversion.safeToLong(value)))),
        INTEGER_TO_BYTE(Conversion.fromLong(DataTypeConversion::safeToByte)),
        BOOL_TO_BYTE(Conversion.fromBool(value -> value != false ? (byte)1 : (byte)0)),
        STRING_TO_BYTE(Conversion.fromString(Byte::valueOf, "byte")),
        DATE_TO_BYTE(Conversion.fromDateTime(DataTypeConversion::safeToByte)),
        TIME_TO_BYTE(Conversion.fromTime(DataTypeConversion::safeToByte)),
        DATETIME_TO_BYTE(Conversion.fromDateTime(DataTypeConversion::safeToByte)),
        RATIONAL_TO_FLOAT(Conversion.fromDouble(value -> Float.valueOf((float)value))),
        INTEGER_TO_FLOAT(Conversion.fromLong(value -> Float.valueOf(value))),
        BOOL_TO_FLOAT(Conversion.fromBool(value -> Float.valueOf(value != false ? 1.0f : 0.0f))),
        STRING_TO_FLOAT(Conversion.fromString(Float::valueOf, "float")),
        DATE_TO_FLOAT(Conversion.fromDateTime(value -> Float.valueOf(value.longValue()))),
        TIME_TO_FLOAT(Conversion.fromTime(value -> Float.valueOf(value.longValue()))),
        DATETIME_TO_FLOAT(Conversion.fromDateTime(value -> Float.valueOf(value.longValue()))),
        RATIONAL_TO_DOUBLE(Conversion.fromDouble(Double::valueOf)),
        INTEGER_TO_DOUBLE(Conversion.fromLong(Double::valueOf)),
        BOOL_TO_DOUBLE(Conversion.fromBool(value -> value != false ? 1.0 : 0.0)),
        STRING_TO_DOUBLE(Conversion.fromString(Double::valueOf, "double")),
        DATE_TO_DOUBLE(Conversion.fromDateTime(Double::valueOf)),
        TIME_TO_DOUBLE(Conversion.fromTime(Double::valueOf)),
        DATETIME_TO_DOUBLE(Conversion.fromDateTime(Double::valueOf)),
        RATIONAL_TO_DATE(Conversion.toDate(RATIONAL_TO_LONG)),
        INTEGER_TO_DATE(Conversion.toDate(INTEGER_TO_LONG)),
        BOOL_TO_DATE(Conversion.toDate(BOOL_TO_INT)),
        STRING_TO_DATE(Conversion.fromString(DateUtils::asDateOnly, "date")),
        DATETIME_TO_DATE(Conversion.fromDatetimeToDate()),
        RATIONAL_TO_TIME(Conversion.toTime(RATIONAL_TO_LONG)),
        INTEGER_TO_TIME(Conversion.toTime(INTEGER_TO_LONG)),
        BOOL_TO_TIME(Conversion.toTime(BOOL_TO_INT)),
        STRING_TO_TIME(Conversion.fromString(DateUtils::asTimeOnly, "time")),
        DATE_TO_TIME(Conversion.fromDatetimeToTime()),
        DATETIME_TO_TIME(Conversion.fromDatetimeToTime()),
        RATIONAL_TO_DATETIME(Conversion.toDateTime(RATIONAL_TO_LONG)),
        INTEGER_TO_DATETIME(Conversion.toDateTime(INTEGER_TO_LONG)),
        BOOL_TO_DATETIME(Conversion.toDateTime(BOOL_TO_INT)),
        STRING_TO_DATETIME(Conversion.fromString(DateUtils::asDateTime, "datetime")),
        DATE_TO_DATETIME(value -> value),
        NUMERIC_TO_BOOLEAN(Conversion.fromLong(value -> value != 0L)),
        STRING_TO_BOOLEAN(Conversion.fromString(DataTypeConversion::convertToBoolean, "boolean")),
        DATE_TO_BOOLEAN(Conversion.fromDateTime(value -> value != 0L)),
        TIME_TO_BOOLEAN(Conversion.fromTime(value -> value != 0L)),
        DATETIME_TO_BOOLEAN(Conversion.fromDateTime(value -> value != 0L)),
        BOOL_TO_LONG(Conversion.fromBool(value -> value != false ? 1L : 0L)),
        STRING_TO_IP(o -> {
            if (!InetAddresses.isInetAddress((String)o.toString())) {
                throw new SqlIllegalArgumentException("[" + o + "] is not a valid IPv4 or IPv6 address");
            }
            return o;
        });

        private final Function<Object, Object> converter;

        private Conversion(Function<Object, Object> converter) {
            this.converter = converter;
        }

        private static Function<Object, Object> fromDouble(DoubleFunction<Object> converter) {
            return l -> converter.apply(((Number)l).doubleValue());
        }

        private static Function<Object, Object> fromLong(LongFunction<Object> converter) {
            return l -> converter.apply(((Number)l).longValue());
        }

        private static Function<Object, Object> fromString(Function<String, Object> converter, String to) {
            return value -> {
                try {
                    return converter.apply(value.toString());
                }
                catch (NumberFormatException e) {
                    throw new SqlIllegalArgumentException(e, "cannot cast [{}] to [{}]", value, to);
                }
                catch (IllegalArgumentException | DateTimeParseException e) {
                    throw new SqlIllegalArgumentException(e, "cannot cast [{}] to [{}]: {}", value, to, e.getMessage());
                }
            };
        }

        private static Function<Object, Object> fromBool(Function<Boolean, Object> converter) {
            return l -> converter.apply((Boolean)l);
        }

        private static Function<Object, Object> fromTime(Function<Long, Object> converter) {
            return l -> converter.apply(((OffsetTime)l).atDate(DateUtils.EPOCH).toInstant().toEpochMilli());
        }

        private static Function<Object, Object> fromDateTime(Function<Long, Object> converter) {
            return l -> converter.apply(((ZonedDateTime)l).toInstant().toEpochMilli());
        }

        private static Function<Object, Object> toDate(Conversion conversion) {
            return l -> DateUtils.asDateOnly(((Number)conversion.convert(l)).longValue());
        }

        private static Function<Object, Object> toTime(Conversion conversion) {
            return l -> DateUtils.asTimeOnly(((Number)conversion.convert(l)).longValue());
        }

        private static Function<Object, Object> toDateTime(Conversion conversion) {
            return l -> DateUtils.asDateTime(((Number)conversion.convert(l)).longValue());
        }

        private static Function<Object, Object> fromDatetimeToDate() {
            return l -> DateUtils.asDateOnly((ZonedDateTime)l);
        }

        private static Function<Object, Object> fromDatetimeToTime() {
            return l -> ((ZonedDateTime)l).toOffsetDateTime().toOffsetTime();
        }

        public Object convert(Object l) {
            if (l == null) {
                return null;
            }
            return this.converter.apply(l);
        }
    }
}

