/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.sql.action.SqlTranslateAction;
import org.elasticsearch.xpack.sql.action.SqlTranslateRequest;

public class RestSqlTranslateAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestSqlTranslateAction.class));

    public RestSqlTranslateAction(RestController controller) {
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_sql/translate", (RestHandler)this, RestRequest.Method.GET, "/_xpack/sql/translate", deprecationLogger);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_sql/translate", (RestHandler)this, RestRequest.Method.POST, "/_xpack/sql/translate", deprecationLogger);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SqlTranslateRequest sqlRequest;
        try (XContentParser parser = request.contentOrSourceParamParser();){
            sqlRequest = SqlTranslateRequest.fromXContent((XContentParser)parser);
        }
        return channel -> client.executeLocally((ActionType)SqlTranslateAction.INSTANCE, (ActionRequest)sqlRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public String getName() {
        return "xpack_sql_translate_action";
    }
}

