/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.planner;

import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.Foldables;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.Functions;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Avg;
import org.elasticsearch.xpack.sql.expression.function.aggregate.CompoundNumericAggregate;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.sql.expression.function.aggregate.ExtendedStats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.First;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Last;
import org.elasticsearch.xpack.sql.expression.function.aggregate.MatrixStats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.sql.expression.function.aggregate.MedianAbsoluteDeviation;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.sql.expression.function.aggregate.PercentileRanks;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Percentiles;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Stats;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.sql.expression.function.aggregate.TopHits;
import org.elasticsearch.xpack.sql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.sql.expression.function.grouping.Histogram;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeHistogramFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.GeoShape;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.StDistance;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.expression.literal.Intervals;
import org.elasticsearch.xpack.sql.expression.predicate.Range;
import org.elasticsearch.xpack.sql.expression.predicate.fulltext.MatchQueryPredicate;
import org.elasticsearch.xpack.sql.expression.predicate.fulltext.MultiMatchQueryPredicate;
import org.elasticsearch.xpack.sql.expression.predicate.fulltext.StringQueryPredicate;
import org.elasticsearch.xpack.sql.expression.predicate.logical.And;
import org.elasticsearch.xpack.sql.expression.predicate.logical.Not;
import org.elasticsearch.xpack.sql.expression.predicate.logical.Or;
import org.elasticsearch.xpack.sql.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.sql.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.GreaterThan;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.GreaterThanOrEqual;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.In;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.LessThan;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.LessThanOrEqual;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.NotEquals;
import org.elasticsearch.xpack.sql.expression.predicate.operator.comparison.NullEquals;
import org.elasticsearch.xpack.sql.expression.predicate.regex.Like;
import org.elasticsearch.xpack.sql.expression.predicate.regex.LikePattern;
import org.elasticsearch.xpack.sql.expression.predicate.regex.RLike;
import org.elasticsearch.xpack.sql.expression.predicate.regex.RegexMatch;
import org.elasticsearch.xpack.sql.querydsl.agg.AggFilter;
import org.elasticsearch.xpack.sql.querydsl.agg.AndAggFilter;
import org.elasticsearch.xpack.sql.querydsl.agg.AvgAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.CardinalityAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.ExtendedStatsAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.FilterExistsAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByDateHistogram;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByKey;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByNumericHistogram;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByValue;
import org.elasticsearch.xpack.sql.querydsl.agg.LeafAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.MatrixStatsAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.MaxAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.MedianAbsoluteDeviationAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.MinAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.OrAggFilter;
import org.elasticsearch.xpack.sql.querydsl.agg.PercentileRanksAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.PercentilesAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.StatsAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.SumAgg;
import org.elasticsearch.xpack.sql.querydsl.agg.TopHitsAgg;
import org.elasticsearch.xpack.sql.querydsl.query.BoolQuery;
import org.elasticsearch.xpack.sql.querydsl.query.ExistsQuery;
import org.elasticsearch.xpack.sql.querydsl.query.GeoDistanceQuery;
import org.elasticsearch.xpack.sql.querydsl.query.LeafQuery;
import org.elasticsearch.xpack.sql.querydsl.query.MatchQuery;
import org.elasticsearch.xpack.sql.querydsl.query.MultiMatchQuery;
import org.elasticsearch.xpack.sql.querydsl.query.NestedQuery;
import org.elasticsearch.xpack.sql.querydsl.query.NotQuery;
import org.elasticsearch.xpack.sql.querydsl.query.Query;
import org.elasticsearch.xpack.sql.querydsl.query.QueryStringQuery;
import org.elasticsearch.xpack.sql.querydsl.query.RangeQuery;
import org.elasticsearch.xpack.sql.querydsl.query.RegexQuery;
import org.elasticsearch.xpack.sql.querydsl.query.ScriptQuery;
import org.elasticsearch.xpack.sql.querydsl.query.TermQuery;
import org.elasticsearch.xpack.sql.querydsl.query.TermsQuery;
import org.elasticsearch.xpack.sql.querydsl.query.WildcardQuery;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.Check;
import org.elasticsearch.xpack.sql.util.DateUtils;
import org.elasticsearch.xpack.sql.util.ReflectionUtils;

final class QueryTranslator {
    public static final String DATE_FORMAT = "strict_date_time";
    public static final String TIME_FORMAT = "strict_hour_minute_second_millis";
    private static final List<ExpressionTranslator<?>> QUERY_TRANSLATORS = Arrays.asList(new BinaryComparisons(), new InComparisons(), new Ranges(), new BinaryLogic(), new Nots(), new IsNullTranslator(), new IsNotNullTranslator(), new Likes(), new StringQueries(), new Matches(), new MultiMatches(), new Scalars());
    private static final List<AggTranslator<?>> AGG_TRANSLATORS = Arrays.asList(new Maxes(), new Mins(), new Avgs(), new Sums(), new StatsAggs(), new ExtendedStatsAggs(), new MatrixStatsAggs(), new PercentilesAggs(), new PercentileRanksAggs(), new CountAggs(), new DateTimes(), new Firsts(), new Lasts(), new MADs());

    private QueryTranslator() {
    }

    static QueryTranslation toQuery(Expression e, boolean onAggs) {
        QueryTranslation translation = null;
        for (ExpressionTranslator<?> translator : QUERY_TRANSLATORS) {
            translation = translator.translate(e, onAggs);
            if (translation == null) continue;
            return translation;
        }
        throw new SqlIllegalArgumentException("Don't know how to translate {} {}", e.nodeName(), e);
    }

    static LeafAgg toAgg(String id, Function f) {
        for (AggTranslator<?> translator : AGG_TRANSLATORS) {
            LeafAgg agg = translator.apply(id, f);
            if (agg == null) continue;
            return agg;
        }
        throw new SqlIllegalArgumentException("Don't know how to translate {} {}", f.nodeName(), f);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static GroupingContext groupBy(List<? extends Expression> groupings) {
        if (groupings.isEmpty()) {
            return null;
        }
        LinkedHashMap<ExpressionId, GroupByKey> aggMap = new LinkedHashMap<ExpressionId, GroupByKey>();
        for (Expression expression : groupings) {
            void var4_4;
            Object var4_5 = null;
            if (!(expression instanceof NamedExpression)) throw new SqlIllegalArgumentException("Don't know how to group on {}", expression.nodeString());
            NamedExpression ne = (NamedExpression)expression;
            ExpressionId id = ne.id();
            String aggId = id.toString();
            if (expression instanceof FieldAttribute) {
                ne = ((FieldAttribute)expression).exactAttribute();
            }
            if (expression instanceof Function) {
                if (expression instanceof DateTimeHistogramFunction) {
                    DateTimeHistogramFunction dthf = (DateTimeHistogramFunction)expression;
                    GroupByDateHistogram groupByDateHistogram = new GroupByDateHistogram(aggId, QueryTranslator.nameOf(expression), dthf.interval(), dthf.zoneId());
                } else if (expression instanceof ScalarFunction) {
                    ScalarFunction sf = (ScalarFunction)expression;
                    GroupByValue groupByValue = new GroupByValue(aggId, sf.asScript());
                } else {
                    void var4_13;
                    if (!(expression instanceof GroupingFunction)) throw new SqlIllegalArgumentException("Cannot GROUP BY function {}", expression);
                    if (!(expression instanceof Histogram)) throw new SqlIllegalArgumentException("Unsupproted grouping function {}", expression);
                    Histogram h = (Histogram)expression;
                    Expression field = h.field();
                    if (h.dataType().isDateBased()) {
                        long intervalAsMillis = Intervals.inMillis(h.interval());
                        if (h.dataType() == DataType.DATE) {
                            intervalAsMillis = DateUtils.minDayInterval(intervalAsMillis);
                        }
                        if (field instanceof FieldAttribute) {
                            GroupByDateHistogram groupByDateHistogram = new GroupByDateHistogram(aggId, QueryTranslator.nameOf(field), intervalAsMillis, h.zoneId());
                        } else if (field instanceof Function) {
                            GroupByDateHistogram groupByDateHistogram = new GroupByDateHistogram(aggId, ((Function)field).asScript(), intervalAsMillis, h.zoneId());
                        }
                    } else if (field instanceof FieldAttribute) {
                        GroupByNumericHistogram groupByNumericHistogram = new GroupByNumericHistogram(aggId, QueryTranslator.nameOf(field), Foldables.doubleValueOf(h.interval()));
                    } else if (field instanceof Function) {
                        GroupByNumericHistogram groupByNumericHistogram = new GroupByNumericHistogram(aggId, ((Function)field).asScript(), Foldables.doubleValueOf(h.interval()));
                    }
                    if (var4_13 == null) {
                        throw new SqlIllegalArgumentException("Unsupported histogram field {}", field);
                    }
                }
            } else {
                GroupByValue groupByValue = new GroupByValue(aggId, ne.name());
            }
            aggMap.put(id, (GroupByKey)var4_4);
        }
        return new GroupingContext(aggMap);
    }

    static QueryTranslation and(Source source, QueryTranslation left, QueryTranslation right) {
        Check.isTrue(left != null || right != null, "Both expressions are null");
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        Query newQ = null;
        if (left.query != null || right.query != null) {
            newQ = QueryTranslator.and(source, left.query, right.query);
        }
        AggFilter aggFilter = left.aggFilter == null ? right.aggFilter : (right.aggFilter == null ? left.aggFilter : new AndAggFilter(left.aggFilter, right.aggFilter));
        return new QueryTranslation(newQ, aggFilter);
    }

    static Query and(Source source, Query left, Query right) {
        Check.isTrue(left != null || right != null, "Both expressions are null");
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return new BoolQuery(source, true, left, right);
    }

    static QueryTranslation or(Source source, QueryTranslation left, QueryTranslation right) {
        Check.isTrue(left != null || right != null, "Both expressions are null");
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        Query newQ = null;
        if (left.query != null || right.query != null) {
            newQ = QueryTranslator.or(source, left.query, right.query);
        }
        AggFilter aggFilter = null;
        aggFilter = left.aggFilter == null ? right.aggFilter : (right.aggFilter == null ? left.aggFilter : new OrAggFilter(left.aggFilter, right.aggFilter));
        return new QueryTranslation(newQ, aggFilter);
    }

    static Query or(Source source, Query left, Query right) {
        Check.isTrue(left != null || right != null, "Both expressions are null");
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return new BoolQuery(source, false, left, right);
    }

    static String nameOf(Expression e) {
        if (e instanceof DateTimeFunction) {
            return QueryTranslator.nameOf(((DateTimeFunction)e).field());
        }
        if (e instanceof NamedExpression) {
            return ((NamedExpression)e).name();
        }
        if (e instanceof Literal) {
            return String.valueOf(e.fold());
        }
        throw new SqlIllegalArgumentException("Cannot determine name for {}", e);
    }

    static String idOf(Expression e) {
        if (e instanceof NamedExpression) {
            return ((NamedExpression)e).id().toString();
        }
        throw new SqlIllegalArgumentException("Cannot determine id for {}", e);
    }

    static String dateFormat(Expression e) {
        if (e instanceof DateTimeFunction) {
            return ((DateTimeFunction)e).dateTimeFormat();
        }
        return null;
    }

    static String field(AggregateFunction af) {
        Expression arg = af.field();
        if (arg instanceof FieldAttribute) {
            FieldAttribute field = (FieldAttribute)arg;
            if (af instanceof Count && ((Count)af).distinct()) {
                return field.exactAttribute().name();
            }
            return field.name();
        }
        if (arg instanceof Literal) {
            return String.valueOf(((Literal)arg).value());
        }
        throw new SqlIllegalArgumentException("Does not know how to convert argument {} for function {}", arg.nodeString(), af.nodeString());
    }

    private static String topAggsField(AggregateFunction af, Expression e) {
        if (e == null) {
            return null;
        }
        if (e instanceof FieldAttribute) {
            return ((FieldAttribute)e).exactAttribute().name();
        }
        throw new SqlIllegalArgumentException("Does not know how to convert argument {} for function {}", e.nodeString(), af.nodeString());
    }

    static abstract class ExpressionTranslator<E extends Expression> {
        private final Class<E> typeToken = ReflectionUtils.detectSuperTypeForRuleLike(this.getClass());

        ExpressionTranslator() {
        }

        public QueryTranslation translate(Expression exp, boolean onAggs) {
            return this.typeToken.isInstance(exp) ? this.asQuery(exp, onAggs) : null;
        }

        protected abstract QueryTranslation asQuery(E var1, boolean var2);

        protected static Query handleQuery(ScalarFunction sf, Expression field, Supplier<Query> query) {
            Query q = query.get();
            if (field instanceof StDistance && q instanceof GeoDistanceQuery) {
                return ExpressionTranslator.wrapIfNested(q, ((StDistance)field).left());
            }
            if (field instanceof FieldAttribute) {
                return ExpressionTranslator.wrapIfNested(q, field);
            }
            return new ScriptQuery(sf.source(), sf.asScript());
        }

        protected static Query wrapIfNested(Query query, Expression exp) {
            FieldAttribute fa;
            if (exp instanceof FieldAttribute && (fa = (FieldAttribute)exp).isNested()) {
                return new NestedQuery(fa.source(), fa.nestedParent().name(), query);
            }
            return query;
        }
    }

    static abstract class TopHitsAggTranslator<C extends TopHits>
    extends AggTranslator<C> {
        TopHitsAggTranslator() {
        }

        @Override
        protected final LeafAgg asAgg(String id, C function) {
            return this.toAgg(id, function);
        }

        protected abstract LeafAgg toAgg(String var1, C var2);
    }

    static abstract class CompoundAggTranslator<C extends CompoundNumericAggregate>
    extends AggTranslator<C> {
        CompoundAggTranslator() {
        }

        @Override
        protected final LeafAgg asAgg(String id, C function) {
            return this.toAgg(id, function);
        }

        protected abstract LeafAgg toAgg(String var1, C var2);
    }

    static abstract class SingleValueAggTranslator<F extends Function>
    extends AggTranslator<F> {
        SingleValueAggTranslator() {
        }

        @Override
        protected final LeafAgg asAgg(String id, F function) {
            return this.toAgg(id, function);
        }

        protected abstract LeafAgg toAgg(String var1, F var2);
    }

    static abstract class AggTranslator<F extends Function> {
        private final Class<?> typeToken = ReflectionUtils.detectSuperTypeForRuleLike(this.getClass());

        AggTranslator() {
        }

        public final LeafAgg apply(String id, Function f) {
            return this.typeToken.isInstance(f) ? this.asAgg(id, f) : null;
        }

        protected abstract LeafAgg asAgg(String var1, F var2);
    }

    static class DateTimes
    extends SingleValueAggTranslator<Min> {
        DateTimes() {
        }

        @Override
        protected LeafAgg toAgg(String id, Min m) {
            return new MinAgg(id, QueryTranslator.field(m));
        }
    }

    static class PercentileRanksAggs
    extends CompoundAggTranslator<PercentileRanks> {
        PercentileRanksAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, PercentileRanks p) {
            return new PercentileRanksAgg(id, QueryTranslator.field(p), Foldables.doubleValuesOf(p.values()));
        }
    }

    static class PercentilesAggs
    extends CompoundAggTranslator<Percentiles> {
        PercentilesAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, Percentiles p) {
            return new PercentilesAgg(id, QueryTranslator.field(p), Foldables.doubleValuesOf(p.percents()));
        }
    }

    static class MatrixStatsAggs
    extends CompoundAggTranslator<MatrixStats> {
        MatrixStatsAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, MatrixStats m) {
            return new MatrixStatsAgg(id, Collections.singletonList(QueryTranslator.field(m)));
        }
    }

    static class ExtendedStatsAggs
    extends CompoundAggTranslator<ExtendedStats> {
        ExtendedStatsAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, ExtendedStats e) {
            return new ExtendedStatsAgg(id, QueryTranslator.field(e));
        }
    }

    static class StatsAggs
    extends CompoundAggTranslator<Stats> {
        StatsAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, Stats s) {
            return new StatsAgg(id, QueryTranslator.field(s));
        }
    }

    static class Lasts
    extends TopHitsAggTranslator<Last> {
        Lasts() {
        }

        @Override
        protected LeafAgg toAgg(String id, Last l) {
            return new TopHitsAgg(id, QueryTranslator.topAggsField(l, l.field()), l.dataType(), QueryTranslator.topAggsField(l, l.orderField()), l.orderField() == null ? null : l.orderField().dataType(), SortOrder.DESC);
        }
    }

    static class Firsts
    extends TopHitsAggTranslator<First> {
        Firsts() {
        }

        @Override
        protected LeafAgg toAgg(String id, First f) {
            return new TopHitsAgg(id, QueryTranslator.topAggsField(f, f.field()), f.dataType(), QueryTranslator.topAggsField(f, f.orderField()), f.orderField() == null ? null : f.orderField().dataType(), SortOrder.ASC);
        }
    }

    static class MADs
    extends SingleValueAggTranslator<MedianAbsoluteDeviation> {
        MADs() {
        }

        @Override
        protected LeafAgg toAgg(String id, MedianAbsoluteDeviation m) {
            return new MedianAbsoluteDeviationAgg(id, QueryTranslator.field(m));
        }
    }

    static class Mins
    extends SingleValueAggTranslator<Min> {
        Mins() {
        }

        @Override
        protected LeafAgg toAgg(String id, Min m) {
            return new MinAgg(id, QueryTranslator.field(m));
        }
    }

    static class Maxes
    extends SingleValueAggTranslator<Max> {
        Maxes() {
        }

        @Override
        protected LeafAgg toAgg(String id, Max m) {
            return new MaxAgg(id, QueryTranslator.field(m));
        }
    }

    static class Avgs
    extends SingleValueAggTranslator<Avg> {
        Avgs() {
        }

        @Override
        protected LeafAgg toAgg(String id, Avg a) {
            return new AvgAgg(id, QueryTranslator.field(a));
        }
    }

    static class Sums
    extends SingleValueAggTranslator<Sum> {
        Sums() {
        }

        @Override
        protected LeafAgg toAgg(String id, Sum s) {
            return new SumAgg(id, QueryTranslator.field(s));
        }
    }

    static class CountAggs
    extends SingleValueAggTranslator<Count> {
        CountAggs() {
        }

        @Override
        protected LeafAgg toAgg(String id, Count c) {
            if (c.distinct()) {
                return new CardinalityAgg(id, QueryTranslator.field(c));
            }
            return new FilterExistsAgg(id, QueryTranslator.field(c));
        }
    }

    static class Scalars
    extends ExpressionTranslator<ScalarFunction> {
        Scalars() {
        }

        @Override
        protected QueryTranslation asQuery(ScalarFunction f, boolean onAggs) {
            ScriptTemplate script = f.asScript();
            Query query = null;
            AggFilter aggFilter = null;
            if (onAggs) {
                aggFilter = new AggFilter(f.id().toString(), script);
            } else {
                query = Scalars.handleQuery(f, f, () -> new ScriptQuery(f.source(), script));
            }
            return new QueryTranslation(query, aggFilter);
        }
    }

    static class Ranges
    extends ExpressionTranslator<Range> {
        Ranges() {
        }

        @Override
        protected QueryTranslation asQuery(Range r, boolean onAggs) {
            Expression e = r.value();
            if (e instanceof NamedExpression) {
                Query query = null;
                AggFilter aggFilter = null;
                Attribute at = ((NamedExpression)e).toAttribute();
                if (onAggs) {
                    aggFilter = new AggFilter(at.id().toString(), r.asScript());
                } else {
                    query = Ranges.handleQuery(r, r.value(), () -> new RangeQuery(r.source(), QueryTranslator.nameOf(r.value()), Foldables.valueOf(r.lower()), r.includeLower(), Foldables.valueOf(r.upper()), r.includeUpper(), QueryTranslator.dateFormat(r.value())));
                }
                return new QueryTranslation(query, aggFilter);
            }
            throw new SqlIllegalArgumentException("No idea how to translate " + e);
        }
    }

    static class InComparisons
    extends ExpressionTranslator<In> {
        InComparisons() {
        }

        @Override
        protected QueryTranslation asQuery(In in, boolean onAggs) {
            if (in.value() instanceof NamedExpression) {
                NamedExpression ne = (NamedExpression)in.value();
                Query query = null;
                AggFilter aggFilter = null;
                Attribute at = ne.toAttribute();
                if (onAggs) {
                    aggFilter = new AggFilter(at.id().toString(), in.asScript());
                } else {
                    LeafQuery q = null;
                    if (in.value() instanceof FieldAttribute) {
                        FieldAttribute fa = (FieldAttribute)in.value();
                        q = new TermsQuery(in.source(), fa.exactAttribute().name(), in.list());
                    } else {
                        q = new ScriptQuery(in.source(), in.asScript());
                    }
                    ScriptQuery qu = q;
                    query = InComparisons.handleQuery(in, ne, () -> qu);
                }
                return new QueryTranslation(query, aggFilter);
            }
            throw new SqlIllegalArgumentException("No idea how to translate " + in.value());
        }
    }

    static class BinaryComparisons
    extends ExpressionTranslator<BinaryComparison> {
        BinaryComparisons() {
        }

        @Override
        protected QueryTranslation asQuery(BinaryComparison bc, boolean onAggs) {
            Check.isTrue(bc.right().foldable(), "Line {}:{}: Comparisons against variables are not (currently) supported; offender [{}] in [{}]", bc.right().sourceLocation().getLineNumber(), bc.right().sourceLocation().getColumnNumber(), Expressions.name(bc.right()), bc.symbol());
            if (bc.left() instanceof NamedExpression) {
                NamedExpression ne = (NamedExpression)bc.left();
                Query query = null;
                AggFilter aggFilter = null;
                Attribute at = ne.toAttribute();
                if (onAggs) {
                    aggFilter = new AggFilter(at.id().toString(), bc.asScript());
                } else {
                    query = BinaryComparisons.handleQuery(bc, ne, () -> BinaryComparisons.translateQuery(bc));
                }
                return new QueryTranslation(query, aggFilter);
            }
            throw new SqlIllegalArgumentException("No idea how to translate " + bc.left());
        }

        private static Query translateQuery(BinaryComparison bc) {
            Geometry geometry;
            Object geoShape;
            StDistance stDistance;
            Source source = bc.source();
            String name = QueryTranslator.nameOf(bc.left());
            Object value = Foldables.valueOf(bc.right());
            String format = QueryTranslator.dateFormat(bc.left());
            boolean isDateLiteralComparison = false;
            if ((value instanceof ZonedDateTime || value instanceof OffsetTime) && format == null) {
                DateFormatter formatter;
                if (value instanceof ZonedDateTime) {
                    formatter = DateFormatter.forPattern((String)QueryTranslator.DATE_FORMAT);
                    value = formatter.format((TemporalAccessor)((ZonedDateTime)value));
                } else {
                    formatter = DateFormatter.forPattern((String)QueryTranslator.TIME_FORMAT);
                    value = formatter.format((TemporalAccessor)((OffsetTime)value));
                }
                format = formatter.pattern();
                isDateLiteralComparison = true;
            }
            if (bc.left() instanceof StDistance && value instanceof Number && (bc instanceof LessThan || bc instanceof LessThanOrEqual) && (stDistance = (StDistance)bc.left()).left() instanceof FieldAttribute && stDistance.right().foldable() && (geoShape = Foldables.valueOf(stDistance.right())) instanceof GeoShape && (geometry = ((GeoShape)geoShape).toGeometry()) instanceof Point) {
                String field = QueryTranslator.nameOf(stDistance.left());
                return new GeoDistanceQuery(source, field, ((Number)value).doubleValue(), ((Point)geometry).getY(), ((Point)geometry).getX());
            }
            if (bc instanceof GreaterThan) {
                return new RangeQuery(source, name, value, false, null, false, format);
            }
            if (bc instanceof GreaterThanOrEqual) {
                return new RangeQuery(source, name, value, true, null, false, format);
            }
            if (bc instanceof LessThan) {
                return new RangeQuery(source, name, null, false, value, false, format);
            }
            if (bc instanceof LessThanOrEqual) {
                return new RangeQuery(source, name, null, false, value, true, format);
            }
            if (bc instanceof Equals || bc instanceof NullEquals || bc instanceof NotEquals) {
                if (bc.left() instanceof FieldAttribute) {
                    name = ((FieldAttribute)bc.left()).exactAttribute().name();
                }
                Query query = isDateLiteralComparison ? new RangeQuery(source, name, value, true, value, true, format) : new TermQuery(source, name, value);
                if (bc instanceof NotEquals) {
                    query = new NotQuery(source, query);
                }
                return query;
            }
            throw new SqlIllegalArgumentException("Don't know how to translate binary comparison [{}] in [{}]", bc.right().nodeString(), bc);
        }
    }

    static class IsNullTranslator
    extends ExpressionTranslator<IsNull> {
        IsNullTranslator() {
        }

        @Override
        protected QueryTranslation asQuery(IsNull isNull, boolean onAggs) {
            Query query = null;
            AggFilter aggFilter = null;
            if (onAggs) {
                aggFilter = new AggFilter(isNull.id().toString(), isNull.asScript());
            } else {
                Query q = null;
                q = isNull.field() instanceof FieldAttribute ? new NotQuery(isNull.source(), new ExistsQuery(isNull.source(), QueryTranslator.nameOf(isNull.field()))) : new ScriptQuery(isNull.source(), isNull.asScript());
                ScriptQuery qu = q;
                query = IsNullTranslator.handleQuery(isNull, isNull.field(), () -> qu);
            }
            return new QueryTranslation(query, aggFilter);
        }
    }

    static class IsNotNullTranslator
    extends ExpressionTranslator<IsNotNull> {
        IsNotNullTranslator() {
        }

        @Override
        protected QueryTranslation asQuery(IsNotNull isNotNull, boolean onAggs) {
            Query query = null;
            AggFilter aggFilter = null;
            if (onAggs) {
                aggFilter = new AggFilter(isNotNull.id().toString(), isNotNull.asScript());
            } else {
                LeafQuery q = null;
                q = isNotNull.field() instanceof FieldAttribute ? new ExistsQuery(isNotNull.source(), QueryTranslator.nameOf(isNotNull.field())) : new ScriptQuery(isNotNull.source(), isNotNull.asScript());
                LeafQuery qu = q;
                query = IsNotNullTranslator.handleQuery(isNotNull, isNotNull.field(), () -> qu);
            }
            return new QueryTranslation(query, aggFilter);
        }
    }

    static class Nots
    extends ExpressionTranslator<Not> {
        Nots() {
        }

        @Override
        protected QueryTranslation asQuery(Not not, boolean onAggs) {
            Query query = null;
            AggFilter aggFilter = null;
            if (onAggs) {
                aggFilter = new AggFilter(not.id().toString(), not.asScript());
            } else {
                Query q;
                Expression e = not.field();
                Query wrappedQuery = QueryTranslator.toQuery((Expression)not.field(), (boolean)false).query;
                Query query2 = q = wrappedQuery instanceof ScriptQuery ? new ScriptQuery(not.source(), not.asScript()) : new NotQuery(not.source(), wrappedQuery);
                if (e instanceof FieldAttribute) {
                    query = Nots.wrapIfNested(q, e);
                }
                query = q;
            }
            return new QueryTranslation(query, aggFilter);
        }
    }

    static class BinaryLogic
    extends ExpressionTranslator<org.elasticsearch.xpack.sql.expression.predicate.logical.BinaryLogic> {
        BinaryLogic() {
        }

        @Override
        protected QueryTranslation asQuery(org.elasticsearch.xpack.sql.expression.predicate.logical.BinaryLogic e, boolean onAggs) {
            if (e instanceof And) {
                return QueryTranslator.and(e.source(), QueryTranslator.toQuery(e.left(), onAggs), QueryTranslator.toQuery(e.right(), onAggs));
            }
            if (e instanceof Or) {
                return QueryTranslator.or(e.source(), QueryTranslator.toQuery(e.left(), onAggs), QueryTranslator.toQuery(e.right(), onAggs));
            }
            return null;
        }
    }

    static class MultiMatches
    extends ExpressionTranslator<MultiMatchQueryPredicate> {
        MultiMatches() {
        }

        @Override
        protected QueryTranslation asQuery(MultiMatchQueryPredicate q, boolean onAggs) {
            return new QueryTranslation(new MultiMatchQuery(q.source(), q.query(), q.fields(), q));
        }
    }

    static class Matches
    extends ExpressionTranslator<MatchQueryPredicate> {
        Matches() {
        }

        @Override
        protected QueryTranslation asQuery(MatchQueryPredicate q, boolean onAggs) {
            return new QueryTranslation(Matches.wrapIfNested(new MatchQuery(q.source(), QueryTranslator.nameOf(q.field()), q.query(), q), q.field()));
        }
    }

    static class StringQueries
    extends ExpressionTranslator<StringQueryPredicate> {
        StringQueries() {
        }

        @Override
        protected QueryTranslation asQuery(StringQueryPredicate q, boolean onAggs) {
            return new QueryTranslation(new QueryStringQuery(q.source(), q.query(), q.fields(), q));
        }
    }

    static class Likes
    extends ExpressionTranslator<RegexMatch> {
        Likes() {
        }

        @Override
        protected QueryTranslation asQuery(RegexMatch e, boolean onAggs) {
            LeafQuery q = null;
            String targetFieldName = null;
            if (!(e.field() instanceof FieldAttribute)) {
                throw new SqlIllegalArgumentException("Scalar function [{}] not allowed (yet) as argument for " + e.functionName(), Expressions.name(e.field()));
            }
            targetFieldName = QueryTranslator.nameOf(((FieldAttribute)e.field()).exactAttribute());
            if (e instanceof Like) {
                LikePattern p = (LikePattern)((Like)e).pattern();
                q = new WildcardQuery(e.source(), targetFieldName, p.asLuceneWildcard());
            }
            if (e instanceof RLike) {
                String pattern = (String)((RLike)e).pattern();
                q = new RegexQuery(e.source(), targetFieldName, pattern);
            }
            return q != null ? new QueryTranslation(Likes.wrapIfNested(q, e.field())) : null;
        }
    }

    static class GroupingContext {
        final Map<ExpressionId, GroupByKey> groupMap;
        final GroupByKey tail;

        GroupingContext(Map<ExpressionId, GroupByKey> groupMap) {
            this.groupMap = groupMap;
            GroupByKey lastAgg = null;
            for (Map.Entry<ExpressionId, GroupByKey> entry : groupMap.entrySet()) {
                lastAgg = entry.getValue();
            }
            this.tail = lastAgg;
        }

        GroupByKey groupFor(Expression exp) {
            if (Functions.isAggregate(exp)) {
                AggregateFunction f = (AggregateFunction)exp;
                if (!this.groupMap.isEmpty()) {
                    GroupByKey matchingGroup = null;
                    if (f.field() instanceof NamedExpression) {
                        matchingGroup = this.groupMap.get(((NamedExpression)f.field()).id());
                    }
                    return matchingGroup != null ? matchingGroup : this.tail;
                }
                return null;
            }
            if (exp instanceof NamedExpression) {
                return this.groupMap.get(((NamedExpression)exp).id());
            }
            throw new SqlIllegalArgumentException("Don't know how to find group for expression {}", exp);
        }

        public String toString() {
            return this.groupMap.toString();
        }
    }

    static class QueryTranslation {
        final Query query;
        final AggFilter aggFilter;

        QueryTranslation(Query query) {
            this(query, null);
        }

        QueryTranslation(AggFilter aggFilter) {
            this(null, aggFilter);
        }

        QueryTranslation(Query query, AggFilter aggFilter) {
            this.query = query;
            this.aggFilter = aggFilter;
        }
    }
}

