/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.planner;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.search.AggRef;
import org.elasticsearch.xpack.sql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.sql.expression.Alias;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.AttributeMap;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.Foldables;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.Order;
import org.elasticsearch.xpack.sql.expression.function.Function;
import org.elasticsearch.xpack.sql.expression.function.Functions;
import org.elasticsearch.xpack.sql.expression.function.ScoreAttribute;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.sql.expression.function.aggregate.CompoundNumericAggregate;
import org.elasticsearch.xpack.sql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.sql.expression.function.aggregate.InnerAggregate;
import org.elasticsearch.xpack.sql.expression.function.aggregate.TopHits;
import org.elasticsearch.xpack.sql.expression.function.grouping.GroupingFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeHistogramFunction;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.AggPathInput;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.UnaryPipe;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.sql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.sql.plan.physical.FilterExec;
import org.elasticsearch.xpack.sql.plan.physical.LimitExec;
import org.elasticsearch.xpack.sql.plan.physical.LocalExec;
import org.elasticsearch.xpack.sql.plan.physical.OrderExec;
import org.elasticsearch.xpack.sql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.sql.plan.physical.ProjectExec;
import org.elasticsearch.xpack.sql.planner.FoldingException;
import org.elasticsearch.xpack.sql.planner.PlanningException;
import org.elasticsearch.xpack.sql.planner.QueryTranslator;
import org.elasticsearch.xpack.sql.querydsl.agg.AggFilter;
import org.elasticsearch.xpack.sql.querydsl.agg.Aggs;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByKey;
import org.elasticsearch.xpack.sql.querydsl.agg.LeafAgg;
import org.elasticsearch.xpack.sql.querydsl.container.AttributeSort;
import org.elasticsearch.xpack.sql.querydsl.container.ComputedRef;
import org.elasticsearch.xpack.sql.querydsl.container.GlobalCountRef;
import org.elasticsearch.xpack.sql.querydsl.container.GroupByRef;
import org.elasticsearch.xpack.sql.querydsl.container.MetricAggRef;
import org.elasticsearch.xpack.sql.querydsl.container.QueryContainer;
import org.elasticsearch.xpack.sql.querydsl.container.ScoreSort;
import org.elasticsearch.xpack.sql.querydsl.container.ScriptSort;
import org.elasticsearch.xpack.sql.querydsl.container.Sort;
import org.elasticsearch.xpack.sql.querydsl.container.TopHitsAggRef;
import org.elasticsearch.xpack.sql.querydsl.query.Query;
import org.elasticsearch.xpack.sql.rule.Rule;
import org.elasticsearch.xpack.sql.rule.RuleExecutor;
import org.elasticsearch.xpack.sql.session.EmptyExecutable;
import org.elasticsearch.xpack.sql.util.Check;

class QueryFolder
extends RuleExecutor<PhysicalPlan> {
    QueryFolder() {
    }

    PhysicalPlan fold(PhysicalPlan plan) {
        return this.execute(plan);
    }

    @Override
    protected Iterable<RuleExecutor.Batch> batches() {
        RuleExecutor.Batch rollup = (RuleExecutor)this.new RuleExecutor.Batch("Fold queries", new FoldAggregate(), new FoldProject(), new FoldFilter(), new FoldOrderBy(), new FoldLimit());
        RuleExecutor.Batch local = (RuleExecutor)this.new RuleExecutor.Batch("Local queries", new PropagateEmptyLocal(), new LocalLimit());
        RuleExecutor.Batch finish = (RuleExecutor)this.new RuleExecutor.Batch("Finish query", RuleExecutor.Limiter.ONCE, new PlanOutputToQueryRef());
        return Arrays.asList(rollup, local, finish);
    }

    static abstract class FoldingRule<SubPlan extends PhysicalPlan>
    extends Rule<SubPlan, PhysicalPlan> {
        FoldingRule() {
        }

        @Override
        public final PhysicalPlan apply(PhysicalPlan plan) {
            return plan.transformUp(this::rule, this.typeToken());
        }

        @Override
        protected abstract PhysicalPlan rule(SubPlan var1);
    }

    private static class LocalLimit
    extends FoldingRule<LimitExec> {
        private LocalLimit() {
        }

        @Override
        protected PhysicalPlan rule(LimitExec plan) {
            if (plan.child() instanceof LocalExec) {
                return plan.child();
            }
            return plan;
        }
    }

    private static class PropagateEmptyLocal
    extends FoldingRule<PhysicalPlan> {
        private PropagateEmptyLocal() {
        }

        @Override
        protected PhysicalPlan rule(PhysicalPlan plan) {
            PhysicalPlan p;
            if (plan.children().size() == 1 && (p = (PhysicalPlan)plan.children().get(0)) instanceof LocalExec) {
                if (((LocalExec)p).isEmpty()) {
                    return new LocalExec(plan.source(), new EmptyExecutable(plan.output()));
                }
                throw new SqlIllegalArgumentException("Encountered a bug; {} is a LocalExec but is not empty", p);
            }
            return plan;
        }
    }

    private static class PlanOutputToQueryRef
    extends FoldingRule<EsQueryExec> {
        private PlanOutputToQueryRef() {
        }

        @Override
        protected PhysicalPlan rule(EsQueryExec exec) {
            QueryContainer qContainer = exec.queryContainer();
            if (qContainer.hasColumns()) {
                return exec;
            }
            for (Attribute attr : exec.output()) {
                qContainer = qContainer.addColumn(attr);
            }
            return exec.with(qContainer);
        }
    }

    private static class FoldLimit
    extends FoldingRule<LimitExec> {
        private FoldLimit() {
        }

        @Override
        protected PhysicalPlan rule(LimitExec plan) {
            if (plan.child() instanceof EsQueryExec) {
                EsQueryExec exec = (EsQueryExec)plan.child();
                int limit = Foldables.intValueOf(plan.limit());
                int currentSize = exec.queryContainer().limit();
                int newSize = currentSize < 0 ? limit : Math.min(currentSize, limit);
                return exec.with(exec.queryContainer().withLimit(newSize));
            }
            return plan;
        }
    }

    private static class FoldOrderBy
    extends FoldingRule<OrderExec> {
        private FoldOrderBy() {
        }

        @Override
        protected PhysicalPlan rule(OrderExec plan) {
            if (plan.child() instanceof EsQueryExec) {
                EsQueryExec exec = (EsQueryExec)plan.child();
                QueryContainer qContainer = exec.queryContainer();
                for (Order order : plan.order()) {
                    Sort.Direction direction = Sort.Direction.from(order.direction());
                    Sort.Missing missing = Sort.Missing.from(order.nullsPosition());
                    Attribute attr = ((NamedExpression)order.child()).toAttribute();
                    attr = qContainer.aliases().getOrDefault((Object)attr, attr);
                    String lookup = attr.id().toString();
                    GroupByKey group = qContainer.findGroupForAgg(lookup);
                    if (group != null && group != Aggs.IMPLICIT_GROUP_KEY) {
                        if (group.id().equals(lookup)) {
                            qContainer = qContainer.updateGroup(group.with(direction));
                            continue;
                        }
                        qContainer = qContainer.updateGroup(group.with(direction));
                        continue;
                    }
                    if (attr instanceof ScalarFunctionAttribute) {
                        ScalarFunctionAttribute sfa = (ScalarFunctionAttribute)attr;
                        if (sfa.orderBy() != null) {
                            if (sfa.orderBy() instanceof NamedExpression) {
                                Attribute at = ((NamedExpression)sfa.orderBy()).toAttribute();
                                at = qContainer.aliases().getOrDefault((Object)at, at);
                                qContainer = qContainer.addSort(new AttributeSort(at, direction, missing));
                                continue;
                            }
                            if (sfa.orderBy().foldable()) continue;
                            throw new PlanningException("does not know how to order by expression {}", sfa.orderBy());
                        }
                        qContainer = qContainer.addSort(new ScriptSort(sfa.script(), direction, missing));
                        continue;
                    }
                    if (attr instanceof ScoreAttribute) {
                        qContainer = qContainer.addSort(new ScoreSort(direction, missing));
                        continue;
                    }
                    qContainer = qContainer.addSort(new AttributeSort(attr, direction, missing));
                }
                return exec.with(qContainer);
            }
            return plan;
        }
    }

    private static class FoldAggregate
    extends FoldingRule<AggregateExec> {
        private FoldAggregate() {
        }

        @Override
        protected PhysicalPlan rule(AggregateExec a) {
            if (a.child() instanceof EsQueryExec) {
                EsQueryExec exec = (EsQueryExec)a.child();
                QueryTranslator.GroupingContext groupingContext = QueryTranslator.groupBy(a.groupings());
                QueryContainer queryC = exec.queryContainer();
                if (groupingContext != null) {
                    queryC = queryC.addGroups(groupingContext.groupMap.values());
                }
                LinkedHashMap<Attribute, Attribute> aliases = new LinkedHashMap<Attribute, Attribute>();
                LinkedHashMap<CompoundNumericAggregate, String> compoundAggMap = new LinkedHashMap<CompoundNumericAggregate, String>();
                for (NamedExpression namedExpression : a.aggregates()) {
                    if (namedExpression instanceof Alias || namedExpression instanceof Function) {
                        Expression child;
                        Alias as = namedExpression instanceof Alias ? (Alias)namedExpression : null;
                        Expression expression = child = as != null ? as.child() : namedExpression;
                        if (as != null && as.child() instanceof NamedExpression) {
                            aliases.put(as.toAttribute(), ((NamedExpression)as.child()).toAttribute());
                        }
                        if (child instanceof ScalarFunction) {
                            ScalarFunction f = (ScalarFunction)child;
                            Pipe proc = f.asPipe();
                            AtomicReference<QueryContainer> qC = new AtomicReference<QueryContainer>(queryC);
                            if (!(proc = proc.transformUp(p -> {
                                if (p.resolved()) {
                                    return p;
                                }
                                Expression exp = p.expression();
                                GroupByKey matchingGroup = null;
                                if (groupingContext != null) {
                                    matchingGroup = groupingContext.groupFor(exp);
                                } else if (exp instanceof ScalarFunction) {
                                    throw new FoldingException(exp, "Scalar function " + exp.toString() + " can be used only if included already in grouping", new Object[0]);
                                }
                                if (matchingGroup != null && (exp instanceof Attribute || exp instanceof ScalarFunction || exp instanceof GroupingFunction)) {
                                    Processor action = null;
                                    boolean isDateBased = exp.dataType().isDateBased();
                                    if (exp instanceof DateTimeHistogramFunction) {
                                        action = ((UnaryPipe)p).action();
                                        isDateBased = true;
                                    }
                                    return new AggPathInput(exp.source(), exp, new GroupByRef(matchingGroup.id(), null, isDateBased), action);
                                }
                                if (Functions.isAggregate(exp)) {
                                    Tuple<QueryContainer, AggPathInput> withFunction = this.addAggFunction(matchingGroup, (AggregateFunction)exp, compoundAggMap, (QueryContainer)qC.get());
                                    qC.set((QueryContainer)withFunction.v1());
                                    return (Pipe)withFunction.v2();
                                }
                                return p;
                            })).resolved()) {
                                throw new FoldingException(child, "Cannot find grouping for '{}'", Expressions.name(child));
                            }
                            queryC = qC.get().addColumn(new ComputedRef(proc), f.toAttribute());
                            continue;
                        }
                        GroupByKey matchingGroup = null;
                        if (groupingContext != null) {
                            matchingGroup = groupingContext.groupFor(child);
                        }
                        if (child instanceof Attribute) {
                            Check.notNull(matchingGroup, "Cannot find group [{}]", Expressions.name(child));
                            queryC = queryC.addColumn(new GroupByRef(matchingGroup.id(), null, child.dataType().isDateBased()), (Attribute)child);
                            continue;
                        }
                        if (child instanceof GroupingFunction) {
                            queryC = queryC.addColumn(new GroupByRef(matchingGroup.id(), null, child.dataType().isDateBased()), ((GroupingFunction)child).toAttribute());
                            continue;
                        }
                        if (child.foldable()) {
                            queryC = queryC.addColumn(namedExpression.toAttribute());
                            continue;
                        }
                        Check.isTrue(Functions.isAggregate(child), "Expected aggregate function inside alias; got [{}]", child.nodeString());
                        AggregateFunction af = (AggregateFunction)child;
                        Tuple<QueryContainer, AggPathInput> withAgg = this.addAggFunction(matchingGroup, af, compoundAggMap, queryC);
                        queryC = ((QueryContainer)withAgg.v1()).addColumn((FieldExtraction)((AggPathInput)withAgg.v2()).context(), af.toAttribute());
                        continue;
                    }
                    GroupByKey matchingGroup = null;
                    if (groupingContext != null) {
                        matchingGroup = groupingContext.groupFor(namedExpression);
                        Check.notNull(matchingGroup, "Cannot find group [{}]", Expressions.name(namedExpression));
                        queryC = queryC.addColumn(new GroupByRef(matchingGroup.id(), null, namedExpression.dataType().isDateBased()), namedExpression.toAttribute());
                        continue;
                    }
                    if (!namedExpression.foldable()) continue;
                    queryC = queryC.addColumn(namedExpression.toAttribute());
                }
                if (!aliases.isEmpty()) {
                    LinkedHashMap<Attribute, Attribute> newAliases = new LinkedHashMap<Attribute, Attribute>(queryC.aliases());
                    newAliases.putAll(aliases);
                    queryC = queryC.withAliases(new AttributeMap<Attribute>(newAliases));
                }
                return new EsQueryExec(exec.source(), exec.index(), a.output(), queryC);
            }
            return a;
        }

        private Tuple<QueryContainer, AggPathInput> addAggFunction(GroupByKey groupingAgg, AggregateFunction f, Map<CompoundNumericAggregate, String> compoundAggMap, QueryContainer queryC) {
            String functionId = f.functionId();
            if (f instanceof Count) {
                Count c = (Count)f;
                if (c.field().foldable()) {
                    AggRef ref = null;
                    if (groupingAgg == null) {
                        ref = GlobalCountRef.INSTANCE;
                        queryC = queryC.withTrackHits();
                    } else {
                        ref = new GroupByRef(groupingAgg.id(), GroupByRef.Property.COUNT, false);
                    }
                    LinkedHashMap<String, GroupByKey> pseudoFunctions = new LinkedHashMap<String, GroupByKey>(queryC.pseudoFunctions());
                    pseudoFunctions.put(functionId, groupingAgg);
                    return new Tuple((Object)queryC.withPseudoFunctions(pseudoFunctions), (Object)new AggPathInput(f, ref));
                }
                if (!c.distinct()) {
                    LeafAgg leafAgg = QueryTranslator.toAgg(functionId, f);
                    AggPathInput a = new AggPathInput(f, new MetricAggRef(leafAgg.id(), "doc_count", "_count", false));
                    queryC = queryC.with(queryC.aggs().addAgg(leafAgg));
                    return new Tuple((Object)queryC, (Object)a);
                }
            }
            AggPathInput aggInput = null;
            if (f instanceof InnerAggregate) {
                InnerAggregate ia = (InnerAggregate)f;
                CompoundNumericAggregate outer = ia.outer();
                String cAggPath = compoundAggMap.get(outer);
                if (cAggPath == null) {
                    LeafAgg leafAgg = QueryTranslator.toAgg(outer.functionId(), outer);
                    cAggPath = leafAgg.id();
                    compoundAggMap.put(outer, cAggPath);
                    queryC = queryC.with(queryC.aggs().addAgg(leafAgg));
                }
                aggInput = new AggPathInput(f, new MetricAggRef(cAggPath, ia.innerName(), ia.innerKey() != null ? QueryTranslator.nameOf(ia.innerKey()) : null, ia.dataType().isDateBased()));
            } else {
                LeafAgg leafAgg = QueryTranslator.toAgg(functionId, f);
                aggInput = f instanceof TopHits ? new AggPathInput(f, new TopHitsAggRef(leafAgg.id(), f.dataType())) : new AggPathInput(f, new MetricAggRef(leafAgg.id(), f.dataType().isDateBased()));
                queryC = queryC.with(queryC.aggs().addAgg(leafAgg));
            }
            return new Tuple((Object)queryC, (Object)aggInput);
        }
    }

    private static class FoldFilter
    extends FoldingRule<FilterExec> {
        private FoldFilter() {
        }

        @Override
        protected PhysicalPlan rule(FilterExec plan) {
            if (plan.child() instanceof EsQueryExec) {
                EsQueryExec exec = (EsQueryExec)plan.child();
                QueryContainer qContainer = exec.queryContainer();
                QueryTranslator.QueryTranslation qt = QueryTranslator.toQuery(plan.condition(), plan.isHaving());
                Query query = null;
                if (qContainer.query() != null || qt.query != null) {
                    query = QueryTranslator.and(plan.source(), qContainer.query(), qt.query);
                }
                Aggs aggs = this.addPipelineAggs(qContainer, qt, plan);
                qContainer = new QueryContainer(query, aggs, qContainer.fields(), qContainer.aliases(), qContainer.pseudoFunctions(), qContainer.scalarFunctions(), qContainer.sort(), qContainer.limit(), qContainer.shouldTrackHits(), qContainer.shouldIncludeFrozen());
                return exec.with(qContainer);
            }
            return plan;
        }

        private Aggs addPipelineAggs(QueryContainer qContainer, QueryTranslator.QueryTranslation qt, FilterExec fexec) {
            AggFilter filter = qt.aggFilter;
            Aggs aggs = qContainer.aggs();
            if (filter == null) {
                return qContainer.aggs();
            }
            aggs = aggs.addAgg(filter);
            return aggs;
        }
    }

    private static class FoldProject
    extends FoldingRule<ProjectExec> {
        private FoldProject() {
        }

        @Override
        protected PhysicalPlan rule(ProjectExec project) {
            if (project.child() instanceof EsQueryExec) {
                EsQueryExec exec = (EsQueryExec)project.child();
                QueryContainer queryC = exec.queryContainer();
                LinkedHashMap<Attribute, Attribute> aliases = new LinkedHashMap<Attribute, Attribute>(queryC.aliases());
                LinkedHashMap<Attribute, Pipe> processors = new LinkedHashMap<Attribute, Pipe>(queryC.scalarFunctions());
                for (NamedExpression namedExpression : project.projections()) {
                    if (namedExpression instanceof Alias) {
                        Attribute aliasAttr = namedExpression.toAttribute();
                        Expression e = ((Alias)namedExpression).child();
                        if (e instanceof NamedExpression) {
                            Attribute attr = ((NamedExpression)e).toAttribute();
                            aliases.put(aliasAttr, attr);
                            if (!(e instanceof ScalarFunction)) continue;
                            processors.put(attr, Expressions.pipe(e));
                            continue;
                        }
                        processors.put(aliasAttr, Expressions.pipe(e));
                        continue;
                    }
                    if (!(namedExpression instanceof ScalarFunction)) continue;
                    ScalarFunction f = (ScalarFunction)namedExpression;
                    processors.put(f.toAttribute(), Expressions.pipe(f));
                }
                QueryContainer clone = new QueryContainer(queryC.query(), queryC.aggs(), queryC.fields(), new AttributeMap<Attribute>(aliases), queryC.pseudoFunctions(), new AttributeMap<Pipe>(processors), queryC.sort(), queryC.limit(), queryC.shouldTrackHits(), queryC.shouldIncludeFrozen());
                return new EsQueryExec(exec.source(), exec.index(), project.output(), clone);
            }
            return project;
        }
    }
}

