/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.Case;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.IfConditional;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypes;
import org.elasticsearch.xpack.sql.util.CollectionUtils;

public class Iif
extends Case {
    public Iif(Source source, Expression condition, Expression thenResult, Expression elseResult) {
        super(source, Arrays.asList(new IfConditional(source, condition, thenResult), elseResult != null ? elseResult : Literal.NULL));
    }

    Iif(Source source, List<Expression> expressions) {
        super(source, expressions);
    }

    @Override
    protected NodeInfo<? extends Iif> info() {
        return NodeInfo.create(this, Iif::new, CollectionUtils.combine(this.conditions(), this.elseResult()));
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Iif(this.source(), newChildren);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (this.conditions().isEmpty()) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        Expression.TypeResolution conditionTypeResolution = TypeResolutions.isBoolean(this.conditions().get(0).condition(), this.sourceText(), Expressions.ParamOrdinal.FIRST);
        if (conditionTypeResolution.unresolved()) {
            return conditionTypeResolution;
        }
        DataType resultDataType = this.conditions().get(0).dataType();
        if (!DataTypes.areTypesCompatible(resultDataType, this.elseResult().dataType())) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"third argument of [{}] must be [{}], found value [{}] type [{}]", (Object[])new Object[]{this.sourceText(), resultDataType.typeName, Expressions.name(this.elseResult()), this.elseResult().dataType().typeName}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }
}

