/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.Nullability;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;
import org.elasticsearch.xpack.sql.type.DataTypes;
import org.elasticsearch.xpack.sql.util.StringUtils;

public abstract class ConditionalFunction
extends ScalarFunction {
    protected DataType dataType = null;

    ConditionalFunction(Source source, List<Expression> fields) {
        super(source, fields);
    }

    @Override
    public DataType dataType() {
        if (this.dataType == null) {
            this.dataType = DataType.NULL;
            for (Expression exp : this.children()) {
                this.dataType = DataTypeConversion.commonType(this.dataType, exp.dataType());
            }
        }
        return this.dataType;
    }

    @Override
    public boolean foldable() {
        return Expressions.foldable(this.children());
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        DataType dt = DataType.NULL;
        for (int i = 0; i < this.children().size(); ++i) {
            Expression child = (Expression)this.children().get(i);
            if (dt == DataType.NULL) {
                if (Expressions.isNull(child)) continue;
                dt = child.dataType();
                continue;
            }
            if (DataTypes.areTypesCompatible(dt, child.dataType())) continue;
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{} argument of [{}] must be [{}], found value [{}] type [{}]", (Object[])new Object[]{StringUtils.ordinal(i + 1), this.sourceText(), dt.typeName, Expressions.name(child), child.dataType().typeName}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    public Nullability nullable() {
        return Nullability.UNKNOWN;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionalFunction that = (ConditionalFunction)o;
        return this.children().equals(that.children());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.children());
    }
}

