/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.conditional;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.CasePipe;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.ConditionalFunction;
import org.elasticsearch.xpack.sql.expression.predicate.conditional.IfConditional;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;
import org.elasticsearch.xpack.sql.type.DataTypes;

public class Case
extends ConditionalFunction {
    private final List<IfConditional> conditions;
    private final Expression elseResult;

    public Case(Source source, List<Expression> expressions) {
        super(source, expressions);
        this.conditions = expressions.subList(0, expressions.size() - 1);
        this.elseResult = expressions.get(expressions.size() - 1);
    }

    public List<IfConditional> conditions() {
        return this.conditions;
    }

    public Expression elseResult() {
        return this.elseResult;
    }

    @Override
    public DataType dataType() {
        if (this.dataType == null) {
            if (this.conditions.isEmpty()) {
                this.dataType = this.elseResult().dataType();
            } else {
                this.dataType = DataType.NULL;
                for (IfConditional conditional : this.conditions) {
                    this.dataType = DataTypeConversion.commonType(this.dataType, conditional.dataType());
                }
                this.dataType = DataTypeConversion.commonType(this.dataType, this.elseResult.dataType());
            }
        }
        return this.dataType;
    }

    @Override
    public Expression replaceChildren(List<Expression> newChildren) {
        return new Case(this.source(), newChildren);
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create(this, Case::new, this.children());
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        DataType expectedResultDataType = null;
        for (IfConditional ifConditional : this.conditions) {
            if (DataTypes.isNull(ifConditional.result().dataType())) continue;
            expectedResultDataType = ifConditional.result().dataType();
            break;
        }
        if (expectedResultDataType == null) {
            expectedResultDataType = this.elseResult().dataType();
        }
        for (IfConditional conditional : this.conditions) {
            if (conditional.condition().dataType() != DataType.BOOLEAN) {
                return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"condition of [{}] must be [boolean], found value [{}] type [{}]", (Object[])new Object[]{conditional.sourceText(), Expressions.name(conditional.condition()), conditional.condition().dataType().typeName}));
            }
            if (DataTypes.areTypesCompatible(expectedResultDataType, conditional.dataType())) continue;
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"result of [{}] must be [{}], found value [{}] type [{}]", (Object[])new Object[]{conditional.sourceText(), expectedResultDataType.typeName, Expressions.name(conditional.result()), conditional.dataType().typeName}));
        }
        if (!DataTypes.areTypesCompatible(expectedResultDataType, this.elseResult.dataType())) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"ELSE clause of [{}] must be [{}], found value [{}] type [{}]", (Object[])new Object[]{this.elseResult.sourceText(), expectedResultDataType.typeName, Expressions.name(this.elseResult), this.elseResult.dataType().typeName}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    @Override
    public boolean foldable() {
        return this.conditions.isEmpty() && this.elseResult.foldable() || this.conditions.size() == 1 && this.conditions.get(0).condition().foldable() && this.conditions.get(0).result().foldable();
    }

    @Override
    public Object fold() {
        if (!this.conditions.isEmpty() && this.conditions.get(0).condition().fold() == Boolean.TRUE) {
            return this.conditions.get(0).result().fold();
        }
        return this.elseResult.fold();
    }

    @Override
    protected Pipe makePipe() {
        ArrayList<Pipe> pipes = new ArrayList<Pipe>(this.conditions.size() + 1);
        for (IfConditional ifConditional : this.conditions) {
            pipes.add(Expressions.pipe(ifConditional.condition()));
            pipes.add(Expressions.pipe(ifConditional.result()));
        }
        pipes.add(Expressions.pipe(this.elseResult));
        return new CasePipe(this.source(), this, pipes);
    }

    @Override
    public ScriptTemplate asScript() {
        ArrayList<ScriptTemplate> templates = new ArrayList<ScriptTemplate>();
        for (IfConditional ifConditional : this.conditions) {
            templates.add(this.asScript(ifConditional.condition()));
            templates.add(this.asScript(ifConditional.result()));
        }
        templates.add(this.asScript(this.elseResult));
        StringJoiner template = new StringJoiner(",", "{sql}.caseFunction([", "])");
        ParamsBuilder params = ParamsBuilder.paramsBuilder();
        for (ScriptTemplate scriptTemplate : templates) {
            template.add(scriptTemplate.template());
            params.script(scriptTemplate.params());
        }
        return new ScriptTemplate(this.formatTemplate(template.toString()), params.build(), this.dataType());
    }
}

