/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.gen.script;

import java.time.Duration;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.function.aggregate.AggregateFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.function.grouping.GroupingFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.ScalarFunctionAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.geo.GeoShape;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.expression.gen.script.Scripts;
import org.elasticsearch.xpack.sql.expression.literal.IntervalDayTime;
import org.elasticsearch.xpack.sql.expression.literal.IntervalYearMonth;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.util.DateUtils;

public interface ScriptWeaver {
    default public ScriptTemplate asScript(Expression exp) {
        if (exp.foldable()) {
            return this.scriptWithFoldable(exp);
        }
        Attribute attr = Expressions.attribute(exp);
        if (attr != null) {
            if (attr instanceof ScalarFunctionAttribute) {
                return this.scriptWithScalar((ScalarFunctionAttribute)attr);
            }
            if (attr instanceof AggregateFunctionAttribute) {
                return this.scriptWithAggregate((AggregateFunctionAttribute)attr);
            }
            if (attr instanceof GroupingFunctionAttribute) {
                return this.scriptWithGrouping((GroupingFunctionAttribute)attr);
            }
            if (attr instanceof FieldAttribute) {
                return this.scriptWithField((FieldAttribute)attr);
            }
        }
        throw new SqlIllegalArgumentException("Cannot evaluate script for expression {}", exp);
    }

    default public ScriptTemplate asOptionalScript(Expression exp) {
        return exp == null ? this.asScript(Literal.NULL) : this.asScript(exp);
    }

    public DataType dataType();

    default public ScriptTemplate scriptWithFoldable(Expression foldable) {
        Object fold = foldable.fold();
        if (fold instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)fold;
            return new ScriptTemplate(this.processScript("{sql}.asDateTime({})"), ParamsBuilder.paramsBuilder().variable(DateUtils.toString(zdt)).build(), this.dataType());
        }
        if (fold instanceof IntervalYearMonth) {
            IntervalYearMonth iym = (IntervalYearMonth)fold;
            return new ScriptTemplate(this.processScript("{sql}.intervalYearMonth({},{})"), ParamsBuilder.paramsBuilder().variable(((Period)iym.interval()).toString()).variable(iym.dataType().name()).build(), this.dataType());
        }
        if (fold instanceof IntervalDayTime) {
            IntervalDayTime idt = (IntervalDayTime)fold;
            return new ScriptTemplate(this.processScript("{sql}.intervalDayTime({},{})"), ParamsBuilder.paramsBuilder().variable(((Duration)idt.interval()).toString()).variable(idt.dataType().name()).build(), this.dataType());
        }
        if (fold instanceof OffsetTime) {
            OffsetTime ot = (OffsetTime)fold;
            return new ScriptTemplate(this.processScript("{sql}.asTime({})"), ParamsBuilder.paramsBuilder().variable(ot.toString()).build(), this.dataType());
        }
        if (fold instanceof GeoShape) {
            GeoShape geoShape = (GeoShape)fold;
            return new ScriptTemplate(this.processScript("{sql}.stWktToSql({})"), ParamsBuilder.paramsBuilder().variable(geoShape.toString()).build(), this.dataType());
        }
        return new ScriptTemplate(this.processScript("{}"), ParamsBuilder.paramsBuilder().variable(fold).build(), this.dataType());
    }

    default public ScriptTemplate scriptWithScalar(ScalarFunctionAttribute scalar) {
        ScriptTemplate nested = scalar.script();
        return new ScriptTemplate(this.processScript(nested.template()), ParamsBuilder.paramsBuilder().script(nested.params()).build(), this.dataType());
    }

    default public ScriptTemplate scriptWithAggregate(AggregateFunctionAttribute aggregate) {
        String template = "{}";
        if (aggregate.dataType().isDateBased()) {
            template = "{sql}.asDateTime({})";
        }
        return new ScriptTemplate(this.processScript(template), ParamsBuilder.paramsBuilder().agg(aggregate).build(), this.dataType());
    }

    default public ScriptTemplate scriptWithGrouping(GroupingFunctionAttribute grouping) {
        String template = "{}";
        if (grouping.dataType().isDateBased()) {
            template = "{sql}.asDateTime({})";
        }
        return new ScriptTemplate(this.processScript(template), ParamsBuilder.paramsBuilder().grouping(grouping).build(), this.dataType());
    }

    default public ScriptTemplate scriptWithField(FieldAttribute field) {
        return new ScriptTemplate(this.processScript("doc[{}].value"), ParamsBuilder.paramsBuilder().variable(field.name()).build(), this.dataType());
    }

    default public String processScript(String script) {
        return this.formatTemplate(script);
    }

    default public String formatTemplate(String template) {
        return Scripts.formatTemplate(template);
    }
}

