/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.gen.pipeline;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.sql.capabilities.Resolvable;
import org.elasticsearch.xpack.sql.capabilities.Resolvables;
import org.elasticsearch.xpack.sql.execution.search.FieldExtraction;
import org.elasticsearch.xpack.sql.execution.search.SqlSourceBuilder;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.tree.Node;
import org.elasticsearch.xpack.sql.tree.Source;

public abstract class Pipe
extends Node<Pipe>
implements FieldExtraction,
Resolvable {
    private final Expression expression;

    public Pipe(Source source, Expression expression, List<Pipe> children) {
        super(source, children);
        this.expression = expression;
    }

    public Expression expression() {
        return this.expression;
    }

    @Override
    public boolean resolved() {
        return Resolvables.resolved(this.children());
    }

    @Override
    public void collectFields(SqlSourceBuilder sourceBuilder) {
        this.children().forEach(c -> c.collectFields(sourceBuilder));
    }

    @Override
    public boolean supportedByAggsOnlyQuery() {
        return this.children().stream().anyMatch(Pipe::supportedByAggsOnlyQuery);
    }

    public abstract Processor asProcessor();

    public Pipe resolveAttributes(AttributeResolver resolver) {
        ArrayList<Pipe> newPipes = new ArrayList<Pipe>(this.children().size());
        for (Pipe p : this.children()) {
            newPipes.add(p.resolveAttributes(resolver));
        }
        return this.children().equals(newPipes) ? this : (Pipe)this.replaceChildren(newPipes);
    }

    public static interface AttributeResolver {
        public FieldExtraction resolve(Attribute var1);
    }
}

