/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.ZoneId;
import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;

abstract class BaseDateTimeFunction
extends UnaryScalarFunction {
    private final ZoneId zoneId;

    BaseDateTimeFunction(Source source, Expression field, ZoneId zoneId) {
        super(source, field);
        this.zoneId = zoneId;
    }

    @Override
    protected final NodeInfo<BaseDateTimeFunction> info() {
        return NodeInfo.create(this, this.ctorForInfo(), this.field(), this.zoneId());
    }

    protected abstract NodeInfo.NodeCtor2<Expression, ZoneId, BaseDateTimeFunction> ctorForInfo();

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isDate(this.field(), this.sourceText(), Expressions.ParamOrdinal.DEFAULT);
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    @Override
    public boolean foldable() {
        return this.field().foldable();
    }

    @Override
    public Object fold() {
        return this.makeProcessor().process(this.field().fold());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        BaseDateTimeFunction other = (BaseDateTimeFunction)obj;
        return Objects.equals(other.field(), this.field()) && Objects.equals(other.zoneId(), this.zoneId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field(), this.zoneId());
    }
}

